/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.symbols;

import gov.llnl.babel.symbols.SymbolUtilities;
import gov.llnl.babel.symbols.Type;

public class Argument {
    public static final int IN = 0;
    public static final int INOUT = 1;
    public static final int OUT = 2;
    private boolean d_copy;
    private String d_formal_name;
    private int d_mode;
    private Type d_type;

    public Argument(boolean copy, int mode, Type type, String name) {
        this.d_copy = copy;
        this.d_formal_name = name;
        this.d_mode = mode;
        this.d_type = type;
    }

    public boolean isCopy() {
        return this.d_copy;
    }

    public int getMode() {
        return this.d_mode;
    }

    public String getFormalName() {
        return this.d_formal_name;
    }

    public Type getType() {
        return this.d_type;
    }

    public boolean hasArrayOrderSpec() {
        return this.d_type.hasArrayOrderSpec();
    }

    public String getArgumentString(String abbrev_pkg) {
        StringBuffer arg = new StringBuffer();
        if (this.d_copy) {
            arg.append("copy ");
        }
        switch (this.d_mode) {
            case 0: {
                arg.append("in ");
                break;
            }
            case 1: {
                arg.append("inout ");
                break;
            }
            case 2: {
                arg.append("out ");
            }
        }
        String rtype = this.d_type.getTypeString();
        if (abbrev_pkg != null) {
            arg.append(SymbolUtilities.getSymbolName(rtype, abbrev_pkg));
        } else {
            arg.append(rtype);
        }
        arg.append(" ");
        arg.append(this.d_formal_name);
        return arg.toString();
    }

    public String getArgumentString() {
        return this.getArgumentString(null);
    }

    public boolean equals(Object object) {
        boolean eq = false;
        if (object != null && object instanceof Argument) {
            Argument arg = (Argument)object;
            eq = this.d_copy == arg.d_copy && this.d_mode == arg.d_mode && this.d_type.equals(arg.d_type);
        }
        return eq;
    }

    static {
        IN = 0;
        INOUT = 1;
        OUT = 2;
    }
}

