/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.symbols;

import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Interface;
import gov.llnl.babel.symbols.Metadata;
import gov.llnl.babel.symbols.SymbolID;
import java.util.Collection;
import java.util.HashSet;

public class Class
extends Extendable {
    private Class d_parent_class = null;

    public Class(SymbolID id, Comment comment) {
        super(id, 12, comment);
    }

    public Class(SymbolID id, Comment comment, Metadata metadata) {
        super(id, 12, comment, metadata);
    }

    public boolean isAbstract() {
        return !this.getAbstractMethods().isEmpty();
    }

    public boolean isInterface() {
        return false;
    }

    public boolean hasStaticMethod(boolean all) {
        return !this.getStaticMethods(all).isEmpty();
    }

    public void addParentInterface(Interface parent) {
        this.addParentData(parent);
    }

    public void setParentClass(Class parent) {
        this.d_parent_class = parent;
        this.addParentData(parent);
    }

    public Class getParentClass() {
        return this.d_parent_class;
    }

    public Collection getParents(boolean all) {
        Collection interfaces = this.getParentInterfaces(all);
        HashSet<Class> result = new HashSet<Class>(interfaces.size() + 1);
        Class parentClass = this.getParentClass();
        result.addAll(interfaces);
        if (parentClass != null) {
            result.add(parentClass);
            if (all) {
                while (parentClass != null) {
                    if ((parentClass = parentClass.getParentClass()) == null) continue;
                    result.add(parentClass);
                }
            }
        }
        return result;
    }

    public boolean hasParentClass(SymbolID id, boolean all) {
        if (this.d_parent_class != null) {
            if (this.d_parent_class.getSymbolID().equals(id)) {
                return true;
            }
            if (all) {
                return this.d_parent_class.hasParentClass(id, true);
            }
        }
        return false;
    }
}

