/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.symbols;

import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolNotFoundException;
import gov.llnl.babel.symbols.SymbolRedefinitionException;
import gov.llnl.babel.symbols.SymbolResolver;
import gov.llnl.babel.symbols.Version;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class SymbolTable
implements SymbolResolver {
    private static SymbolTable s_instance = null;
    private HashMap d_fqn_to_id = new HashMap();
    private HashSet d_modified = new HashSet();
    private ArrayList d_resolvers = new ArrayList();
    private HashMap d_table = new HashMap();

    public static SymbolTable getInstance() {
        if (s_instance == null) {
            s_instance = new SymbolTable();
        }
        return s_instance;
    }

    public static void setInstance(SymbolTable instance) {
        s_instance = instance;
    }

    public Map getTable() {
        return this.d_table;
    }

    public Set getSymbolNames() {
        return this.d_table.keySet();
    }

    public Set getModifiedSymbolNames() {
        return this.d_modified;
    }

    public void markSymbolAsModified(SymbolID id) {
        if (this.d_table.containsKey(id)) {
            this.d_modified.add(id);
        }
    }

    public Symbol lookupSymbol(String fqn) {
        return (Symbol)this.d_table.get(this.d_fqn_to_id.get(fqn));
    }

    public Symbol lookupSymbol(SymbolID id) {
        return (Symbol)this.d_table.get(id);
    }

    public void addSymbolResolver(SymbolResolver resolver) {
        if (resolver != null) {
            this.d_resolvers.add(resolver);
        }
    }

    public Symbol resolveSymbol(String fqn) {
        Symbol s = this.lookupSymbol(fqn);
        if (s == null) {
            Iterator i = this.d_resolvers.iterator();
            while (i.hasNext()) {
                SymbolResolver resolver = (SymbolResolver)i.next();
                Symbol t = resolver.lookupSymbol(fqn);
                if (t == null) continue;
                if (s == null) {
                    s = t;
                    continue;
                }
                Version sv = s.getSymbolID().getVersion();
                Version tv = t.getSymbolID().getVersion();
                if (!tv.isGreaterThan(sv)) continue;
                s = t;
            }
            if (s != null) {
                SymbolID id = s.getSymbolID();
                this.d_fqn_to_id.put(fqn, id);
                this.d_table.put(id, s);
            }
        }
        return s;
    }

    public Symbol resolveSymbol(SymbolID id) throws SymbolRedefinitionException {
        Symbol s = this.lookupSymbol(id.getFullName());
        if (s != null && !s.getSymbolID().getVersion().isSame(id.getVersion())) {
            throw new SymbolRedefinitionException(id, s.getSymbolID());
        }
        if (s == null) {
            Iterator i = this.d_resolvers.iterator();
            while (i.hasNext()) {
                SymbolResolver resolver = (SymbolResolver)i.next();
                s = resolver.lookupSymbol(id);
                if (s == null) continue;
                this.d_fqn_to_id.put(id.getFullName(), id);
                this.d_table.put(id, s);
                break;
            }
        }
        return s;
    }

    public void putSymbol(Symbol symbol) throws SymbolRedefinitionException {
        SymbolID id = symbol.getSymbolID();
        String fqn = id.getFullName();
        Symbol s1 = this.lookupSymbol(fqn);
        if (s1 != null) {
            throw new SymbolRedefinitionException(id, s1.getSymbolID());
        }
        Symbol s2 = this.resolveSymbol(id);
        if (s2 != null) {
            throw new SymbolRedefinitionException(id, s2.getSymbolID());
        }
        this.d_fqn_to_id.put(fqn, id);
        this.d_table.put(id, symbol);
        this.d_modified.add(id);
    }

    public Set generateDependencies(Set symbols) throws SymbolNotFoundException, SymbolRedefinitionException {
        HashSet<SymbolID> dependencies = null;
        if (symbols != null && !symbols.isEmpty()) {
            dependencies = new HashSet<SymbolID>();
            LinkedList<SymbolID> work = new LinkedList<SymbolID>(symbols);
            while (!work.isEmpty()) {
                SymbolID id = (SymbolID)work.removeFirst();
                if (dependencies.contains(id)) continue;
                dependencies.add(id);
                Symbol symbol = this.resolveSymbol(id);
                if (symbol == null) {
                    throw new SymbolNotFoundException(id);
                }
                Set refs = symbol.getSymbolReferences();
                if (refs == null) continue;
                Iterator i = refs.iterator();
                while (i.hasNext()) {
                    SymbolID sid = (SymbolID)i.next();
                    if (dependencies.contains(sid)) continue;
                    work.addLast(sid);
                }
            }
        }
        return dependencies;
    }

    public void resolveAllReferences() throws SymbolNotFoundException, SymbolRedefinitionException {
        this.generateDependencies(this.d_table.keySet());
        this.verifyReferences();
    }

    private void resolveParents(Symbol sym) {
        String fullname = sym.getFullName();
        StringBuffer buf = new StringBuffer(fullname.length() + 1);
        StringTokenizer tok = new StringTokenizer(fullname, ".");
        while (tok.hasMoreTokens()) {
            buf.append(tok.nextToken());
            this.resolveSymbol(buf.toString());
            buf.append('.');
        }
    }

    public void resolveAllParents() throws SymbolNotFoundException {
        ArrayList symbols = new ArrayList(this.d_table.values());
        Iterator i = symbols.iterator();
        while (i.hasNext()) {
            this.resolveParents((Symbol)i.next());
        }
    }

    public void verifyReferences() throws SymbolNotFoundException {
        Iterator i = this.d_table.values().iterator();
        while (i.hasNext()) {
            Set refs = ((Symbol)i.next()).getSymbolReferences();
            if (refs == null) continue;
            Iterator r = refs.iterator();
            while (r.hasNext()) {
                SymbolID id = (SymbolID)r.next();
                if (this.lookupSymbol(id) != null) continue;
                throw new SymbolNotFoundException(id);
            }
        }
    }
}

