/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.symbols;

import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;

public class Type {
    public static final int VOID = 0;
    public static final int BOOLEAN = 1;
    public static final int CHAR = 2;
    public static final int DCOMPLEX = 3;
    public static final int DOUBLE = 4;
    public static final int FCOMPLEX = 5;
    public static final int FLOAT = 6;
    public static final int INT = 7;
    public static final int LONG = 8;
    public static final int OPAQUE = 9;
    public static final int STRING = 10;
    public static final int ENUM = 11;
    public static final int CLASS = 12;
    public static final int INTERFACE = 13;
    public static final int PACKAGE = 14;
    public static final int SYMBOL = 15;
    public static final int ARRAY = 16;
    private static final String[] s_names;
    public static final int UNSPECIFIED = 0;
    public static final int COLUMN_MAJOR = 1;
    public static final int ROW_MAJOR = 2;
    private static final String[] s_order;
    private int d_type;
    private SymbolID d_symbol_id;
    private Type d_array_type;
    private int d_array_dim;
    private int d_array_order;

    public Type(int type) {
        this.d_type = type;
        this.d_symbol_id = null;
        this.d_array_type = null;
        this.d_array_dim = 0;
        this.d_array_order = 0;
    }

    public Type(SymbolID id) {
        this.d_type = 15;
        this.d_symbol_id = id;
        this.d_array_type = null;
        this.d_array_dim = 0;
        this.d_array_order = 0;
    }

    public Type(Type type, int dim, int order) {
        this.d_type = 16;
        this.d_symbol_id = null;
        this.d_array_type = type;
        this.d_array_dim = dim;
        this.d_array_order = order;
    }

    public int getType() {
        int type = this.getDetailedType();
        if (type == 11 || type == 13 || type == 12 || type == 14) {
            type = 15;
        }
        return type;
    }

    public int getDetailedType() {
        if (this.d_type == 15) {
            try {
                Symbol s = SymbolTable.getInstance().lookupSymbol(this.d_symbol_id);
                if (s != null) {
                    int symbolType = s.getSymbolType();
                    switch (symbolType) {
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: {
                            this.d_type = symbolType;
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.d_type;
    }

    public boolean isPrimitive() {
        return this.d_type <= 10;
    }

    public boolean isString() {
        return this.d_type == 10;
    }

    public boolean isSymbol() {
        return this.getType() == 15;
    }

    public boolean isArray() {
        return this.d_type == 16;
    }

    public int getArrayDimension() {
        return this.d_array_dim;
    }

    public int getArrayOrder() {
        return this.d_array_order;
    }

    public Type getArrayType() {
        return this.d_array_type;
    }

    public boolean hasArrayOrderSpec() {
        return this.d_type == 16 && this.d_array_order != 0;
    }

    public SymbolID getSymbolID() {
        return this.d_symbol_id;
    }

    public String getTypeString() {
        StringBuffer s = new StringBuffer();
        int type = this.getType();
        if (type == 15) {
            s.append(this.d_symbol_id.getFullName());
        } else if (type == 16) {
            s.append("array<" + this.d_array_type.getTypeString());
            if (this.d_array_dim > 1) {
                s.append("," + this.d_array_dim);
            }
            if (0 < this.d_array_order && this.d_array_order <= 2) {
                s.append("," + s_order[this.d_array_order]);
            }
            s.append(">");
        } else if (type >= 0 && type <= 10) {
            s.append(s_names[this.d_type]);
        }
        return s.toString();
    }

    public boolean equals(Object object) {
        boolean eq = false;
        if (object != null && object instanceof Type) {
            int your_type;
            Type t = (Type)object;
            int my_type = this.getType();
            if (my_type == (your_type = t.getType())) {
                eq = my_type == 15 ? this.d_symbol_id.equals(t.d_symbol_id) : (my_type == 16 ? this.d_array_type.equals(t.d_array_type) && this.d_array_dim == t.d_array_dim && this.d_array_order == t.d_array_order : true);
            }
        }
        return eq;
    }

    static {
        VOID = 0;
        BOOLEAN = 1;
        CHAR = 2;
        DCOMPLEX = 3;
        DOUBLE = 4;
        FCOMPLEX = 5;
        FLOAT = 6;
        INT = 7;
        LONG = 8;
        OPAQUE = 9;
        STRING = 10;
        ENUM = 11;
        CLASS = 12;
        INTERFACE = 13;
        PACKAGE = 14;
        SYMBOL = 15;
        ARRAY = 16;
        s_names = new String[]{"void", "bool", "char", "dcomplex", "double", "fcomplex", "float", "int", "long", "opaque", "string", "enum", "interface", "class"};
        UNSPECIFIED = 0;
        COLUMN_MAJOR = 1;
        ROW_MAJOR = 2;
        s_order = new String[]{"unspecified", "column-major", "row-major"};
    }
}

