//
// File:        CollectionException.java
// Package:     gov.llnl.babel
// Copyright:   (c) 2003 The Regents of the University of California
// Release:     $Name: release-0-8-8 $
// Revision:    @(#) $Revision: 1.1 $
// Date:        $Date: 2003/01/14 18:41:59 $
// Description: An exception to hold a collection of exceptions
// 

package gov.llnl.babel;

import java.util.LinkedList;
import java.util.List;
import java.util.Collections;
import java.util.Iterator;

/**
 * When parsing a collection of files, it is better to collect all the
 * exceptions until the end instead of bailing out on the first exception.
 * This exception class holds a collection of other exceptions.
 */
public class CollectionException extends Exception
{
  final private static String EOL="\n";
  
  /**
   * This struct exists to hold the (uri, exception) pair that makes
   * up each element of the collection.
   */
  final public static class UriExceptionPair {
    private String    d_uri;
    private Exception d_exception;

    public UriExceptionPair(String uri, Exception ex)
    {
      d_uri = uri;
      d_exception = ex;
    }
    
    public String getUri()
    {
      return d_uri;
    }
    
    public Exception getException()
    {
      return d_exception;
    }
  }

  List d_exceptions = new LinkedList();

  public CollectionException(String uri, Exception ex)
  {
    addException(uri, ex);
  }

  public void addException(String uri, Exception ex)
  {
    UriExceptionPair uep = new UriExceptionPair(uri, ex);
    d_exceptions.add(uep);
  }

  public String getMessage()
  {
    StringBuffer buf = new StringBuffer();
    Iterator i = d_exceptions.iterator();
    while(i.hasNext()) {
      UriExceptionPair uep = (UriExceptionPair)i.next();
      buf.append("Babel: ");
      buf.append(uep.getException().getClass().getName());
      if (uep.getUri() != null) {
        buf.append(" when parsing URL \"");
        buf.append(uep.getUri());
        buf.append("\"...");
      }
      buf.append(EOL);
      buf.append(uep.getException().getMessage());
      buf.append(EOL);
    }
    return buf.toString();
  }
}
