/*********************************************************************
* File:        SIDL_dcomplex_fStub.c
* Copyright:   (C) 2001-2002 The Regents of the University of California
* Description: FORTRAN API for arrays of dcomplex
* Revision:    $Revision: 1.2 $
*
* AUTOMATICALLY GENERATED BY genfortranarrays.py
**********************************************************************/

#include "SIDL_header.h"
#ifndef included_babel_config_h
#include "babel_config.h"
#endif
#include "SIDLfortran.h"
#ifndef included_SIDLType_h
#include "SIDLType.h"
#endif
#ifndef included_SIDLArray_h
#include "SIDLArray.h"
#endif
#ifndef FORTRAN90_DISABLED
#include "SIDLf90array.h"
#endif
#include <stdlib.h>
#include <stddef.h>


#ifndef FORTRAN77_DISABLED
/*---------------------------------------------------------------------*
 * Fortran 77 Array Routines
 *---------------------------------------------------------------------*/


void
SIDLFortran77Symbol(sidl_dcomplex__array_createcol_f,
                    SIDL_DCOMPLEX__ARRAY_CREATECOL_F,
                    SIDL_dcomplex__array_createCol_f)
  (int32_t *dimen, int32_t lower[], int32_t upper[], int64_t *result)
{
  *result = (ptrdiff_t)
    SIDL_dcomplex__array_createCol(*dimen, lower, upper);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_createrow_f,
                    SIDL_DCOMPLEX__ARRAY_CREATEROW_F,
                    SIDL_dcomplex__array_createRow_f)
  (int32_t *dimen, int32_t lower[], int32_t upper[], int64_t *result)
{
  *result = (ptrdiff_t)
    SIDL_dcomplex__array_createRow(*dimen, lower, upper);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_create1d_f,
                    SIDL_DCOMPLEX__ARRAY_CREATE1D_F,
                    SIDL_dcomplex__array_create1d_f)
  (int32_t *len, int64_t *result)
{
  *result = (ptrdiff_t)
    SIDL_dcomplex__array_create1d(*len);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_create2drow_f,
                    SIDL_DCOMPLEX__ARRAY_CREATE2DROW_F,
                    SIDL_dcomplex__array_create2dRow_f)
  (int32_t *m, int32_t *n, int64_t *result)
{
  *result = (ptrdiff_t)
    SIDL_dcomplex__array_create2dRow(*m, *n);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_create2dcol_f,
                    SIDL_DCOMPLEX__ARRAY_CREATE2DCOL_F,
                    SIDL_dcomplex__array_create2dCol_f)
  (int32_t *m, int32_t *n, int64_t *result)
{
  *result = (ptrdiff_t)
    SIDL_dcomplex__array_create2dCol(*m, *n);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_ensure_f,
                    SIDL_DCOMPLEX__ARRAY_ENSURE_F,
                    SIDL_dcomplex__array_ensure_f)
  (int64_t *src, int32_t *dimen, int32_t *ordering, int64_t *result)
{
  *result = (ptrdiff_t)
     SIDL_dcomplex__array_ensure((struct SIDL_dcomplex__array*)(ptrdiff_t)*src,
                           *dimen, (int)*ordering);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_smartcopy_f,
                    SIDL_DCOMPLEX__ARRAY_SMARTCOPY_F,
                    SIDL_dcomplex__array_smartCopy_f)
  (int64_t *src, int64_t *result)
{
  *result = (ptrdiff_t)
    SIDL_dcomplex__array_smartCopy((struct SIDL_dcomplex__array*)(ptrdiff_t)*src);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_slice_f,
                    SIDL_DCOMPLEX__ARRAY_SLICE_F,
                    SIDL_dcomplex__array_slice_f)
  (int64_t *src, int32_t *dimen, int32_t numElem[], int32_t srcStart[],
   int32_t srcStride[], int32_t newStart[], int64_t *result)
{
  *result = (ptrdiff_t)
    SIDL_dcomplex__array_slice((struct SIDL_dcomplex__array *)(ptrdiff_t)*src,
                         *dimen, numElem, srcStart, srcStride, newStart);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_copy_f,
                    SIDL_DCOMPLEX__ARRAY_COPY_F,
                    SIDL_dcomplex__array_copy_f)
  (int64_t *src, int64_t *dest)
{
  SIDL_dcomplex__array_copy((struct SIDL_dcomplex__array*)(ptrdiff_t)*src,
                      (struct SIDL_dcomplex__array*)(ptrdiff_t)*dest);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_iscolumnorder_f,
                    SIDL_DCOMPLEX__ARRAY_ISCOLUMNORDER_F,
                    SIDL_dcomplex__array_isColumnOrder_f)
  (int64_t *array, SIDL_bool *result)
{
  *result = (
    SIDL_dcomplex__array_isColumnOrder((struct SIDL_dcomplex__array *)(ptrdiff_t)*array)
    ? SIDL_F77_TRUE : SIDL_F77_FALSE);
}

void
SIDLFortran77Symbol(sidl_dcomplex__array_isroworder_f,
                    SIDL_DCOMPLEX__ARRAY_ISROWORDER_F,
                    SIDL_dcomplex__array_isRowOrder_f)
  (int64_t *array, SIDL_bool *result)
{
  *result = (
    SIDL_dcomplex__array_isRowOrder((struct SIDL_dcomplex__array *)(ptrdiff_t)*array)
    ? SIDL_F77_TRUE : SIDL_F77_FALSE);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_dimen_f,
                    SIDL_DCOMPLEX__ARRAY_DIMEN_F,
                    SIDL_dcomplex__array_dimen_f)
  (int64_t *array, int32_t *result)
{
  *result =
    SIDL_dcomplex__array_dimen((struct SIDL_dcomplex__array *)(ptrdiff_t)*array);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_stride_f,
                    SIDL_DCOMPLEX__ARRAY_STRIDE_F,
                    SIDL_dcomplex__array_stride_f)
  (int64_t *array, int32_t *index, int32_t *result)
{
  *result =
    SIDL_dcomplex__array_stride((struct SIDL_dcomplex__array *)(ptrdiff_t)*array, *index);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_lower_f,
                    SIDL_DCOMPLEX__ARRAY_LOWER_F,
                    SIDL_dcomplex__array_lower_f)
  (int64_t *array, int32_t*ind, int32_t *result)
{
  *result =
    SIDL_dcomplex__array_lower((struct SIDL_dcomplex__array *)(ptrdiff_t)*array, *ind);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_upper_f,
                    SIDL_DCOMPLEX__ARRAY_UPPER_F,
                    SIDL_dcomplex__array_upper_f)
  (int64_t *array, int32_t *ind, int32_t *result)
{
  *result =
    SIDL_dcomplex__array_upper((struct SIDL_dcomplex__array *)(ptrdiff_t)*array, *ind);
}

void
SIDLFortran77Symbol(sidl_dcomplex__array_deleteref_f,
                    SIDL_DCOMPLEX__ARRAY_DELETEREF_F,
                    SIDL_dcomplex__array_deleteRef_f)
  (int64_t *array)
{
  SIDL_dcomplex__array_deleteRef((struct SIDL_dcomplex__array*)(ptrdiff_t)*array);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_addref_f,
                    SIDL_DCOMPLEX__ARRAY_ADDREF_F,
                    SIDL_dcomplex__array_addRef_f)
  (int64_t *array)
{
  SIDL_dcomplex__array_addRef((struct SIDL_dcomplex__array*)(ptrdiff_t)*array);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_borrow_f,
                    SIDL_DCOMPLEX__ARRAY_BORROW_F,
                    SIDL_dcomplex__array_borrow_f)
  (struct SIDL_dcomplex *firstElement, int32_t *dimen, int32_t lower[], int32_t upper[], int32_t stride[], int64_t *result)
{
  *result = (ptrdiff_t)
    SIDL_dcomplex__array_borrow(firstElement, 
                               *dimen,
                               lower,
                               upper,
                               stride);
}


/**
 * NOTE: THERE IS THE POTENTIAL FOR POINTER ALIGNMENT PROBLEMS WITH
 * THIS FUNCTION.  If index is zero on return, the array pointer
 * and ref are not properly aligned!
 */
void
SIDLFortran77Symbol(sidl_dcomplex__array_access_f,
                    SIDL_DCOMPLEX__ARRAY_ACCESS_F,
                    SIDL_dcomplex__array_access_f)
  (int64_t *array,
   double *ref,
   int32_t * restrict lower,
   int32_t * restrict upper,
   int32_t * restrict stride,
   int32_t * restrict index)
{
  struct SIDL_dcomplex__array *ary = (struct SIDL_dcomplex__array *)
    (ptrdiff_t)*array;
  const int32_t dimen = SIDLArrayDim(ary);
  int32_t i;
  for(i = 0; i < dimen; ++i){
    lower[i] = SIDLLower(ary, i);
    upper[i] = SIDLUpper(ary, i);
    stride[i] = SIDLStride(ary, i);
  }
  if (((((ptrdiff_t)(ary->d_firstElement)) -
        ((ptrdiff_t)ref)) % sizeof(double)) == 0) {
    *index = ((double *)(ary->d_firstElement) - ref) + 1;
  }
  else {
    *index = 0;
  }
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_get1_f,
                    SIDL_DCOMPLEX__ARRAY_GET1_F,
                    SIDL_dcomplex__array_get1_f)
  (int64_t *array,   int32_t *i1,
   struct SIDL_dcomplex *result)
{
  *result = 
    SIDL_dcomplex__array_get1((struct SIDL_dcomplex__array *)(ptrdiff_t)*array,
     *i1);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_set1_f,
                    SIDL_DCOMPLEX__ARRAY_SET1_F,
                    SIDL_dcomplex__array_set1_f)
  (int64_t *array,   int32_t *i1,
   struct SIDL_dcomplex *value)
{
  SIDL_dcomplex__array_set1((struct SIDL_dcomplex__array *)(ptrdiff_t)*array,
   *i1,
   *value);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_get2_f,
                    SIDL_DCOMPLEX__ARRAY_GET2_F,
                    SIDL_dcomplex__array_get2_f)
  (int64_t *array,   int32_t *i1,
   int32_t *i2,
   struct SIDL_dcomplex *result)
{
  *result = 
    SIDL_dcomplex__array_get2((struct SIDL_dcomplex__array *)(ptrdiff_t)*array,
     *i1,
     *i2);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_set2_f,
                    SIDL_DCOMPLEX__ARRAY_SET2_F,
                    SIDL_dcomplex__array_set2_f)
  (int64_t *array,   int32_t *i1,
   int32_t *i2,
   struct SIDL_dcomplex *value)
{
  SIDL_dcomplex__array_set2((struct SIDL_dcomplex__array *)(ptrdiff_t)*array,
   *i1,
   *i2,
   *value);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_get3_f,
                    SIDL_DCOMPLEX__ARRAY_GET3_F,
                    SIDL_dcomplex__array_get3_f)
  (int64_t *array,   int32_t *i1,
   int32_t *i2,
   int32_t *i3,
   struct SIDL_dcomplex *result)
{
  *result = 
    SIDL_dcomplex__array_get3((struct SIDL_dcomplex__array *)(ptrdiff_t)*array,
     *i1,
     *i2,
     *i3);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_set3_f,
                    SIDL_DCOMPLEX__ARRAY_SET3_F,
                    SIDL_dcomplex__array_set3_f)
  (int64_t *array,   int32_t *i1,
   int32_t *i2,
   int32_t *i3,
   struct SIDL_dcomplex *value)
{
  SIDL_dcomplex__array_set3((struct SIDL_dcomplex__array *)(ptrdiff_t)*array,
   *i1,
   *i2,
   *i3,
   *value);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_get4_f,
                    SIDL_DCOMPLEX__ARRAY_GET4_F,
                    SIDL_dcomplex__array_get4_f)
  (int64_t *array,   int32_t *i1,
   int32_t *i2,
   int32_t *i3,
   int32_t *i4,
   struct SIDL_dcomplex *result)
{
  *result = 
    SIDL_dcomplex__array_get4((struct SIDL_dcomplex__array *)(ptrdiff_t)*array,
     *i1,
     *i2,
     *i3,
     *i4);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_set4_f,
                    SIDL_DCOMPLEX__ARRAY_SET4_F,
                    SIDL_dcomplex__array_set4_f)
  (int64_t *array,   int32_t *i1,
   int32_t *i2,
   int32_t *i3,
   int32_t *i4,
   struct SIDL_dcomplex *value)
{
  SIDL_dcomplex__array_set4((struct SIDL_dcomplex__array *)(ptrdiff_t)*array,
   *i1,
   *i2,
   *i3,
   *i4,
   *value);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_get5_f,
                    SIDL_DCOMPLEX__ARRAY_GET5_F,
                    SIDL_dcomplex__array_get5_f)
  (int64_t *array,   int32_t *i1,
   int32_t *i2,
   int32_t *i3,
   int32_t *i4,
   int32_t *i5,
   struct SIDL_dcomplex *result)
{
  *result = 
    SIDL_dcomplex__array_get5((struct SIDL_dcomplex__array *)(ptrdiff_t)*array,
     *i1,
     *i2,
     *i3,
     *i4,
     *i5);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_set5_f,
                    SIDL_DCOMPLEX__ARRAY_SET5_F,
                    SIDL_dcomplex__array_set5_f)
  (int64_t *array,   int32_t *i1,
   int32_t *i2,
   int32_t *i3,
   int32_t *i4,
   int32_t *i5,
   struct SIDL_dcomplex *value)
{
  SIDL_dcomplex__array_set5((struct SIDL_dcomplex__array *)(ptrdiff_t)*array,
   *i1,
   *i2,
   *i3,
   *i4,
   *i5,
   *value);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_get6_f,
                    SIDL_DCOMPLEX__ARRAY_GET6_F,
                    SIDL_dcomplex__array_get6_f)
  (int64_t *array,   int32_t *i1,
   int32_t *i2,
   int32_t *i3,
   int32_t *i4,
   int32_t *i5,
   int32_t *i6,
   struct SIDL_dcomplex *result)
{
  *result = 
    SIDL_dcomplex__array_get6((struct SIDL_dcomplex__array *)(ptrdiff_t)*array,
     *i1,
     *i2,
     *i3,
     *i4,
     *i5,
     *i6);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_set6_f,
                    SIDL_DCOMPLEX__ARRAY_SET6_F,
                    SIDL_dcomplex__array_set6_f)
  (int64_t *array,   int32_t *i1,
   int32_t *i2,
   int32_t *i3,
   int32_t *i4,
   int32_t *i5,
   int32_t *i6,
   struct SIDL_dcomplex *value)
{
  SIDL_dcomplex__array_set6((struct SIDL_dcomplex__array *)(ptrdiff_t)*array,
   *i1,
   *i2,
   *i3,
   *i4,
   *i5,
   *i6,
   *value);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_get7_f,
                    SIDL_DCOMPLEX__ARRAY_GET7_F,
                    SIDL_dcomplex__array_get7_f)
  (int64_t *array,   int32_t *i1,
   int32_t *i2,
   int32_t *i3,
   int32_t *i4,
   int32_t *i5,
   int32_t *i6,
   int32_t *i7,
   struct SIDL_dcomplex *result)
{
  *result = 
    SIDL_dcomplex__array_get7((struct SIDL_dcomplex__array *)(ptrdiff_t)*array,
     *i1,
     *i2,
     *i3,
     *i4,
     *i5,
     *i6,
     *i7);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_set7_f,
                    SIDL_DCOMPLEX__ARRAY_SET7_F,
                    SIDL_dcomplex__array_set7_f)
  (int64_t *array,   int32_t *i1,
   int32_t *i2,
   int32_t *i3,
   int32_t *i4,
   int32_t *i5,
   int32_t *i6,
   int32_t *i7,
   struct SIDL_dcomplex *value)
{
  SIDL_dcomplex__array_set7((struct SIDL_dcomplex__array *)(ptrdiff_t)*array,
   *i1,
   *i2,
   *i3,
   *i4,
   *i5,
   *i6,
   *i7,
   *value);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_set_f,
                    SIDL_DCOMPLEX__ARRAY_SET_F,
                    SIDL_dcomplex__array_set_f)
  (int64_t *array, int32_t indices[], struct SIDL_dcomplex *value)
{
  SIDL_dcomplex__array_set((struct SIDL_dcomplex__array *)(ptrdiff_t)*array, indices,  *value);
}


void
SIDLFortran77Symbol(sidl_dcomplex__array_get_f,
                    SIDL_DCOMPLEX__ARRAY_GET_F,
                    SIDL_dcomplex__array_get_f)
  (int64_t *array, int32_t indices[], struct SIDL_dcomplex *value)
{
  *value = 
     SIDL_dcomplex__array_get((struct SIDL_dcomplex__array *)(ptrdiff_t)*array, indices);
}



#endif /* not FORTRAN77_DISABLED */
