!
! File:       argstest.F90
! Copyright:  (c) 2002 The Regents of the University of California
! Release:    $Name: release-0-8-8 $
! Revision:   @(#) $Revision: 1.5 $
! Date:       $Date: 2003/02/04 23:49:14 $
! Description:Exercise the FORTRAN interface
!
!
subroutine starttest(number)
  implicit none
  integer (selected_int_kind(9)) :: number
  write (6, 100) number
100 format ('PART ', I4)
end subroutine starttest

subroutine reporttest(test, number, pass, fail, xfail, python)
  implicit none
  integer (kind=selected_int_kind(9)) :: number, pass, fail, xfail
  logical                             :: test, python
  if (test) then
     write (6, 100) number, 'PASS'
     pass = pass + 1
  else
     if (python) then
        write (6, 100) number, 'XFAIL'
        xfail = xfail + 1
     else
        write (6, 100) number, 'FAIL'
        fail = fail + 1
     endif
  endif
100 format ('RESULT', 1x, i2, 1x, A5)
  number = number + 1
end subroutine reporttest

subroutine testbool(test, pass, fail, xfail)
  use Args_Cbool
  implicit none
  type(Args_Cbool_t) :: obj
  integer (selected_int_kind(9))  :: test, pass, fail, xfail
  logical                         :: out, inout, retval

  inout = .true.
  call new(obj)
  call starttest(test)
  call returnback(obj, retval)
  call reporttest(retval, test, pass, fail, xfail, .false.)
  call starttest(test)
  call passin(obj, .true., retval)
  call reporttest(retval, test, pass, fail, xfail, .false.)
  call starttest(test)
  call passout(obj, out, retval)
  call reporttest(retval .and. out, test, pass, fail, xfail, .false.)
  call starttest(test)
  call passinout(obj, inout, retval)
  call reporttest(retval .and. .not. inout, test, pass, fail, xfail, .false.)
  call starttest(test)
  call passeverywhere(obj, .true., out, inout, retval)
  call reporttest(retval .and. out .and. inout, test, pass, fail, xfail, &
                  .false.)
  call deleteRef(obj)
end subroutine testbool

subroutine testint(test, pass, fail, xfail)
  use Args_Cint
  implicit none
  type(Args_Cint_t) :: obj
  integer (selected_int_kind(9))  :: test, pass, fail, xfail
  logical                         :: bretval
  integer (selected_int_kind(9))  :: iretval, out, inout

  inout = 3
  call new(obj)
  call starttest(test)
  call returnback(obj, iretval)
  call reporttest(iretval .eq. 3, test, pass, fail, xfail, .false.)
  call starttest(test)
  call passin(obj, 3, bretval)
  call reporttest(bretval, test, pass, fail, xfail, .false.)
  call starttest(test)
  call passout(obj, out, bretval)
  call reporttest(bretval .and. (out .eq. 3), test, pass, fail, xfail, .false.)
  call starttest(test)
  call passinout(obj, inout, bretval)
  call reporttest(bretval .and. (inout .eq. -3), test, pass, fail, xfail, &
                  .false.)
  call starttest(test)
  call passeverywhere(obj, 3, out, inout, iretval)
  call reporttest((iretval .eq. 3) .and.  (out .eq. 3) .and. &
                  (inout .eq. 3), test, pass, fail, xfail, .false.)
  call deleteRef(obj)
end subroutine testint

subroutine testchar(test, pass, fail, xfail)
  use Args_Cchar
  implicit none
  type (Args_Cchar_t) :: obj
  integer (selected_int_kind(9))  :: test, pass, fail, xfail
  logical                         :: bretval
  character (len=1)               :: cretval, out, inout

  inout = 'A'
  call new(obj)
  call starttest(test)
  call returnback(obj, cretval)
  call reporttest(cretval .eq. '3', test, pass, fail, xfail, .false.)
  call starttest(test)
  call passin(obj, '3', bretval)
  call reporttest(bretval, test, pass, fail, xfail, .false.)
  call starttest(test)
  call passout(obj, out, bretval)
  call reporttest(bretval .and. (out .eq. '3'), test, pass, fail, xfail, &
                  .false.)
  call starttest(test)
  call passinout(obj, inout, bretval)
  call reporttest(bretval .and. (inout .eq. 'a'), test, pass, fail, xfail, &
                  .false.)
  call starttest(test)
  call passeverywhere(obj, '3', out, inout, cretval)
  call reporttest((cretval .eq. '3') .and.  (out .eq. '3') .and. &
                  (inout .eq. 'A'), test, pass, fail, xfail, .false.)
  call deleteRef(obj)
end subroutine testchar

subroutine testlong(test, pass, fail, xfail)
  use Args_Clong
  implicit none
  type(Args_Clong_t) :: obj
  integer (selected_int_kind(9))  :: test, pass, fail, xfail
  logical                         :: bretval
  integer (selected_int_kind(18)) :: out, inout, iretval, inval

  inout = 3
  call new(obj)
  call starttest(test)
  call returnback(obj, iretval)
  call reporttest(iretval .eq. 3, test, pass, fail, xfail, .false.)
  call starttest(test)
  inval = 3
  call passin(obj, inval, bretval)
  call reporttest(bretval, test, pass, fail, xfail, .false.)
  call starttest(test)
  call passout(obj, out, bretval)
  call reporttest(bretval .and. (out .eq. 3), test, pass, fail, xfail, .false.)
  call starttest(test)
  call passinout(obj, inout, bretval)
  call reporttest(bretval .and. (inout .eq. -3), test, pass, fail, xfail, &
                  .false.)
  call starttest(test)
  inval = 3
  call passeverywhere(obj, inval, out, inout, iretval)
  call reporttest((iretval .eq. 3) .and.  (out .eq. 3) .and. &
                  (inout .eq. 3), test, pass, fail, xfail, .false.)
  call deleteRef(obj)
end subroutine testlong

subroutine testfloat(test, pass, fail, xfail, python)
  use Args_Cfloat
  implicit none
  type(Args_Cfloat_t) :: obj
  integer (selected_int_kind(9))  :: test, pass, fail, xfail
  logical                         :: bretval, python
  real (selected_real_kind(6,37)) :: out, inout, fretval

  inout = 3.1
  call new(obj)
  call starttest(test)
  call returnback(obj, fretval)
  call reporttest(fretval .eq. 3.1, test, pass, fail, xfail, .false.)
  call starttest(test)
  call passin(obj, 3.1, bretval)
  call reporttest(bretval, test, pass, fail, xfail, python)
  call starttest(test)
  call passout(obj, out, bretval)
  call reporttest(bretval .and. (out .eq. 3.1), test, pass, fail, xfail, &
                  .false.)
  call starttest(test)
  call passinout(obj, inout, bretval)
  call reporttest(bretval .and. (inout .eq. -3.1), test, pass, fail, xfail, &
                  .false.)
  call starttest(test)
  call passeverywhere(obj, 3.1, out, inout, fretval)
  call reporttest((fretval .eq. 3.1) .and.  (out .eq. 3.1) .and. &
                  (inout .eq. 3.1), test, pass, fail, xfail, python)
  call deleteRef(obj)
end subroutine testfloat

subroutine testdouble(test, pass, fail, xfail)
  use Args_Cdouble
  implicit none
  type(Args_Cdouble_t) :: obj
  integer (selected_int_kind(9))    :: test, pass, fail, xfail
  logical                           :: bretval
  real (selected_real_kind(15,307)) :: out, inout, dretval

  inout = 3.14d0
  call new(obj)
  call starttest(test)
  call returnback(obj, dretval)
  call reporttest(dretval .eq. 3.14d0, test, pass, fail, xfail, .false.)
  call starttest(test)
  call passin(obj, 3.14d0, bretval)
  call reporttest(bretval, test, pass, fail, xfail, .false.)
  call starttest(test)
  call passout(obj, out, bretval)
  call reporttest(bretval .and. (out .eq. 3.14d0), test, pass, fail, xfail, &
                  .false.)
  call starttest(test)
  call passinout(obj, inout, bretval)
  call reporttest(bretval .and. (inout .eq. -3.14d0), test, pass, fail, xfail, &
                  .false.)
  call starttest(test)
  call passeverywhere(obj, 3.14d0, out, inout, dretval)
  call reporttest((dretval .eq. 3.14d0) .and.  (out .eq. 3.14d0) .and. &
                  (inout .eq. 3.14d0), test, pass, fail, xfail, .false.)
  call deleteRef(obj)
end subroutine testdouble

subroutine testfcomplex(test, pass, fail, xfail, python)
  use Args_Cfcomplex
  implicit none
  type(Args_Cfcomplex_t) :: obj
  integer (selected_int_kind(9))     :: test, pass, fail, xfail
  logical                            :: bretval, python
  complex (selected_real_kind(6,37)) :: in, out, inout, cretval

  in = (3.1,3.1)
  inout = (3.1, 3.1)
  call new(obj)
  call starttest(test)
  call returnback(obj, cretval)
  call reporttest(cretval .eq. (3.1,3.1), test, pass, fail, xfail, .false.)
  call starttest(test)
  call passin(obj, in, bretval)
  call reporttest(bretval, test, pass, fail, xfail, python)
  call starttest(test)
  call passout(obj, out, bretval)
  call reporttest(bretval .and. (out .eq. (3.1,3.1)), test, pass, fail, xfail, &
                  .false.)
  call starttest(test)
  call passinout(obj, inout, bretval)
  call reporttest(bretval .and. (inout .eq. (3.1,-3.1)), test, pass, fail, &
                  xfail, .false.)
  call starttest(test)
  call passeverywhere(obj, in, out, inout, cretval)
  call reporttest((cretval .eq. (3.1,3.1)) .and.  (out .eq. (3.1,3.1)) .and. &
                  (inout .eq. (3.1,3.1)), test, pass, fail, xfail, python)
  call deleteRef(obj)
end subroutine testfcomplex

subroutine testdcomplex(test, pass, fail, xfail)
  use Args_Cdcomplex
  implicit none
  type(Args_Cdcomplex_t) :: obj
  integer (selected_int_kind(9))       :: test, pass, fail, xfail
  logical                              :: bretval
  complex (selected_real_kind(15,307)) :: in, out, inout, cretval

  in = (3.14d0,3.14d0)
  inout = (3.14d0, 3.14d0)
  call new(obj)
  call starttest(test)
  call returnback(obj, cretval)
  call reporttest(cretval .eq. (3.14d0,3.14d0), test, pass, fail, xfail, &
                  .false.)
  call starttest(test)
  call passin(obj, in, bretval)
  call reporttest(bretval, test, pass, fail, xfail, .false.)
  call starttest(test)
  call passout(obj, out, bretval)
  call reporttest(bretval .and. (out .eq. (3.14d0,3.14d0)), test, pass, fail, &
                  xfail, .false.)
  call starttest(test)
  call passinout(obj, inout, bretval)
  call reporttest(bretval .and. (inout .eq. (3.14d0,-3.14d0)), test, pass, &
                  fail, xfail, .false.)
  call starttest(test)
  call passeverywhere(obj, in, out, inout, cretval)
  call reporttest((cretval .eq. (3.14d0,3.14d0)) .and.  &
                  (out .eq. (3.14d0,3.14d0)) .and. &
                  (inout .eq. (3.14d0,3.14d0)), test, pass, fail, xfail,  &
                  .false.)
  call deleteRef(obj)
end subroutine testdcomplex


program argstest
  integer (selected_int_kind(9)) :: test, pass, fail, xfail
  character (len=80)             :: language
  language = ' '
  if (IArgc() .eq. 1) then
     call GetArg(1, language)
  endif
  test = 1
  pass = 0
  xfail = 0
  fail = 0
  write(6,120) 40
  write(6,110) 'Boolean tests'
  call testbool(test, pass, fail, xfail)
  write(6,110) 'Character tests'
  call testchar(test, pass, fail, xfail)
  write(6,110) 'Integer tests'
  call testint(test, pass, fail, xfail)
  write(6,110) 'Long tests'
  call testlong(test, pass, fail, xfail)
  write(6,110) 'Float tests'
  call testfloat(test, pass, fail, xfail, language .eq. 'Python')
  write(6,110) 'Double tests'
  call testdouble(test, pass, fail, xfail)
  write(6,110) 'Fcomplex tests'
  call testfcomplex(test, pass, fail, xfail, language .eq. 'Python')
  write(6,110) 'Dcomplex tests'
  call testDcomplex(test, pass, fail, xfail)
  if (fail .eq. 0) then
     if (pass .eq. 40) then
        write(6, 100) 'PASS'
     else
        write(6, 100) 'XFAIL'
     endif
  else
     write(6, 100) 'FAIL'
  endif
100 format ('TEST_RESULT', 1x, a5)
110 format ('COMMENT:', 1x, a20)
120 format ('NPARTS', 1x, i4)
end program argstest
