/*
 * File:        arraytests.c
 * Copyright:   (c) 2001-2003 The Regents of the University of California
 * Release:     $Name: release-0-8-8 $
 * Revision:    @(#) $Revision: 1.15 $
 * Date:        $Date: 2003/09/05 23:12:54 $
 * Description: Simple test on the ArrayTest static methods
 *
 */

#include "ArrayTest_ArrayOps.h"
#include "SIDL_header.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

static const char * result_string[] = { "FAIL", "XFAIL", "PASS" };
const int pass = 2;
const int xfail = 1;
const int fail = 0;

static const int TEST_SIZE = 345; /* size of one dimensional arrays */
static const int TEST_DIM1 = 17; /* first dimension of 2-d arrays */
static const int TEST_DIM2 = 13; /* second dimension of 2-d arrays */
static const int TEST_DIM3 = 4;  /* third dimension of 3-d arrays */

static void declare_part( int * part_no ) {
  ++(*part_no);
  printf("PART %d\n", *part_no );
}

static int isPrime(const int64_t num) {
  register int64_t i;
  for(i = 3; i*i <= num; ++i) {
    if (!(num % i)) return 0;
  }
  return 1;
}

static int64_t
nextPrime(int64_t prev) {
  if (prev <= 1L) {
    return 2L;
  }
  else if (prev == 2L) {
    return 3L;
  }
  else {
    do {
      prev += 2;
    } while (!isPrime(prev));
    return prev;
  }
}

static void end_part( int part_no, int result, int *final_result ) {
  printf("RESULT %d %s\n", part_no, result_string[ result ] );
  if ( result < *final_result ) { 
    *final_result = result;
  }
}

/**
 * Fill the stack with random junk.
 */
int clearstack(int magicNumber) {
  int chunk[2048], i;
  for(i = 0; i < 2048; i++){
    chunk[i] = rand() + magicNumber;
  }
  for(i = 0; i < 16; i++){
    magicNumber += chunk[rand() & 2047];
  }
  return magicNumber;
}

#define MYASSERT( CMT, AAA ) \
  declare_part( &part_no ); \
  magicNumber = clearstack(magicNumber); \
  printf("COMMENT: %s: %s\n", #CMT, #AAA ); \
  if ( AAA ) result = pass; \
  else result = fail;  \
  end_part( part_no, result, &final_result );

int main(int argc, char **argv) {
  int result = pass;
  int final_result = pass;
  int part_no = 0;
  int magicNumber = 1;

  struct SIDL_bool__array     *barray;
  struct SIDL_char__array     *carray;
  struct SIDL_int__array      *iarray;
  struct SIDL_dcomplex__array *dcarray;
  struct SIDL_fcomplex__array *fcarray;
  struct SIDL_long__array     *larray;
  struct SIDL_double__array   *darray;
  struct SIDL_float__array    *farray;
  struct SIDL_string__array   *sarray;

  struct ArrayTest_ArrayOps__array *oarray;

  printf("NPARTS -1\n");

  magicNumber = clearstack(magicNumber);
  barray = ArrayTest_ArrayOps_createBool(TEST_SIZE);
  MYASSERT(createBool, barray);
  MYASSERT(createBool, ArrayTest_ArrayOps_checkBool(barray) == TRUE);
  MYASSERT(createBool, ArrayTest_ArrayOps_reverseBool(&barray, TRUE) == TRUE);
  magicNumber = clearstack(magicNumber);
  SIDL_bool__array_deleteRef(barray);
  barray = NULL;
  ArrayTest_ArrayOps_makeBool(218, &barray);
  MYASSERT(makeBool218, ArrayTest_ArrayOps_checkBool(barray) == TRUE);
  MYASSERT(makeBool218, 
           ArrayTest_ArrayOps_reverseBool(&barray, FALSE) == TRUE);
  MYASSERT(makeBool218, ArrayTest_ArrayOps_checkBool(barray) == FALSE);
  magicNumber = clearstack(magicNumber);
  SIDL_bool__array_deleteRef(barray);
  barray = NULL;
  ArrayTest_ArrayOps_makeBool(9, &barray);
  MYASSERT(makeBool9, ArrayTest_ArrayOps_reverseBool(&barray, FALSE) == TRUE);
  MYASSERT(makeBool9, ArrayTest_ArrayOps_checkBool(barray) == TRUE);
  magicNumber = clearstack(magicNumber);
  SIDL_bool__array_deleteRef(barray);
  barray = NULL;

  MYASSERT(createBoolNegOne, ArrayTest_ArrayOps_createBool(-1) == NULL);
  ArrayTest_ArrayOps_makeBool(-1, &barray);
  MYASSERT(makeBoolNegOne, barray == NULL);
  if (barray) {
    SIDL_bool__array_deleteRef(barray);
    barray = NULL;
  }
  
  magicNumber = clearstack(magicNumber);
  carray = ArrayTest_ArrayOps_createChar(TEST_SIZE);
  MYASSERT(createChar, carray);
  MYASSERT(createChar, ArrayTest_ArrayOps_checkChar(carray) == TRUE);
  MYASSERT(createChar, ArrayTest_ArrayOps_reverseChar(&carray, TRUE) == TRUE);
  magicNumber = clearstack(magicNumber);
  SIDL_char__array_deleteRef(carray);
  carray = NULL;
  ArrayTest_ArrayOps_makeChar(218, &carray);
  MYASSERT(makeChar, ArrayTest_ArrayOps_checkChar(carray) == TRUE);
  MYASSERT(makeChar, ArrayTest_ArrayOps_reverseChar(&carray, FALSE) == TRUE);
  MYASSERT(makeChar, ArrayTest_ArrayOps_checkChar(carray) == FALSE);
  magicNumber = clearstack(magicNumber);
  SIDL_char__array_deleteRef(carray);
  carray = NULL;

  MYASSERT(createCharNegOne, ArrayTest_ArrayOps_createChar(-1) == NULL);
  ArrayTest_ArrayOps_makeChar(-1, &carray);
  MYASSERT(makeCharNegOne, carray == NULL);
  if (carray) {
    SIDL_char__array_deleteRef(carray);
    carray = NULL;
  }
  
  magicNumber = clearstack(magicNumber);
  iarray = ArrayTest_ArrayOps_createInt(TEST_SIZE);
  MYASSERT(createInt, iarray);
  MYASSERT(createInt, ArrayTest_ArrayOps_checkInt(iarray) == TRUE);
  MYASSERT(createInt, ArrayTest_ArrayOps_reverseInt(&iarray, TRUE) == TRUE);
  magicNumber = clearstack(magicNumber);
  SIDL_int__array_deleteRef(iarray);
  iarray = NULL;
  ArrayTest_ArrayOps_makeInt(218, &iarray);
  MYASSERT(makeInt, ArrayTest_ArrayOps_checkInt(iarray) == TRUE);
  MYASSERT(makeInt, ArrayTest_ArrayOps_reverseInt(&iarray, FALSE) == TRUE);
  MYASSERT(makeInt, ArrayTest_ArrayOps_checkInt(iarray) == FALSE);
  magicNumber = clearstack(magicNumber);
  SIDL_int__array_deleteRef(iarray);
  iarray = NULL;

  MYASSERT(createIntNegOne, ArrayTest_ArrayOps_createInt(-1) == NULL);
  ArrayTest_ArrayOps_makeInt(-1, &iarray);
  MYASSERT(makeIntNegOne, iarray == NULL);
  if (iarray) {
    SIDL_int__array_deleteRef(iarray);
    iarray = NULL;
  }
  
  
  magicNumber = clearstack(magicNumber);
  larray = ArrayTest_ArrayOps_createLong(TEST_SIZE);
  MYASSERT(createLong, larray);
  MYASSERT(createLong, ArrayTest_ArrayOps_checkLong(larray) == TRUE);
  MYASSERT(createLong, ArrayTest_ArrayOps_reverseLong(&larray, TRUE) == TRUE);
  magicNumber = clearstack(magicNumber);
  SIDL_long__array_deleteRef(larray);
  larray = NULL;
  ArrayTest_ArrayOps_makeLong(218, &larray);
  MYASSERT(makeLong, ArrayTest_ArrayOps_checkLong(larray) == TRUE);
  MYASSERT(makeLong, ArrayTest_ArrayOps_reverseLong(&larray, FALSE) == TRUE);
  MYASSERT(makeLong, ArrayTest_ArrayOps_checkLong(larray) == FALSE);
  magicNumber = clearstack(magicNumber);
  SIDL_long__array_deleteRef(larray);
  larray = NULL;

  MYASSERT(createLongNegOne, ArrayTest_ArrayOps_createLong(-1) == NULL);
  ArrayTest_ArrayOps_makeLong(-1, &larray);
  MYASSERT(makeLongNegOne, larray == NULL);
  if (larray) {
    SIDL_long__array_deleteRef(larray);
    larray = NULL;
  }
  
  magicNumber = clearstack(magicNumber);
  sarray = ArrayTest_ArrayOps_createString(TEST_SIZE);
  MYASSERT(createString, sarray);
  MYASSERT(createString, ArrayTest_ArrayOps_checkString(sarray) == TRUE);
  MYASSERT(createString, 
           ArrayTest_ArrayOps_reverseString(&sarray, TRUE) == TRUE);
  magicNumber = clearstack(magicNumber);
  SIDL_string__array_deleteRef(sarray);
  sarray = NULL;
  ArrayTest_ArrayOps_makeString(218, &sarray);
  MYASSERT(makeString, ArrayTest_ArrayOps_checkString(sarray) == TRUE);
  MYASSERT(makeString, 
           ArrayTest_ArrayOps_reverseString(&sarray, FALSE) == TRUE);
  MYASSERT(makeString, ArrayTest_ArrayOps_checkString(sarray) == FALSE);
  magicNumber = clearstack(magicNumber);
  SIDL_string__array_deleteRef(sarray);
  sarray = NULL;

  MYASSERT(createStringNegOne, ArrayTest_ArrayOps_createString(-1) == NULL);
  ArrayTest_ArrayOps_makeString(-1, &sarray);
  MYASSERT(makeStringNegOne, sarray == NULL);
  if (sarray) {
    SIDL_string__array_deleteRef(sarray);
    sarray = NULL;
  }
  
  magicNumber = clearstack(magicNumber);
  darray = ArrayTest_ArrayOps_createDouble(TEST_SIZE);
  MYASSERT(createDouble, darray);
  MYASSERT(createDouble, ArrayTest_ArrayOps_checkDouble(darray) == TRUE);
  MYASSERT(createDouble, 
           ArrayTest_ArrayOps_reverseDouble(&darray, TRUE) == TRUE);
  magicNumber = clearstack(magicNumber);
  SIDL_double__array_deleteRef(darray);
  darray = NULL;
  ArrayTest_ArrayOps_makeDouble(218, &darray);
  MYASSERT(makeDouble, ArrayTest_ArrayOps_checkDouble(darray) == TRUE);
  MYASSERT(makeDouble, 
           ArrayTest_ArrayOps_reverseDouble(&darray, FALSE) == TRUE);
  MYASSERT(makeDouble, ArrayTest_ArrayOps_checkDouble(darray) == FALSE);
  magicNumber = clearstack(magicNumber);
  SIDL_double__array_deleteRef(darray);
  darray = NULL;

  MYASSERT(createDoubleNegOne, ArrayTest_ArrayOps_createDouble(-1) == NULL);
  ArrayTest_ArrayOps_makeDouble(-1, &darray);
  MYASSERT(makeDoubleNegOne, darray == NULL);
  if (darray) {
    SIDL_double__array_deleteRef(darray);
    darray = NULL;
  }
  
  magicNumber = clearstack(magicNumber);
  farray = ArrayTest_ArrayOps_createFloat(TEST_SIZE);
  MYASSERT(createFloat, farray);
  MYASSERT(createFloat, ArrayTest_ArrayOps_checkFloat(farray) == TRUE);
  MYASSERT(createFloat, 
           ArrayTest_ArrayOps_reverseFloat(&farray, TRUE) == TRUE);
  magicNumber = clearstack(magicNumber);
  SIDL_float__array_deleteRef(farray);
  farray = NULL;
  ArrayTest_ArrayOps_makeFloat(218, &farray);
  MYASSERT(makeFloat, ArrayTest_ArrayOps_checkFloat(farray) == TRUE);
  MYASSERT(makeFloat, 
           ArrayTest_ArrayOps_reverseFloat(&farray, FALSE) == TRUE);
  MYASSERT(makeFloat, ArrayTest_ArrayOps_checkFloat(farray) == FALSE);
  magicNumber = clearstack(magicNumber);
  SIDL_float__array_deleteRef(farray);
  farray = NULL;
  
  MYASSERT(createFloatNegOne, ArrayTest_ArrayOps_createFloat(-1) == NULL);
  ArrayTest_ArrayOps_makeFloat(-1, &farray);
  MYASSERT(makeFloatNegOne, farray == NULL);
  if (farray) {
    SIDL_float__array_deleteRef(farray);
    farray = NULL;
  }
  
  magicNumber = clearstack(magicNumber);
  fcarray = ArrayTest_ArrayOps_createFcomplex(TEST_SIZE);
  MYASSERT(createFcomplex, fcarray);
  MYASSERT(createFcomplex, ArrayTest_ArrayOps_checkFcomplex(fcarray) == TRUE);
  MYASSERT(createFcomplex, 
           ArrayTest_ArrayOps_reverseFcomplex(&fcarray, TRUE) == TRUE);
  magicNumber = clearstack(magicNumber);
  SIDL_fcomplex__array_deleteRef(fcarray);
  fcarray = NULL;
  ArrayTest_ArrayOps_makeFcomplex(218, &fcarray);
  MYASSERT(makeFcomplex, ArrayTest_ArrayOps_checkFcomplex(fcarray) == TRUE);
  MYASSERT(makeFcomplex, 
           ArrayTest_ArrayOps_reverseFcomplex(&fcarray, FALSE) == TRUE);
  MYASSERT(makeFcomplex, ArrayTest_ArrayOps_checkFcomplex(fcarray) == FALSE);
  magicNumber = clearstack(magicNumber);
  SIDL_fcomplex__array_deleteRef(fcarray);
  fcarray = NULL;
  
  MYASSERT(createFcomplexNegOne, 
           ArrayTest_ArrayOps_createFcomplex(-1) == NULL);
  ArrayTest_ArrayOps_makeFcomplex(-1, &fcarray);
  MYASSERT(makeFcomplexNegOne, fcarray == NULL);
  if (fcarray) {
    SIDL_fcomplex__array_deleteRef(fcarray);
    fcarray = NULL;
  }
  
  magicNumber = clearstack(magicNumber);
  dcarray = ArrayTest_ArrayOps_createDcomplex(TEST_SIZE);
  MYASSERT(createDcomplex, dcarray);
  MYASSERT(createDcomplex, ArrayTest_ArrayOps_checkDcomplex(dcarray) == TRUE);
  MYASSERT(createDcomplex, 
           ArrayTest_ArrayOps_reverseDcomplex(&dcarray, TRUE) == TRUE);
  magicNumber = clearstack(magicNumber);
  SIDL_dcomplex__array_deleteRef(dcarray);
  dcarray = NULL;
  ArrayTest_ArrayOps_makeDcomplex(218, &dcarray);
  MYASSERT(makeDcomplex, ArrayTest_ArrayOps_checkDcomplex(dcarray) == TRUE);
  MYASSERT(makeDcomplex, 
           ArrayTest_ArrayOps_reverseDcomplex(&dcarray, FALSE) == TRUE);
  MYASSERT(makeDcomplex, ArrayTest_ArrayOps_checkDcomplex(dcarray) == FALSE);
  magicNumber = clearstack(magicNumber);
  SIDL_dcomplex__array_deleteRef(dcarray);
  dcarray = NULL;

  MYASSERT(createDcomplexNegOne, 
           ArrayTest_ArrayOps_createDcomplex(-1) == NULL);
  ArrayTest_ArrayOps_makeDcomplex(-1, &dcarray);
  MYASSERT(makeDcomplexNegOne, dcarray == NULL);
  if (dcarray) {
    SIDL_dcomplex__array_deleteRef(dcarray);
    dcarray = NULL;
  }
  
  magicNumber = clearstack(magicNumber);
  iarray = ArrayTest_ArrayOps_create2Int(TEST_DIM1,TEST_DIM2);
  MYASSERT(create2Int, ArrayTest_ArrayOps_check2Int(iarray) == TRUE);
  SIDL_int__array_deleteRef(iarray);
  iarray = NULL;

  MYASSERT(create2IntNegOne, ArrayTest_ArrayOps_create2Int(-1,-1) == NULL);

  magicNumber = clearstack(magicNumber);
  darray = ArrayTest_ArrayOps_create2Double(TEST_DIM1,TEST_DIM2);
  MYASSERT(create2Double, ArrayTest_ArrayOps_check2Double(darray) == TRUE);
  SIDL_double__array_deleteRef(darray);
  darray = NULL;

  MYASSERT(create2DoubleNegOne, ArrayTest_ArrayOps_create2Double(-1,-1) == NULL);

  magicNumber = clearstack(magicNumber);
  farray = ArrayTest_ArrayOps_create2Float(TEST_DIM1,TEST_DIM2);
  MYASSERT(create2Float, ArrayTest_ArrayOps_check2Float(farray) == TRUE);
  SIDL_float__array_deleteRef(farray);
  farray = NULL;

  MYASSERT(create2FloatNegOne, ArrayTest_ArrayOps_create2Float(-1,-1) == NULL);

  magicNumber = clearstack(magicNumber);
  dcarray = ArrayTest_ArrayOps_create2Dcomplex(TEST_DIM1,TEST_DIM2);
  MYASSERT(create2Dcomplex, 
           ArrayTest_ArrayOps_check2Dcomplex(dcarray) == TRUE);
  SIDL_dcomplex__array_deleteRef(dcarray);
  dcarray = NULL;

  MYASSERT(create2DcomplexNegOne, ArrayTest_ArrayOps_create2Dcomplex(-1,-1) == NULL);

  magicNumber = clearstack(magicNumber);
  fcarray = ArrayTest_ArrayOps_create2Fcomplex(TEST_DIM1,TEST_DIM2);
  MYASSERT(create2Fcomplex, 
           ArrayTest_ArrayOps_check2Fcomplex(fcarray) == TRUE);
  SIDL_fcomplex__array_deleteRef(fcarray);
  fcarray = NULL;

  MYASSERT(create2FcomplexNegOne, ArrayTest_ArrayOps_create2Fcomplex(-1,-1) == NULL);

  magicNumber = clearstack(magicNumber);
  iarray = ArrayTest_ArrayOps_create3Int();
  MYASSERT(create3Int, ArrayTest_ArrayOps_check3Int(iarray) == TRUE);
  SIDL_int__array_deleteRef(iarray);
  iarray = NULL;

  magicNumber = clearstack(magicNumber);
  iarray = ArrayTest_ArrayOps_create4Int();
  MYASSERT(create4Int, ArrayTest_ArrayOps_check4Int(iarray) == TRUE);
  SIDL_int__array_deleteRef(iarray);
  iarray = NULL;

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOutBool(&barray, 218);
  MYASSERT(makeInOutBool, ArrayTest_ArrayOps_checkBool(barray) == TRUE);
  SIDL_bool__array_deleteRef(barray);
  barray = NULL;

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOutBool(&barray, -1);
  MYASSERT(makeInOutBoolNegOne, barray == NULL);
  if (barray) { 
    SIDL_bool__array_deleteRef(barray);
    barray = NULL;
  }

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOutChar(&carray, 218);
  MYASSERT(makeInOutChar, ArrayTest_ArrayOps_checkChar(carray) == TRUE);
  SIDL_char__array_deleteRef(carray);
  carray = NULL;

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOutChar(&carray, -1);
  MYASSERT(makeInOutCharNegOne, carray == NULL);
  if (carray) {
    SIDL_char__array_deleteRef(carray);
    carray = NULL;
  }

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOutInt(&iarray, 218);
  MYASSERT(makeInOutInt, ArrayTest_ArrayOps_checkInt(iarray) == TRUE);
  SIDL_int__array_deleteRef(iarray);
  iarray = NULL;

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOutInt(&iarray, -1);
  MYASSERT(makeInOutIntNegOne, iarray == NULL);
  if (iarray) {
    SIDL_int__array_deleteRef(iarray);
    iarray = NULL;
  }

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOutLong(&larray, 218);
  MYASSERT(makeInOutLong, ArrayTest_ArrayOps_checkLong(larray) == TRUE);
  SIDL_long__array_deleteRef(larray);
  larray = NULL;

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOutLong(&larray, -1);
  MYASSERT(makeInOutLongNegOne, larray == NULL);
  if (larray) {
    SIDL_long__array_deleteRef(larray);
    larray = NULL;
  }

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOutString(&sarray, 218);
  MYASSERT(makeInOutString, ArrayTest_ArrayOps_checkString(sarray) == TRUE);
  SIDL_string__array_deleteRef(sarray);
  sarray = NULL;

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOutString(&sarray, -1);
  MYASSERT(makeInOutStringNegOne, sarray == NULL);
  if (sarray) {
    SIDL_string__array_deleteRef(sarray);
    sarray = NULL;
  }

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOutDouble(&darray, 218);
  MYASSERT(makeInOutDouble, ArrayTest_ArrayOps_checkDouble(darray) == TRUE);
  SIDL_double__array_deleteRef(darray);
  darray = NULL;

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOutDouble(&darray, -1);
  MYASSERT(makeInOutDoubleNegOne, darray == NULL);
  if (darray) {
    SIDL_double__array_deleteRef(darray);
    darray = NULL;
  }

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOutFloat(&farray, 218);
  MYASSERT(makeInOutFloat, ArrayTest_ArrayOps_checkFloat(farray) == TRUE);
  SIDL_float__array_deleteRef(farray);
  farray = NULL;

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOutFloat(&farray, -1);
  MYASSERT(makeInOutFloatNegOne, farray == NULL);
  if (farray) {
    SIDL_float__array_deleteRef(farray);
    farray = NULL;
  }

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOutDcomplex(&dcarray, 218);
  MYASSERT(makeInOutDcomplex, 
           ArrayTest_ArrayOps_checkDcomplex(dcarray) == TRUE);
  SIDL_dcomplex__array_deleteRef(dcarray);
  dcarray = NULL;

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOutDcomplex(&dcarray, -1);
  MYASSERT(makeInOutDcomplexNegOne, dcarray == NULL);
  if (dcarray) {
    SIDL_dcomplex__array_deleteRef(dcarray);
    dcarray = NULL;
  }

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOutFcomplex(&fcarray, 218);
  MYASSERT(makeInOutFcomplex, 
           ArrayTest_ArrayOps_checkFcomplex(fcarray) == TRUE);
  SIDL_fcomplex__array_deleteRef(fcarray);
  fcarray = NULL;

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOutFcomplex(&fcarray, -1);
  MYASSERT(makeInOutFcomplexNegOne,  fcarray == NULL);
  if (fcarray) {
    SIDL_fcomplex__array_deleteRef(fcarray);
    fcarray = NULL;
  }

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOut2Int(&iarray, TEST_DIM1, TEST_DIM2);
  MYASSERT(makeInOut2Int, ArrayTest_ArrayOps_check2Int(iarray) == TRUE);
  SIDL_int__array_deleteRef(iarray);
  iarray = NULL;

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOut2Int(&iarray, -1, -1);
  MYASSERT(makeInOut2IntNegOne, iarray == NULL);
  if (iarray) {
    SIDL_int__array_deleteRef(iarray);
    iarray = NULL;
  }

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOut2Double(&darray, TEST_DIM1, TEST_DIM2);
  MYASSERT(makeInOut2Double, ArrayTest_ArrayOps_check2Double(darray) == TRUE);
  SIDL_double__array_deleteRef(darray);
  darray = NULL;

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOut2Double(&darray, -1, -1);
  MYASSERT(makeInOut2DoubleNegOne, darray == NULL);
  if (darray) {
    SIDL_double__array_deleteRef(darray);
    darray = NULL;
  }

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOut2Float(&farray, TEST_DIM1, TEST_DIM2);
  MYASSERT(makeInOut2Float, ArrayTest_ArrayOps_check2Float(farray) == TRUE);
  SIDL_float__array_deleteRef(farray);
  farray = NULL;

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOut2Float(&farray, -1, -1);
  MYASSERT(makeInOut2FloatNegOne, farray == NULL);
  if (farray) {
    SIDL_float__array_deleteRef(farray);
    farray = NULL;
  }

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOut2Dcomplex(&dcarray, TEST_DIM1, TEST_DIM2);
  MYASSERT(makeInOut2Dcomplex, 
            ArrayTest_ArrayOps_check2Dcomplex(dcarray) == TRUE);
  SIDL_dcomplex__array_deleteRef(dcarray);
  dcarray = NULL;

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOut2Dcomplex(&dcarray, -1, -1);
  MYASSERT(makeInOut2DcomplexNegOne, dcarray == NULL);
  if (dcarray) {
    SIDL_dcomplex__array_deleteRef(dcarray);
    dcarray = NULL;
  }

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOut2Fcomplex(&fcarray, TEST_DIM1, TEST_DIM2);
  MYASSERT(makeInOut2Fcomplex, 
           ArrayTest_ArrayOps_check2Fcomplex(fcarray) == TRUE);
  SIDL_fcomplex__array_deleteRef(fcarray);
  fcarray = NULL;

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOut2Fcomplex(&fcarray, -1, -1);
  MYASSERT(makeInOut2FcomplexNegOne, fcarray == NULL);
  if (fcarray) {
    SIDL_fcomplex__array_deleteRef(fcarray);
    fcarray = NULL;
  }

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOut3Int(&iarray);
  MYASSERT(makeInOut3Int, ArrayTest_ArrayOps_check3Int(iarray) == TRUE);
  SIDL_int__array_deleteRef(iarray);
  iarray = NULL;

  magicNumber = clearstack(magicNumber);
  ArrayTest_ArrayOps_makeInOut4Int(&iarray);
  MYASSERT(makeInOut4Int, ArrayTest_ArrayOps_check4Int(iarray) == TRUE);
  SIDL_int__array_deleteRef(iarray);
  iarray = NULL;

  magicNumber = clearstack(magicNumber);
  MYASSERT(createObjectNegOne, ArrayTest_ArrayOps_createObject(-1) == NULL);
  oarray = ArrayTest_ArrayOps_createObject(16);
  MYASSERT(checkObject, ArrayTest_ArrayOps_checkObject(oarray) == 16);
  if (oarray) {
    ArrayTest_ArrayOps__array_deleteRef(oarray);
    oarray = NULL;
  }
  MYASSERT(checkObjectNull, !ArrayTest_ArrayOps_checkObject(NULL));

  {
    const int32_t len = TEST_SIZE;
    static const int32_t lower = 0;
    static const int32_t negOne = -1;
    const int32_t upper = len - 1;
    int32_t *data = malloc(len*sizeof(int32_t));
    int32_t *end = data + upper;
    int32_t i;
    int32_t prime = nextPrime(0);
    iarray = SIDL_int__array_borrow(end, 1, &lower, &upper, &negOne);
    MYASSERT(borrow, iarray);
    if (iarray) {
      for(i = lower; i <= upper; ++i, prime = nextPrime(prime) ) {
        switch(rand() % 3) {
        case 0:  SIDLArrayElem1(iarray, i) = prime;      break;
        case 1:  SIDL_int__array_set1(iarray, i, prime); break;
        default: SIDL_int__array_set(iarray, &i, prime); break;
        }
      }
    }
    MYASSERT(negativeStride, 
             iarray && ArrayTest_ArrayOps_checkInt(iarray) == TRUE);
    if (iarray) SIDL_int__array_deleteRef(iarray);
    free(data);
  }
  {
    const int32_t max1 = TEST_DIM1, max2 = TEST_DIM2, max3 = TEST_DIM3;
    static const int32_t lower[] = { 0, 0, 0};
    const int32_t upper[] = { max1-1, max2-1, max3-1};
    const int32_t stride[] = { -max2*max3, -max3, -1};
    const int32_t numElems = max1 * max2 * max3;
    int32_t *data = malloc(numElems*sizeof(int32_t));
    int32_t *end = data + numElems - 1;
    int32_t i, j, k, part;
    iarray = SIDL_int__array_borrow(end, 3, lower, upper, stride);
    MYASSERT(borrowThree, iarray);
    if (iarray) {
      for(i = lower[0]; i <= upper[0]; ++i) {
        for(j = lower[1]; j <= upper[1]; ++j) {
          part = (i + 1) * (j + 2);
          for(k = lower[2]; k <= upper[2]; ++k) {
            SIDLArrayElem3(iarray, i, j, k) = part*(k+3);
          }
        }
      }
    }
    MYASSERT(negativeStrideThree,
             iarray && ArrayTest_ArrayOps_check3Int(iarray) == TRUE);
    if (iarray) SIDL_int__array_deleteRef(iarray);
    free(data);
  }

  printf("TEST_RESULT %s\n", result_string[ final_result ] );
  return 0;
}
