// 
// File:        ArrayTestDriver.java
// Copyright:   (c) 2001 The Regents of the University of California
// Release:     $Name: release-0-8-8 $
// Revision:    @(#) $Revision: 1.5 $
// Date:        $Date: 2003/08/07 21:00:51 $
// Description: array regression test case for Java calling other languages
// 

/**
 * The following class runs the array regression test cases for Java.
 */
public class ArrayTestDriver {
  private final static int FAIL        = 0;
  private final static int XFAIL       = 1;
  private final static int PASS        = 2;
  private final static int XPASS       = 3;
  private final static int UNSUPPORTED = 4;

  private final static String[] s_results = {
    "FAIL",
    "XFAIL",
    "PASS",
    "XPASS",
    "UNSUPPORTED"
  };

  private final static int ONE_D_SIZE = 345;
  private final static int TEST_DIM1 = 13;
  private final static int TEST_DIM2 = 16;

  private static int s_part = 0;
  private static int s_result = PASS;

  /**
   * Check the results of the test case.
   */
  private static void check(int expected, boolean pass, String test) {
    System.out.println("PART " + String.valueOf(++s_part));
    System.out.println("COMMENT " + test);
    System.out.print("RESULT " + String.valueOf(s_part) + " ");

    if (expected == UNSUPPORTED) {
      System.out.println(s_results[expected]);
      if (s_result == PASS) {
        s_result = XFAIL;
      }
    } else if (expected == PASS) {
      System.out.println(s_results[pass ? PASS : FAIL]);
      if (!pass) {
        s_result = FAIL;
      }
    } else if (expected == XFAIL) {
      System.out.println(s_results[pass ? XPASS : XFAIL]);
      if (pass) {
        s_result = FAIL;
      } else if (s_result > XFAIL) {
        s_result = XFAIL;
      }
    }
  }


  /**
   * The main test driver takes no command-line arguments and runs the
   * regression tests.
   */
  public static void main(String args[]) {
    try {

      /*
       * Begin the test
       */

      System.out.println("NPARTS -1");

      s_part   = 0;
      s_result = PASS;

      /*
       * Boolean array tests
       */

      if (true) {
        SIDL.Boolean.Array1 array = ArrayTest.ArrayOps.createBool(ONE_D_SIZE);
        check(PASS,
              (array != null),
             "createBool: (array != null)");
        check(PASS,
              (ArrayTest.ArrayOps.checkBool(array) == true),
             "createBool: (ArrayTest.ArrayOps.checkBool(array) == true)");
        check(PASS,
              (ArrayTest.ArrayOps.reverseBool(array, true) == true),
             "createBool: " + 
             "(ArrayTest.ArrayOps.reverseBool(array, true) == true)");

        ArrayTest.ArrayOps.makeBool(218, array);
        check(PASS,
              (ArrayTest.ArrayOps.checkBool(array) == true),
             "makeBool218: (ArrayTest.ArrayOps.checkBool(array) == true)");
        check(PASS,
              (ArrayTest.ArrayOps.reverseBool(array, false) == true),
             "makeBool218: " + 
             "(ArrayTest.ArrayOps.reverseBool(array, false) == true)");
        check(PASS,
              (ArrayTest.ArrayOps.checkBool(array) == false),
             "makeBool218: (ArrayTest.ArrayOps.checkBool(array) == false)");

        ArrayTest.ArrayOps.makeBool(9, array);
        check(PASS,
              (ArrayTest.ArrayOps.reverseBool(array, false) == true),
             "makeBool9: " +
             "(ArrayTest.ArrayOps.reverseBool(array, false) == true)");
        check(PASS,
              (ArrayTest.ArrayOps.checkBool(array) == true),
             "makeBool9: (ArrayTest.ArrayOps.checkBool(array) == true)");
      }

      /*
       * Character array tests
       */

      if (true) {
        SIDL.Character.Array1 array = ArrayTest.ArrayOps.createChar(ONE_D_SIZE);
        check(PASS,
              (array != null),
             "createChar: (array != null)");
        check(PASS,
              (ArrayTest.ArrayOps.checkChar(array) == true),
             "createChar: (ArrayTest.ArrayOps.checkChar(array) == true)");
        check(PASS,
              (ArrayTest.ArrayOps.reverseChar(array, true) == true),
             "createChar: " +
             "(ArrayTest.ArrayOps.reverseChar(array, true) == true)");

        ArrayTest.ArrayOps.makeChar(218, array);
        check(PASS,
              (ArrayTest.ArrayOps.checkChar(array) == true),
             "makeChar: (ArrayTest.ArrayOps.checkChar(array) == true)");
        check(PASS,
              (ArrayTest.ArrayOps.reverseChar(array, false) == true),
             "makeChar: " +
             "(ArrayTest.ArrayOps.reverseChar(array, false) == true)");
        check(PASS,
              (ArrayTest.ArrayOps.checkChar(array) == false),
             "makeChar: (ArrayTest.ArrayOps.checkChar(array) == false)");
      }

      /*
       * Integer array tests
       */

      if (true) {
        SIDL.Integer.Array1 array = ArrayTest.ArrayOps.createInt(ONE_D_SIZE);
        check(PASS,
              (array != null),
             "createInt: (array != null)");
        check(PASS,
              (ArrayTest.ArrayOps.checkInt(array) == true),
             "createInt: (ArrayTest.ArrayOps.checkInt(array) == true)");
        check(PASS,
              (ArrayTest.ArrayOps.reverseInt(array, true) == true),
             "createInt: (ArrayTest.ArrayOps.reverseInt(array, true) == true)");

        ArrayTest.ArrayOps.makeInt(218, array);
        check(PASS,
              (ArrayTest.ArrayOps.checkInt(array) == true),
             "makeInt: (ArrayTest.ArrayOps.checkInt(array) == true)");
        check(PASS,
              (ArrayTest.ArrayOps.reverseInt(array, false) == true),
             "makeInt: (ArrayTest.ArrayOps.reverseInt(array, false) == true)");
        check(PASS,
              (ArrayTest.ArrayOps.checkInt(array) == false),
             "makeInt: (ArrayTest.ArrayOps.checkInt(array) == false)");
      }

      /*
       * Long array tests
       */

      if (true) {
        SIDL.Long.Array1 array = ArrayTest.ArrayOps.createLong(ONE_D_SIZE);
        check(PASS,
              (array != null),
             "createLong: (array != null)");
        check(PASS,
              (ArrayTest.ArrayOps.checkLong(array) == true),
             "createLong: (ArrayTest.ArrayOps.checkLong(array) == true)");
        check(PASS,
              (ArrayTest.ArrayOps.reverseLong(array, true) == true),
             "createLong: " +
             "(ArrayTest.ArrayOps.reverseLong(array, true) == true)");

        ArrayTest.ArrayOps.makeLong(218, array);
        check(PASS,
              (ArrayTest.ArrayOps.checkLong(array) == true),
             "makeLong: (ArrayTest.ArrayOps.checkLong(array) == true)");
        check(PASS,
              (ArrayTest.ArrayOps.reverseLong(array, false) == true),
             "makeLong: " +
             "(ArrayTest.ArrayOps.reverseLong(array, false) == true)");
        check(PASS,
              (ArrayTest.ArrayOps.checkLong(array) == false),
             "makeLong: (ArrayTest.ArrayOps.checkLong(array) == false)");
      }

      /*
       * String array tests
       */

      if (true) {
        SIDL.String.Array1 array = ArrayTest.ArrayOps.createString(ONE_D_SIZE);
        check(PASS,
              (array != null),
             "createString: (array != null)");
        check(PASS,
              (ArrayTest.ArrayOps.checkString(array) == true),
             "createString: (ArrayTest.ArrayOps.checkString(array) == true)");
        check(PASS,
              (ArrayTest.ArrayOps.reverseString(array, true) == true),
             "createString: " + 
             "(ArrayTest.ArrayOps.reverseString(array, true) == true)");

        ArrayTest.ArrayOps.makeString(218, array);
        check(PASS,
              (ArrayTest.ArrayOps.checkString(array) == true),
             "makeString: (ArrayTest.ArrayOps.checkString(array) == true)");
        check(PASS,
              (ArrayTest.ArrayOps.reverseString(array, false) == true),
             "makeString: " +
             "(ArrayTest.ArrayOps.reverseString(array, false) == true)");
        check(PASS,
              (ArrayTest.ArrayOps.checkString(array) == false),
             "makeString: (ArrayTest.ArrayOps.checkString(array) == false)");
      }

      /*
       * Double array tests
       */

      if (true) {
        SIDL.Double.Array1 array = ArrayTest.ArrayOps.createDouble(ONE_D_SIZE);
        check(PASS,
              (array != null),
             "createDouble: (array != null)");
        check(PASS,
              (ArrayTest.ArrayOps.checkDouble(array) == true),
             "createDouble: (ArrayTest.ArrayOps.checkDouble(array) == true)");
        check(PASS,
              (ArrayTest.ArrayOps.reverseDouble(array, true) == true),
             "createDouble: " +
             "(ArrayTest.ArrayOps.reverseDouble(array, true) == true)");

        ArrayTest.ArrayOps.makeDouble(218, array);
        check(PASS,
              (ArrayTest.ArrayOps.checkDouble(array) == true),
             "makeDouble: (ArrayTest.ArrayOps.checkDouble(array) == true)");
        check(PASS,
              (ArrayTest.ArrayOps.reverseDouble(array, false) == true),
             "makeDouble: " + 
             "(ArrayTest.ArrayOps.reverseDouble(array, false) == true)");
        check(PASS,
              (ArrayTest.ArrayOps.checkDouble(array) == false),
             "makeDouble: (ArrayTest.ArrayOps.checkDouble(array) == false)");
      }

      /*
       * Float array tests
       */

      if (true) {
        SIDL.Float.Array1 array = ArrayTest.ArrayOps.createFloat(ONE_D_SIZE);
        check(PASS,
              (array != null),
             "createFloat: (array != null)");
        check(PASS,
              (ArrayTest.ArrayOps.checkFloat(array) == true),
             "createFloat: (ArrayTest.ArrayOps.checkFloat(array) == true)");
        check(PASS,
              (ArrayTest.ArrayOps.reverseFloat(array, true) == true),
             "createFloat: " +
             "(ArrayTest.ArrayOps.reverseFloat(array, true) == true)");

        ArrayTest.ArrayOps.makeFloat(218, array);
        check(PASS,
              (ArrayTest.ArrayOps.checkFloat(array) == true),
             "makeFloat: (ArrayTest.ArrayOps.checkFloat(array) == true)");
        check(PASS,
              (ArrayTest.ArrayOps.reverseFloat(array, false) == true),
             "makeFloat: " +
             "(ArrayTest.ArrayOps.reverseFloat(array, false) == true)");
        check(PASS,
              (ArrayTest.ArrayOps.checkFloat(array) == false),
             "makeFloat: (ArrayTest.ArrayOps.checkFloat(array) == false)");
      }

      /*
       * FloatComplex array tests
       */

      if (true) {
        SIDL.FloatComplex.Array1 array =
          ArrayTest.ArrayOps.createFcomplex(ONE_D_SIZE);
        check(PASS,
              (array != null),
             "createFcomplex: (array != null)");
        check(PASS,
              (ArrayTest.ArrayOps.checkFcomplex(array) == true),
             "createFcomplex: " +
             "(ArrayTest.ArrayOps.checkFcomplex(array) == true)");
        check(PASS,
              (ArrayTest.ArrayOps.reverseFcomplex(array, true) == true),
             "createFcomplex: " +
             "(ArrayTest.ArrayOps.reverseFcomplex(array, true) == true)");

        ArrayTest.ArrayOps.makeFcomplex(218, array);
        check(PASS,
              (ArrayTest.ArrayOps.checkFcomplex(array) == true),
             "makeFcomplex: (ArrayTest.ArrayOps.checkFcomplex(array) == true)");
        check(PASS,
              (ArrayTest.ArrayOps.reverseFcomplex(array, false) == true),
             "makeFcomplex: " +
             "(ArrayTest.ArrayOps.reverseFcomplex(array, false) == true)");
        check(PASS,
              (ArrayTest.ArrayOps.checkFcomplex(array) == false),
             "makeFcomplex: " +
             "(ArrayTest.ArrayOps.checkFcomplex(array) == false)");
      }

      /*
       * DoubleComplex array tests
       */

      if (true) {
        SIDL.DoubleComplex.Array1 array =
          ArrayTest.ArrayOps.createDcomplex(ONE_D_SIZE);
        check(PASS,
              (array != null),
             "createDcomplex: (array != null)");
        check(PASS,
              (ArrayTest.ArrayOps.checkDcomplex(array) == true),
             "createDcomplex: " +
             "(ArrayTest.ArrayOps.checkDcomplex(array) == true)");
        check(PASS,
              (ArrayTest.ArrayOps.reverseDcomplex(array, true) == true),
             "createDcomplex: " +
             "(ArrayTest.ArrayOps.reverseDcomplex(array, true) == true)");

        ArrayTest.ArrayOps.makeDcomplex(218, array);
        check(PASS,
              (ArrayTest.ArrayOps.checkDcomplex(array) == true),
             "makeDcomplex: (ArrayTest.ArrayOps.checkDcomplex(array) == true)");
        check(PASS,
              (ArrayTest.ArrayOps.reverseDcomplex(array, false) == true),
             "makeDcomplex: " +
             "(ArrayTest.ArrayOps.reverseDcomplex(array, false) == true)");
        check(PASS,
              (ArrayTest.ArrayOps.checkDcomplex(array) == false),
             "makeDcomplex: " +
             "(ArrayTest.ArrayOps.checkDcomplex(array) == false)");
      }

      /*
       * Object array tests
       */

      if (true) {
        check(XFAIL, false, "Create an array of objects");
        check(XFAIL, false, "Check an array of objects");
      }

      /*
       * Create and check two dimensional array for integer
       */

      if (true) {
        SIDL.Integer.Array2 array = ArrayTest.ArrayOps.create2Int(TEST_DIM1,
                                                                  TEST_DIM2);
        check(PASS,
              (ArrayTest.ArrayOps.check2Int(array) == true),
             "create2Int: " + 
             "(ArrayTest.ArrayOps.check2Int(array) == true)");
      }

      /*
       * Create and check two dimensional array for double
       */

      if (true) {
        SIDL.Double.Array2 array = ArrayTest.ArrayOps.create2Double(TEST_DIM1,
                                                                    TEST_DIM2);
        check(PASS,
              (ArrayTest.ArrayOps.check2Double(array) == true),
             "create2Double: " + 
             "(ArrayTest.ArrayOps.check2Double(array) == true)");
      }

      /*
       * Create and check two dimensional array for float
       */

      if (true) {
        SIDL.Float.Array2 array = ArrayTest.ArrayOps.create2Float(TEST_DIM1,
                                                                  TEST_DIM2);
        check(PASS,
              (ArrayTest.ArrayOps.check2Float(array) == true),
             "create2Float: (ArrayTest.ArrayOps.check2Float(array) == true)");
      }

      /*
       * Create and check two dimensional array for double complex
       */

      if (true) {
        SIDL.DoubleComplex.Array2 array = ArrayTest.ArrayOps.create2Dcomplex(
                                                         TEST_DIM1, TEST_DIM2);
        check(PASS,
              (ArrayTest.ArrayOps.check2Dcomplex(array) == true),
             "create2Dcomplex:" + 
             "(ArrayTest.ArrayOps.check2Dcomplex(array) == true)");
      }

      /*
       * Create and check two dimensional array for float complex
       */

      if (true) {
        SIDL.FloatComplex.Array2 array = ArrayTest.ArrayOps.create2Fcomplex(
                                                         TEST_DIM1, TEST_DIM2);
        check(PASS,
              (ArrayTest.ArrayOps.check2Fcomplex(array) == true),
             "create2Fcomplex: " +
             "(ArrayTest.ArrayOps.check2Fcomplex(array) == true)");
      }

      /*
       * Create and check three dimensional array for integer
       */

      if (true) {
        SIDL.Integer.Array3 array = ArrayTest.ArrayOps.create3Int();
        check(PASS,
              (ArrayTest.ArrayOps.check3Int(array) == true),
             "create3Int: " +
             "(ArrayTest.ArrayOps.check3Int(array) == true)");
      }

      /*
       * Create and check four dimensional array for integer
       */

      if (true) {
        SIDL.Integer.Array4 array = ArrayTest.ArrayOps.create4Int();
        check(PASS,
              (ArrayTest.ArrayOps.check4Int(array) == true),
             "create4Int: " +
             "(ArrayTest.ArrayOps.check4Int(array) == true)");
      }

      /*
       * inout null Boolean array test
       */

      if (true) {
        check(XFAIL, false, "makeInOutBool using null array");
/*
          SIDL.Boolean.Array1 array = null;
          ArrayTest.ArrayOps.makeInOutBool(array, 218);
          check(PASS,
                (ArrayTest.ArrayOps.checkBool(array) == true),
               "makeInOutBool: (ArrayTest.ArrayOps.checkBool(array) == true)");
*/
      }

      /*
       * inout null Character array test
       */

      if (true) {	
        check(XFAIL, false, "makeInOutChar using null array");
/*
        SIDL.Character.Array1 array = null;
        ArrayTest.ArrayOps.makeInOutChar(array, 218);
        check(PASS,
              (ArrayTest.ArrayOps.checkChar(array) == true),
             "makeInOutChar: (ArrayTest.ArrayOps.checkChar(array) == true)");
*/
      }

      /*
       * inout null Integer array test
       */

      if (true) {	
        check(XFAIL, false, "makeInOutInt using null array");
/*
        SIDL.Integer.Array1 array = null;
        ArrayTest.ArrayOps.makeInOutInt(array, 218);
        check(PASS,
              (ArrayTest.ArrayOps.checkInt(array) == true),
             "makeInOutInt: (ArrayTest.ArrayOps.checkInt(array) == true)");
*/
      }

      /*
       * inout null Long array test
       */

      if (true) {
        check(XFAIL, false, "makeInOutLong using null array");
/*
        SIDL.Long.Array1 array = null;
        ArrayTest.ArrayOps.makeInOutLong(array, 218);
        check(PASS,
              (ArrayTest.ArrayOps.checkLong(array) == true),
             "makeInOutLong: (ArrayTest.ArrayOps.checkLong(array) == true)");
*/
      }

      /*
       * inout null String array test
       */

      if (true) {	
        check(XFAIL, false, "makeInOutString using null array");
/*
        SIDL.String.Array1 array = null;
        ArrayTest.ArrayOps.makeInOutString(array, 218);
        check(PASS,
              (ArrayTest.ArrayOps.checkString(array) == true),
             "makeInOutString: " + 
             "(ArrayTest.ArrayOps.checkString(array) == true)");
*/
      }

      /*
       * inout null Double array test
       */

      if (true) {
        check(XFAIL, false, "makeInOutDouble using null array");
/*
        SIDL.Double.Array1 array = null;
        ArrayTest.ArrayOps.makeInOutDouble(array, 218);
        check(PASS,
              (ArrayTest.ArrayOps.checkDouble(array) == true),
             "makeInOutDouble: " +
             "(ArrayTest.ArrayOps.checkDouble(array) == true)");
*/
      }

      /*
       * inout null Float array test
       */

      if (true) {
        check(XFAIL, false, "makeInOutFloat using null array");
/*
        SIDL.Float.Array1 array = null;
        ArrayTest.ArrayOps.makeInOutFloat(array, 218);
        check(PASS,
              (ArrayTest.ArrayOps.checkFloat(array) == true),
             "makeInOutFloat: (ArrayTest.ArrayOps.checkFloat(array) == true)");
*/
      }

      /*
       * inout null FloatComplex array test
       */

      if (true) {
        check(XFAIL, false, "makeInOutFloatComplex using null array");
/*
        SIDL.FloatComplex.Array1 array = null;
        ArrayTest.ArrayOps.makeInOutFcomplex(array, 218);
        check(PASS,
              (ArrayTest.ArrayOps.checkFcomplex(array) == true),
             "makeInOutFcomplex: " +
             "(ArrayTest.ArrayOps.checkFcomplex(array) == true)");
*/
      }

      /*
       * inout null DoubleComplex array test
       */

      if (true) {
        check(XFAIL, false, "makeInOutDoubleComplex using null array");
/*
        SIDL.DoubleComplex.Array1 array = null;
        ArrayTest.ArrayOps.makeInOutDcomplex(array, 218);
        check(PASS,
              (ArrayTest.ArrayOps.checkDcomplex(array) == true),
             "makeInOutDcomplex: " +
             "(ArrayTest.ArrayOps.checkDcomplex(array) == true)");
*/
      }

      /*
       * inout null 2D integer array test
       */

      if (true) {
        check(XFAIL, false, "makeInOut2Int using null array");
/*
        SIDL.Int.Array2 array = null;
        ArrayTest.ArrayOps.makeInOut2Int(array, 218);
        check(PASS,
              (ArrayTest.ArrayOps.check2Int(array) == true),
             "makeInOut2Int: " +
             "(ArrayTest.ArrayOps.check2Int(array) == true)");
*/
      }

      /*
       * inout null 2D double array test
       */

      if (true) {
        check(XFAIL, false, "makeInOut2Double using null array");
/*
        SIDL.Double.Array2 array = null;
        ArrayTest.ArrayOps.makeInOut2Double(array, 218);
        check(PASS,
              (ArrayTest.ArrayOps.check2Double(array) == true),
             "makeInOut2Double: " +
             "(ArrayTest.ArrayOps.check2Double(array) == true)");
*/
      }

      /*
       * inout null 2D float array test
       */

      if (true) {
        check(XFAIL, false, "makeInOut2Float using null array");
/*
        SIDL.Float.Array2 array = null;
        ArrayTest.ArrayOps.makeInOut2Float(array, 218);
        check(PASS,
              (ArrayTest.ArrayOps.check2Float(array) == true),
             "makeInOut2Float: " +
             "(ArrayTest.ArrayOps.check2Float(array) == true)");
*/
      }

      /*
       * inout null 2D double complex array test
       */

      if (true) {
        check(XFAIL, false, "makeInOut2Dcomplex using null array");
/*
        SIDL.Dcomplex.Array2 array = null;
        ArrayTest.ArrayOps.makeInOut2Dcomplex(array, 218);
        check(PASS,
              (ArrayTest.ArrayOps.check2Dcomplex(array) == true),
             "makeInOut2Dcomplex: " +
             "(ArrayTest.ArrayOps.check2Dcomplex(array) == true)");
*/
      }

      /*
       * inout null 2D float complex array test
       */

      if (true) {
        check(XFAIL, false, "makeInOut2Fcomplex using null array");
/*
        SIDL.Fcomplex.Array2 array = null;
        ArrayTest.ArrayOps.makeInOut2Fcomplex(array, 218);
        check(PASS,
              (ArrayTest.ArrayOps.check2Fcomplex(array) == true),
             "makeInOut2Fcomplex: " +
             "(ArrayTest.ArrayOps.check2Fcomplex(array) == true)");
*/
      }

      /*
       * inout null 3D integer array test
       */

      if (true) {
        check(XFAIL, false, "makeInOut3Int using null array");
/*
        SIDL.Fcomplex.Array3 array = null;
        ArrayTest.ArrayOps.makeInOut3Int(array, 218);
        check(PASS,
              (ArrayTest.ArrayOps.check3Int(array) == true),
             "makeInOut3Int: " +
             "(ArrayTest.ArrayOps.check3Int(array) == true)");
*/
      }

      /*
       * inout null 4D integer array test
       */

      if (true) {
        check(XFAIL, false, "makeInOut4Int using null array");
/*
        SIDL.Fcomplex.Array4 array = null;
        ArrayTest.ArrayOps.makeInOut4Int(array, 218);
        check(PASS,
              (ArrayTest.ArrayOps.check4Int(array) == true),
             "makeInOut4Int: " +
             "(ArrayTest.ArrayOps.check4Int(array) == true)");
*/
      }


      /*
       * Output final test results
       */

      System.out.println("TEST_RESULT " + s_results[s_result]);

      Runtime.getRuntime().exit(0); /* workaround for Linux JVM 1.3.1 bug */
    /*
     * Catch any unexpected exceptions and return a test failure
     */
    } catch (Throwable ex) {
      System.out.println("TEST_RESULT FAIL");
      System.out.println(ex.toString());
      System.exit(1);
    }
  }
}

