#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "enums.h"

void declare_part( int * part_no );
void end_part( int part_no, int result, int *final_result );

char * result_string[] = { "FAIL", "XFAIL", "PASS", "XPASS", "UNSUPPORTED" };
const int unsupported = 4;
const int xpass = 3;
const int pass = 2;
const int xfail = 1;
const int fail = 0;

/**
 * Fill the stack with random junk.
 */
int clearstack(int magicNumber) {
  int chunk[2048], i;
  for(i = 0; i < 2048; i++){
    chunk[i] = rand() + magicNumber;
  }
  for(i = 0; i < 16; i++){
    magicNumber += chunk[rand() & 2047];
  }
  return magicNumber;
}

#define MYASSERT( AAA ) \
  declare_part( &part_no ); \
  magicNumber = clearstack(magicNumber); \
  printf("COMMENT: %s\n", #AAA ); \
  if ( AAA ) result = pass; \
  else result = fail;  \
  end_part( part_no, result, &final_result );

#define MYXFAIL( AAA ) \
  declare_part( &part_no ); \
  magicNumber = clearstack(magicNumber); \
  printf("COMMENT: %s\n", #AAA ); \
  if ( AAA ) result = xpass; \
  else result = xfail;  \
  end_part( part_no, result, &final_result );

#define MYBROKEN( AAA ) \
  declare_part( &part_no ); \
  printf("COMMENT: %s\n", #AAA ); \
  end_part( part_no, unsupported, &final_result );

int main(int argc, char** argv)
{
  int result = pass; 
  int final_result = pass;
  int magicNumber = 1;
  int part_no = 0;

  (void) argc;
  (void) argv;

  printf("NPARTS -1\n");
  
  { /* undefined integer values */
    enum enums_color__enum out = -5;
    enum enums_color__enum inout = enums_color_green;
    enums_colorwheel obj = enums_colorwheel__create();
 
    MYASSERT( enums_colorwheel_returnback( obj ) == enums_color_violet );
    MYASSERT( enums_colorwheel_passin( obj, enums_color_blue ) == TRUE );
    MYASSERT( enums_colorwheel_passout( obj, &out ) == TRUE && out == enums_color_violet );
    MYASSERT( enums_colorwheel_passinout( obj, &inout ) == TRUE && inout == enums_color_red );
    out = enums_color_red;
    MYASSERT( enums_colorwheel_passeverywhere( obj, enums_color_blue, &out, &inout ) == enums_color_violet &&
	      out == enums_color_violet && inout == enums_color_green );
    
    enums_colorwheel_deleteRef( obj );
  }

  { /* fully defined integer values */
    enum enums_car__enum out = -5;
    enum enums_car__enum inout = enums_car_ford;
    enums_cartest obj = enums_cartest__create();
 
    MYASSERT( enums_cartest_returnback( obj ) == enums_car_porsche );
    MYASSERT( enums_cartest_passin( obj, enums_car_mercedes ) == TRUE );
    MYASSERT( enums_cartest_passout( obj, &out ) == TRUE && out == enums_car_ford );
    MYASSERT( enums_cartest_passinout( obj, &inout ) == TRUE && inout == enums_car_porsche );
    out = -5;
    MYASSERT( enums_cartest_passeverywhere( obj, enums_car_mercedes, &out, &inout ) == enums_car_porsche
	      && out == enums_car_ford && inout == enums_car_mercedes );
    
    enums_cartest_deleteRef( obj );
  }

  { /* partially defined integer values */
    enum enums_number__enum out=-5;
    enum enums_number__enum inout = enums_number_zero;
    enums_numbertest obj = enums_numbertest__create();
 
    MYASSERT( enums_numbertest_returnback( obj ) == enums_number_notOne );
    MYASSERT( enums_numbertest_passin( obj, enums_number_notZero ) == TRUE );
    MYASSERT( enums_numbertest_passout( obj, &out ) == TRUE && out == enums_number_negOne );
    MYASSERT( enums_numbertest_passinout( obj, &inout ) == TRUE && inout == enums_number_notZero );
    out = -5;
    MYASSERT( enums_numbertest_passeverywhere( obj, enums_number_notZero, &out, &inout ) == enums_number_notOne &&
	      out == enums_number_negOne && inout == enums_number_zero );
    
    enums_numbertest_deleteRef( obj );
  }

  {
    const int32_t numElem[] = { 2 };
    const int32_t stride[] = { 2 };
    struct enums_car__array *enumArray = enums_car__array_create1d(4);
    struct enums_car__array *slicedArray = NULL;
    struct enums_car__array *cpArray = NULL;

    MYASSERT( enumArray );
    enums_car__array_set1(enumArray, 0, enums_car_porsche);
    enums_car__array_set1(enumArray, 1, enums_car_ford);
    enums_car__array_set1(enumArray, 2, enums_car_mercedes);
    enums_car__array_set1(enumArray, 3, enums_car_porsche);
    MYASSERT( enums_car_porsche == enums_car__array_get1(enumArray, 0) );
    MYASSERT( enums_car_ford == enums_car__array_get1(enumArray, 1) );
    MYASSERT( enums_car_mercedes == enums_car__array_get1(enumArray, 2) );
    MYASSERT( enums_car_porsche == enums_car__array_get1(enumArray, 3) );
    slicedArray =
      enums_car__array_slice(enumArray, 1, numElem, NULL, stride, NULL);
    MYASSERT( slicedArray );
    MYASSERT( enums_car_porsche == enums_car__array_get1(slicedArray, 0) );
    MYASSERT( enums_car_mercedes == enums_car__array_get1(slicedArray, 1));
    cpArray = enums_car__array_smartCopy(slicedArray);
    MYASSERT(cpArray);
    MYASSERT( enums_car_porsche == enums_car__array_get1(cpArray, 0) );
    MYASSERT( enums_car_mercedes == enums_car__array_get1(cpArray, 1));
    enums_car__array_deleteRef(cpArray);
    enums_car__array_deleteRef(slicedArray);
    enums_car__array_deleteRef(enumArray);
  }
  printf("TEST_RESULT %s\n", result_string[ final_result ] );
  return 0;
}

void declare_part( int * part_no ) {
  ++(*part_no);
  printf("PART %d\n", *part_no );
}

void end_part( int part_no, int result, int *final_result ) {
  printf("RESULT %d %s\n", part_no, result_string[ result ] );
  if ( result == xpass ) {
    *final_result = fail;
  } else if ( result == unsupported && *final_result == pass ) { 
    *final_result = xfail;
  } else if ( result < *final_result ) { 
    *final_result = result;
  }
}

