/*
 * File:          ExceptionTest_Fib_Impl.c
 * Symbol:        ExceptionTest.Fib-v1.0
 * Symbol Type:   class
 * Babel Version: 0.8.8
 * Description:   Server-side implementation for ExceptionTest.Fib
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.8.8
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "ExceptionTest.Fib" (version 1.0)
 * 
 * This class holds the method <code>getFib</code> that generates the
 * requested Fibonacci numbers.
 */

#include "ExceptionTest_Fib_Impl.h"

/* DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._includes) */
#include "SIDL_Exception.h"
#include "ExceptionTest_NegativeValueException.h"
#include "ExceptionTest_TooDeepException.h"
#include "ExceptionTest_TooBigException.h"
/* DO-NOT-DELETE splicer.end(ExceptionTest.Fib._includes) */

/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_ExceptionTest_Fib__ctor"

void
impl_ExceptionTest_Fib__ctor(
  ExceptionTest_Fib self)
{
  /* DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._ctor) */
  /* nothing needed */
  /* DO-NOT-DELETE splicer.end(ExceptionTest.Fib._ctor) */
}

/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_ExceptionTest_Fib__dtor"

void
impl_ExceptionTest_Fib__dtor(
  ExceptionTest_Fib self)
{
  /* DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._dtor) */
  /* nothing needed */
  /* DO-NOT-DELETE splicer.end(ExceptionTest.Fib._dtor) */
}

/*
 * <p>
 * Generate the requested Fibonacci number or generate exceptions if
 * the input Fibonacci number is invalid or if any of the maximum depth
 * or maximum value parameters are exceeded.  The last argument of the
 * method should be zero.
 * </p>
 * <p>
 * The logic method should be similar to the following <code>Java</code>:
 * </p>
 * <pre>
 * public int getFib(int n, int max_depth, int max_value, int depth)
 *     throws NegativeValueException, FibException {
 * 
 *   if (n < 0) {
 *     throw new NegativeValueException("n negative");
 * 
 *   } else if (depth > max_depth) {
 *     throw new TooDeepException("too deep");
 * 
 *   } else if (n == 0) {
 *     return 1;
 * 
 *   } else if (n == 1) {
 *     return 1;
 * 
 *   } else {
 *     int a = getFib(n-1, max_depth, max_value, depth+1);
 *     int b = getFib(n-2, max_depth, max_value, depth+1);
 *     if (a + b > max_value) {
 *       throw new TooBigException("too big");
 *     }
 *     return a + b;
 *   }
 * } 
 * </pre>
 */

#undef __FUNC__
#define __FUNC__ "impl_ExceptionTest_Fib_getFib"

int32_t
impl_ExceptionTest_Fib_getFib(
  ExceptionTest_Fib self, int32_t n, int32_t max_depth, int32_t max_value,
    int32_t depth, SIDL_BaseException* _ex)
{
  /* DO-NOT-DELETE splicer.begin(ExceptionTest.Fib.getFib) */
  int32_t a;
  int32_t b;
  int32_t theValue = 0;

  if (n < 0) {
    SIDL_THROW(*_ex,
               ExceptionTest_NegativeValueException,
               "called with negative n");
  } else if (depth > max_depth) {
    SIDL_THROW(*_ex,
               ExceptionTest_TooDeepException,
               "exceeded specified recursion depth");
  } else if (n == 0) {
    theValue = 1;
  } else if (n == 1) {
    theValue = 1;
  } else {
    a = impl_ExceptionTest_Fib_getFib(
      self,
      n-1,
      max_depth,
      max_value, 
      depth+1,
      _ex); SIDL_CHECK(*_ex);
    b = impl_ExceptionTest_Fib_getFib(
      self,
      n-2,
      max_depth,
      max_value, 
      depth+1,
      _ex); SIDL_CHECK(*_ex);
    theValue = a + b;
    if (theValue > max_value) {
      /* Reset the value since returning an exception */
      theValue = 0;
      SIDL_THROW(*_ex,
                 ExceptionTest_TooBigException,
                 "result exceeds specified maximum value");
    }
  }

  EXIT:;
    return theValue;
  /* DO-NOT-DELETE splicer.end(ExceptionTest.Fib.getFib) */
}
