// 
// File:          ExceptionTest_Fib_Impl.cc
// Symbol:        ExceptionTest.Fib-v1.0
// Symbol Type:   class
// Babel Version: 0.8.8
// Description:   Server-side implementation for ExceptionTest.Fib
// 
// WARNING: Automatically generated; only changes within splicers preserved
// 
// babel-version = 0.8.8
// 
#include "ExceptionTest_Fib_Impl.hh"

// DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._includes)
#include "ExceptionTest_NegativeValueException.hh"
#include "ExceptionTest_TooDeepException.hh"
#include "ExceptionTest_TooBigException.hh"
// DO-NOT-DELETE splicer.end(ExceptionTest.Fib._includes)

// user defined constructor
void ExceptionTest::Fib_impl::_ctor() {
  // DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._ctor)
  // add construction details here
  // DO-NOT-DELETE splicer.end(ExceptionTest.Fib._ctor)
}

// user defined destructor
void ExceptionTest::Fib_impl::_dtor() {
  // DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._dtor)
  // add destruction details here
  // DO-NOT-DELETE splicer.end(ExceptionTest.Fib._dtor)
}

// user defined static methods: (none)

// user defined non-static methods:
/**
 * <p>
 * Generate the requested Fibonacci number or generate exceptions if
 * the input Fibonacci number is invalid or if any of the maximum depth
 * or maximum value parameters are exceeded.  The last argument of the
 * method should be zero.
 * </p>
 * <p>
 * The logic method should be similar to the following <code>Java</code>:
 * </p>
 * <pre>
 * public int getFib(int n, int max_depth, int max_value, int depth)
 *     throws NegativeValueException, FibException {
 * 
 *   if (n < 0) {
 *     throw new NegativeValueException("n negative");
 * 
 *   } else if (depth > max_depth) {
 *     throw new TooDeepException("too deep");
 * 
 *   } else if (n == 0) {
 *     return 1;
 * 
 *   } else if (n == 1) {
 *     return 1;
 * 
 *   } else {
 *     int a = getFib(n-1, max_depth, max_value, depth+1);
 *     int b = getFib(n-2, max_depth, max_value, depth+1);
 *     if (a + b > max_value) {
 *       throw new TooBigException("too big");
 *     }
 *     return a + b;
 *   }
 * } 
 * </pre>
 */
int32_t
ExceptionTest::Fib_impl::getFib (
  /*in*/ int32_t n,
  /*in*/ int32_t max_depth,
  /*in*/ int32_t max_value,
  /*in*/ int32_t depth ) 
throw ( 
  ::ExceptionTest::FibException, 
  ::ExceptionTest::NegativeValueException
){
  // DO-NOT-DELETE splicer.begin(ExceptionTest.Fib.getFib)
  if (n < 0) {
    NegativeValueException ex = NegativeValueException::_create();
    ex.setNote("n negative");
    ex.add(__FILE__, __LINE__, "ExceptionTest::Fib_impl::getFib");
    throw ex;

  } else if (depth > max_depth) {
    TooDeepException ex = TooDeepException::_create();
    ex.setNote("too deep");
    ex.add(__FILE__, __LINE__, "ExceptionTest::Fib_impl::getFib");
    FibException ex2 = ex;
    throw ex2;

  } else if (n == 0) {
    return 1;

  } else if (n == 1) {
    return 1;

  } else {
    int32_t a = getFib(n-1, max_depth, max_value, depth+1);
    int32_t b = getFib(n-2, max_depth, max_value, depth+1);
    if (a + b > max_value) {
      TooBigException ex = TooBigException::_create();
      ex.setNote("too big");
      ex.add(__FILE__, __LINE__, "ExceptionTest::Fib_impl::getFib");
      FibException ex2 = ex;
      throw ex2;
    }
    return a + b;
  }
  // DO-NOT-DELETE splicer.end(ExceptionTest.Fib.getFib)
}


// DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._misc)
// Put miscellaneous code here
// DO-NOT-DELETE splicer.end(ExceptionTest.Fib._misc)

