/*
 * File:        exceptionclient.c
 * Copyright:   (c) 2001 The Regents of the University of California
 * Release:     $Name: release-0-8-8 $
 * Revision:    @(#) $Revision: 1.5 $
 * Date:        $Date: 2002/09/30 23:01:00 $
 * Description: Exception Test C client
 *
 */

#include <stdio.h>
#include "SIDL_Exception.h"
#include "SIDL_String.h"
#include "ExceptionTest_Fib.h"

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE 1
#endif

char* result_string[] = { "FAIL", "XFAIL", "PASS", "XPASS", "UNSUPPORTED" };
const int unsupported = 4;
const int fail  = 0;
const int xfail = 1;
const int pass  = 2;
const int xpass = 3;

static void declare_part( int * part_no )
{
  ++(*part_no);
  printf("PART %d\n", *part_no);
}

static void end_part(int part_no, int result, int *final_result)
{
  printf("RESULT %d %s\n", part_no, result_string[result]);
  if (result == xpass) {
    *final_result = fail;
  } else if ((result == unsupported) && (*final_result == pass)) { 
    *final_result = xfail;
  } else if (result < *final_result) { 
    *final_result = result;
  }
}

static void traceback(SIDL_BaseException _ex)
{
  char* msg = NULL;

  msg = SIDL_BaseException_getNote(_ex);
  printf("%s\n", msg);
  SIDL_String_free(msg);

  msg = SIDL_BaseException_getTrace(_ex);
  printf("%s\n", msg);
  SIDL_String_free(msg);
}

#define CHECK(FUNC,COMMENT)                 \
  declare_part(&part_no);                   \
  printf("COMMENT: %s\n", COMMENT);         \
  result = (FUNC) ? pass : fail;            \
  end_part(part_no, result, &final_result);

int runTest1(ExceptionTest_Fib f)
{
  int x;
  SIDL_BaseException _ex = NULL;

  x = ExceptionTest_Fib_getFib(f, 10, 25, 200, 0, &_ex); SIDL_CHECK(_ex);
  return TRUE;

  EXIT:;
    traceback(_ex);
    SIDL_CLEAR(_ex);
    return FALSE;
}

int runTest2(ExceptionTest_Fib f)
{
  int x;
  SIDL_BaseException _ex = NULL;

  x = ExceptionTest_Fib_getFib(f, -1, 10, 10, 0, &_ex);
  if (SIDL_CATCH(_ex, "ExceptionTest.NegativeValueException")) {
    traceback(_ex);
    SIDL_CLEAR(_ex);
  } else if (_ex == NULL) {
    return FALSE;
  }
  SIDL_CHECK(_ex);
  return TRUE;

  EXIT:;
    traceback(_ex);
    SIDL_CLEAR(_ex);
    return FALSE;
}

int runTest3(ExceptionTest_Fib f)
{
  int x;
  SIDL_BaseException _ex = NULL;

  x = ExceptionTest_Fib_getFib(f, 10, 1, 100, 0, &_ex);
  if (SIDL_CATCH(_ex, "ExceptionTest.TooDeepException")) {
    traceback(_ex);
    SIDL_CLEAR(_ex);
  } else if (_ex == NULL) {
    return FALSE;
  }
  SIDL_CHECK(_ex);
  return TRUE;

  EXIT:;
    traceback(_ex);
    SIDL_CLEAR(_ex);
    return FALSE;
}

int runTest4(ExceptionTest_Fib f)
{
  int x;
  SIDL_BaseException _ex = NULL;

  x = ExceptionTest_Fib_getFib(f, 10, 100, 1, 0, &_ex);
  if (SIDL_CATCH(_ex, "ExceptionTest.TooBigException")) {
    traceback(_ex);
    SIDL_CLEAR(_ex);
  } else if (_ex == NULL) {
    return FALSE;
  }
  SIDL_CHECK(_ex);
  return TRUE;

  EXIT:;
    traceback(_ex);
    SIDL_CLEAR(_ex);
    return FALSE;
}

int main(int argc, char**argv)
{ 
  int result       = pass; 
  int final_result = pass;
  int magicNumber  = 1;
  int part_no      = 0;

  ExceptionTest_Fib fib = ExceptionTest_Fib__create ();

  (void) argc;
  (void) argv;

  printf("NPARTS 4\n");
  CHECK(runTest1(fib), "checking no exception thrown");
  CHECK(runTest2(fib), "checking ExceptionTest.NegativeValueException");
  CHECK(runTest3(fib), "checking ExceptionTest.TooDeepException");
  CHECK(runTest4(fib), "checking ExceptionTest.TooBigException");
  printf("TEST_RESULT %s\n", result_string[final_result] );

  ExceptionTest_Fib_deleteRef (fib);
  return 0;
}
