
#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "Inherit.h"

char * result_string[] = { "FAIL", "XFAIL", "PASS", "XPASS", "UNSUPPORTED" };
const int unsupported = 4;
const int xpass = 3;
const int pass = 2;
const int xfail = 1;
const int fail = 0;

/**
 * Fill the stack with random junk.
 */
int clearstack(int magicNumber) {
  int chunk[2048], i;
  for(i = 0; i < 2048; i++){
    chunk[i] = rand() + magicNumber;
  }
  for(i = 0; i < 16; i++){
    magicNumber += chunk[rand() & 2047];
  }
  return magicNumber;
}

void freeResult(char **result)
{
  if (result && *result) {
    free((void *)(*result));
    *result = NULL;
  }
}

void declare_part( int * part_no ) {
  ++(*part_no);
  printf("PART %d\n", *part_no );
}

void end_part( int part_no, int result, int *final_result ) {
  printf("RESULT %d %s\n", part_no, result_string[ result ] );
  if ( result == xpass ) {
    *final_result = fail;
  } else if ( result == unsupported && *final_result == pass ) { 
    *final_result = xfail;
  } else if ( result < *final_result ) { 
    *final_result = result;
  }
}

#define MYASSERT( AAA ) \
  declare_part( &part_no ); \
  magicNumber = clearstack(magicNumber); \
  printf("COMMENT: %s\n", #AAA ); \
  if ( (AAA) ) result = pass; \
  else result = fail;  \
  end_part( part_no, result, &final_result );

#define INHERITTEST( METHOD, ARG, RESULT ) \
  { \
    char *method_result; \
    printf("COMMENT: method %s(%s)  should return %s\n", \
           #METHOD, #ARG,RESULT); \
    method_result = METHOD(ARG); \
    MYASSERT(method_result && !strcmp(method_result, RESULT)); \
    freeResult(&method_result); \
  }

#define MYXFAIL( AAA ) \
  declare_part( &part_no ); \
  magicNumber = clearstack(magicNumber); \
  printf("COMMENT: %s\n", #AAA ); \
  if ( AAA ) result = xpass; \
  else result = xfail;  \
  end_part( part_no, result, &final_result );

#define MYBROKEN( AAA ) \
  declare_part( &part_no ); \
  printf("COMMENT: %s\n", #AAA ); \
  end_part( part_no, unsupported, &final_result );

int main( int argc, char * argv[] ) { 
  int result = pass; 
  int final_result = pass;
  int magicNumber = 1;
  int part_no = 0;
  printf("NPARTS -1\n");

  { 
    Inherit_C  c;
    char *tmp = NULL;
    c = Inherit_C__create();
    printf("\n\nClass C:\n");
    INHERITTEST(Inherit_C_c, c, "C.c");
    tmp = Inherit_C_c( c );
    Inherit_C_deleteRef( c );
    free(tmp);
  }

  { 
    Inherit_A a;
    Inherit_D d;
    d = Inherit_D__create();
    printf("\n\nClass D: inheritance of interface A\n");
    INHERITTEST(Inherit_D_a, d, "D.a");
    INHERITTEST(Inherit_D_d, d, "D.d");

    printf("\n\nClass D: via interface A\n");
    MYASSERT(a = Inherit_A__cast(d));
    if (a) {
      Inherit_D_addRef( d );
      INHERITTEST(Inherit_A_a, a, "D.a");
      Inherit_A_deleteRef( a );
    }
    Inherit_D_deleteRef( d );
  }

  { 
    Inherit_E e; 
    Inherit_C c;
    e = Inherit_E__create();
    printf("\n\nClass E: inheritance of class C\n");
    INHERITTEST(Inherit_E_c, e, "C.c");
    INHERITTEST(Inherit_E_e, e, "E.e");

    printf("\n\nClass E: via class C (C.c not overridden)\n");
    MYASSERT(c = Inherit_C__cast(e));
    if (c) {
      Inherit_E_addRef( e );
      INHERITTEST(Inherit_C_c, c, "C.c");
      Inherit_C_deleteRef( c );
    }
    Inherit_E_deleteRef( e );
  }

  { 
    Inherit_E2 e2; 
    Inherit_C c;
    e2 = Inherit_E2__create();
    printf("\n\nClass E2: inheritance of class C\n");
    INHERITTEST(Inherit_E2_c, e2, "E2.c");
    INHERITTEST(Inherit_E2_e, e2, "E2.e");

    printf("\n\nClass E2: via class C (C.c overridden)\n");
    MYASSERT(c = Inherit_C__cast(e2));
    if (c) {
      Inherit_E2_addRef( e2 );
      INHERITTEST(Inherit_C_c, c, "E2.c");
      Inherit_C_deleteRef( c );
    }
    Inherit_E2_deleteRef( e2 );
  }

  { 
    Inherit_F f;
    Inherit_A a;
    Inherit_B b;
    Inherit_C c;

    f = Inherit_F__create();
    printf("\n\nClass F: Multiple inheritance (no overriding)\n");
    INHERITTEST(Inherit_F_a, f, "F.a");
    INHERITTEST(Inherit_F_b, f, "F.b");
    INHERITTEST(Inherit_F_c, f, "C.c");
    INHERITTEST(Inherit_F_f, f, "F.f");

    
    printf("\n\nClass F: via interface A\n");
    MYASSERT(a = Inherit_A__cast(f));
    if (a) {
      Inherit_F_addRef( f );
      INHERITTEST(Inherit_A_a, a, "F.a");
      Inherit_A_deleteRef( a );
    }

    printf("\n\nClass F: via interface B\n");
    MYASSERT(b = Inherit_B__cast(f));
    if (b) {
      Inherit_F_addRef( f );
      INHERITTEST(Inherit_B_b, b, "F.b");
      Inherit_B_deleteRef( b );
    }

    printf("\n\nClass F: via class C (no overloading of C.c)\n");
    MYASSERT(c = Inherit_C__cast(f));
    if (c) {
      Inherit_F_addRef( f );
      INHERITTEST(Inherit_C_c, c, "C.c");
      Inherit_C_deleteRef( c );
    } 
    Inherit_F_deleteRef( f );
  }

  { 
    Inherit_F2 f2;
    Inherit_A a;
    Inherit_B b;
    Inherit_C c;

    f2 = Inherit_F2__create();
    printf("\n\nClass F2: Multiple inheritance (overrides C.c)\n");
    INHERITTEST(Inherit_F2_a, f2, "F2.a");
    INHERITTEST(Inherit_F2_b, f2, "F2.b");
    INHERITTEST(Inherit_F2_c, f2, "F2.c");
    INHERITTEST(Inherit_F2_f, f2, "F2.f");
    
    printf("\n\nClass F2: via interface A\n");
    MYASSERT(a = Inherit_A__cast(f2));
    if (a) {
      Inherit_F2_addRef( f2 );
      INHERITTEST(Inherit_A_a, a, "F2.a");
      Inherit_A_deleteRef( a );
    }

    printf("\n\nClass F2: via interface B\n");
    MYASSERT(b = Inherit_B__cast(f2));
    if (b) {
      Inherit_F2_addRef( f2 );
      INHERITTEST(Inherit_B_b, b, "F2.b");
      Inherit_B_deleteRef( b );
    }

    printf("\n\nClass F2: via class C (overloads C.c)\n");
    MYASSERT(c = Inherit_C__cast(f2));
    if (c) {
      Inherit_F2_addRef( f2 );
      INHERITTEST(Inherit_C_c, c, "F2.c");
      Inherit_C_deleteRef( c );
    } 
    Inherit_F2_deleteRef( f2);
  }

  { 
    Inherit_G g;
    Inherit_A a;
    Inherit_D d;
    g = Inherit_G__create();

    printf("\n\nClass G: indirect multiple inheritance ( no overloads)\n");
    INHERITTEST(Inherit_G_a, g, "D.a");
    INHERITTEST(Inherit_G_d, g, "D.d");
    INHERITTEST(Inherit_G_g, g, "G.g");

    
    printf("\n\nClass G: via interface A\n");
    MYASSERT(a = Inherit_A__cast(g));
    if (a) {
      Inherit_G_addRef( g );
      INHERITTEST(Inherit_A_a, a, "D.a");
      Inherit_A_deleteRef( a );
    }

    printf("\n\nClass G: via class D\n");
    MYASSERT(d = Inherit_D__cast(g));
    if (d) {
      Inherit_G_addRef( g );
      INHERITTEST(Inherit_D_a, d, "D.a");
      INHERITTEST(Inherit_D_d, d, "D.d");
      Inherit_D_deleteRef( d );
    }

    Inherit_G_deleteRef(g);
  }
  
  { 
    Inherit_G2 g2;
    Inherit_A a;
    Inherit_D d;

    g2 = Inherit_G2__create();

    printf("\n\nClass G2: indirect multiple inheritance (overloads)\n");
    INHERITTEST(Inherit_G2_a, g2, "G2.a");
    INHERITTEST(Inherit_G2_g, g2, "G2.g");

    printf("\n\nClass G2: via interface A\n");
    MYASSERT(a = Inherit_A__cast(g2));
    if (a) {
      Inherit_G2_addRef( g2 );
      INHERITTEST(Inherit_A_a, a, "G2.a");
      Inherit_A_deleteRef( a );
    }

    printf("\n\nClass G2: via class D\n");
    MYASSERT(d = Inherit_D__cast(g2));
    if (d) {
      Inherit_G2_addRef( g2 );
      INHERITTEST(Inherit_D_a, d, "G2.a");
      INHERITTEST(Inherit_D_d, d, "G2.d");
      Inherit_D_deleteRef( d );
    }
    Inherit_G2_deleteRef( g2 );
  }

  {
    Inherit_I i;
    i = Inherit_I__create();
    printf("\n\nClass I: implement abstract class H which implements A\n");
    INHERITTEST(Inherit_I_a, i, "I.a");
    INHERITTEST(Inherit_I_h, i, "I.h");
    Inherit_I_deleteRef(i);
  }

  printf("\n");
  printf("TEST_RESULT %s\n", result_string[ final_result ] );
  return 0;
}

