// 
// File:        InheritTest.java
// Copyright:   (c) 2001 The Regents of the University of California
// Release:     $Name: release-0-8-8 $
// Revision:    @(#) $Revision: 1.3 $
// Date:        $Date: 2002/02/14 19:48:21 $
// Description: inherit regression test case for Java calling other languages
// 

/**
 * The following class runs the inherit regression test cases for Java.
 */
public class InheritTest {
  private final static int FAIL        = 0;
  private final static int XFAIL       = 1;
  private final static int PASS        = 2;
  private final static int XPASS       = 3;
  private final static int UNSUPPORTED = 4;

  private final static String[] s_results = {
    "FAIL",
    "XFAIL",
    "PASS",
    "XPASS",
    "UNSUPPORTED"
  };

  private static int s_part = 0;
  private static int s_result = PASS;

  /**
   * Check the results of the test case.
   */
  private static void check(String result, String expected) {
    System.out.println("PART " + String.valueOf(++s_part));
    System.out.println("COMMENT \"" + result + "\" == \"" + expected + "\"");
    System.out.print("RESULT " + String.valueOf(s_part) + " ");

    if (result.equals(expected)) {
      System.out.println(s_results[PASS]);
    } else {
      System.out.println(s_results[FAIL]);
      s_result = FAIL;
    }
  }

  /**
   * The main test driver takes no command-line arguments and runs the
   * regression tests.
   */
  public static void main(String args[]) {
    try {
      /*
       * Begin the test
       */
      System.out.println("NPARTS -1");

      s_part   = 0;
      s_result = PASS;

      /*
       * Test Class C
       */
      if (true) {
        Inherit.C c = new Inherit.C();
        check(c.c(), "C.c");
      }

      /*
       * Test Class D
       */
      if (true) {
        Inherit.D d = new Inherit.D();
        check(d.a(), "D.a");
        check(d.d(), "D.d");
        Inherit.A a = d;
        check(a.a(), "D.a");
      }

      /*
       * Test Class E
       */
      if (true) {
        Inherit.E e = new Inherit.E();
        check(e.c(), "C.c");
        check(e.e(), "E.e");
        Inherit.C c = e;
        check(c.c(), "C.c");
      }

      /*
       * Test Class E2
       */
      if (true) {
        Inherit.E2 e2 = new Inherit.E2();
        check(e2.c(), "E2.c");
        check(e2.e(), "E2.e");
        Inherit.C c = e2;
        check(c.c(), "E2.c");
      }

      /*
       * Test Class F
       */
      if (true) {
        Inherit.F f = new Inherit.F();
        check(f.a(), "F.a");
        check(f.b(), "F.b");
        check(f.c(), "C.c");
        check(f.f(), "F.f");
        Inherit.A a = f;
        check(a.a(), "F.a");
        Inherit.B b = f;
        check(b.b(), "F.b");
        Inherit.C c = f;
        check(c.c(), "C.c");
      }

      /*
       * Test Class F2
       */
      if (true) {
        Inherit.F2 f2 = new Inherit.F2();
        check(f2.a(), "F2.a");
        check(f2.b(), "F2.b");
        check(f2.c(), "F2.c");
        check(f2.f(), "F2.f");
        Inherit.A a = f2;
        check(a.a(), "F2.a");
        Inherit.B b = f2;
        check(b.b(), "F2.b");
        Inherit.C c = f2;
        check(c.c(), "F2.c");
      }

      /*
       * Test Class G
       */
      if (true) {
        Inherit.G g = new Inherit.G();
        check(g.a(), "D.a");
        check(g.d(), "D.d");
        check(g.g(), "G.g");
        Inherit.A a = g;
        check(a.a(), "D.a");
        Inherit.D d = g;
        check(d.a(), "D.a");
        check(d.d(), "D.d");
      }

      /*
       * Test Class G
       */
      if (true) {
        Inherit.G2 g2 = new Inherit.G2();
        check(g2.a(), "G2.a");
        check(g2.d(), "G2.d");
        check(g2.g(), "G2.g");
        Inherit.A a = g2;
        check(a.a(), "G2.a");
        Inherit.D d = g2;
        check(d.a(), "G2.a");
        check(d.d(), "G2.d");
      }

      /*
       * Test Class I
       */
      if (true) {
        Inherit.I i = new Inherit.I();
        check(i.a(), "I.a");
        check(i.h(), "I.h");
        Inherit.A a = i;
        check(a.a(), "I.a");
        Inherit.H h = i;
        check(h.a(), "I.a");
        check(h.h(), "I.h");
      }

      /*
       * Output final test results
       */

      System.out.println("TEST_RESULT " + s_results[s_result]);

      Runtime.getRuntime().exit(0); /* workaround for Linux JVM 1.3.1 bug */
    /*
     * Catch any unexpected exceptions and return a test failure
     */
    } catch (Throwable ex) {
      System.out.println("TEST_RESULT FAIL");
      System.out.println(ex.toString());
      System.exit(1);
    }
  }
}
