/*
 * File:          Ordering_IntOrderTest_Impl.c
 * Symbol:        Ordering.IntOrderTest-v0.1
 * Symbol Type:   class
 * Babel Version: 0.8.8
 * Description:   Server-side implementation for Ordering.IntOrderTest
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.8.8
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "Ordering.IntOrderTest" (version 0.1)
 * 
 * This class provides methods to verify that the array ordering
 * capabilities work for arrays of int.
 */

#include "Ordering_IntOrderTest_Impl.h"

/* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest._includes) */
#include <stdlib.h>

static int32_t
iFunc(const int32_t *ind, const int32_t dim)
{
  int32_t result = 0;
  int32_t i;
  for(i = 0; i < dim ; ++i) {
    result += (i+1)*ind[i];
  }
  return result;
}

static int
incIndex(int32_t ind[], const struct SIDL_int__array* A, const int32_t dimen)
{
  int32_t i = 0;
  while (i < dimen) {
    if (++(ind[i]) > SIDLUpper(A, i)) {
      ind[i] = SIDLLower(A, i);
      ++i;
    }
    else {
      return TRUE;
    }
  }
  /* we're all done */
  return FALSE;
}

static SIDL_bool
isIMatrix(const struct SIDL_int__array* A)
{
  if (A) {
    const int32_t dimen = SIDL_int__array_dimen(A);
    int32_t i;
    int32_t *cindex = malloc(sizeof(int32_t)*dimen);
    for(i = 0; i < dimen; ++i){
      cindex[i] = SIDLLower(A, i);
      if (SIDLLower(A,i) > SIDLUpper(A,i)) {
        free(cindex);
        return TRUE;
      }
    }
    do {
      if (iFunc(cindex, dimen) != SIDL_int__array_get(A, cindex)) {
        free(cindex);
        return FALSE;
      }
    } while (incIndex(cindex, A, dimen));
    free(cindex);
    return TRUE;
  }
  return FALSE;
}

static void
fillIMatrix(struct SIDL_int__array* A)
{
  if (A) {
    const int32_t dimen = SIDL_int__array_dimen(A);
    int32_t i;
    int32_t *cindex = malloc(sizeof(int32_t)*dimen);
    for(i = 0; i < dimen; ++i){
      cindex[i] = SIDLLower(A, i);
      if (SIDLLower(A,i) > SIDLUpper(A,i)){
        free(cindex);
        return;
      }
    }
    do {
      SIDL_int__array_set(A, cindex, iFunc(cindex, dimen));
    } while (incIndex(cindex, A, dimen));
    free(cindex);
  }
}
/* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest._includes) */

/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest__ctor"

void
impl_Ordering_IntOrderTest__ctor(
  Ordering_IntOrderTest self)
{
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest._ctor) */
  /* Insert the implementation of the constructor method here... */
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest._ctor) */
}

/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest__dtor"

void
impl_Ordering_IntOrderTest__dtor(
  Ordering_IntOrderTest self)
{
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest._dtor) */
  /* Insert the implementation of the destructor method here... */
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest._dtor) */
}

/*
 * Create a column-major matrix satisfying condition I.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_makeColumnIMatrix"

struct SIDL_int__array*
impl_Ordering_IntOrderTest_makeColumnIMatrix(
  int32_t size, SIDL_bool useCreateCol)
{
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.makeColumnIMatrix) */
  struct SIDL_int__array *result;
  if (useCreateCol) {
    result = SIDL_int__array_create2dCol(size, size);
  }
  else {
    result = SIDL_int__array_create2dRow(size, size);
  }
  fillIMatrix(result);
  return result;
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.makeColumnIMatrix) */
}

/*
 * Create a row-major matrix satisfying condition I.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_makeRowIMatrix"

struct SIDL_int__array*
impl_Ordering_IntOrderTest_makeRowIMatrix(
  int32_t size, SIDL_bool useCreateRow)
{
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.makeRowIMatrix) */
  struct SIDL_int__array *result;
  if (useCreateRow) {
    result = SIDL_int__array_create2dRow(size, size);
  }
  else {
    result = SIDL_int__array_create2dCol(size, size);
  }
  fillIMatrix(result);
  return result;
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.makeRowIMatrix) */
}

/*
 * Create a 4-D matrix satisfying condition I.  Each dimension has
 * size elements numbers 0 through size-1.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_makeIMatrix"

struct SIDL_int__array*
impl_Ordering_IntOrderTest_makeIMatrix(
  int32_t size, SIDL_bool useCreateColumn)
{
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.makeIMatrix) */
  struct SIDL_int__array *result;
  static const int lower[4] = { 0, 0, 0, 0};
  int upper[4];
  upper[0] = upper[1] = upper[2] = upper[3] = size - 1;
  if (useCreateColumn) {
    result = SIDL_int__array_createCol(4, lower, upper);
  }
  else {
    result = SIDL_int__array_createRow(4, lower, upper);
  }
  fillIMatrix(result);
  return result;
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.makeIMatrix) */
}

/*
 * Create a column-major matrix satisfying condition I.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_createColumnIMatrix"

void
impl_Ordering_IntOrderTest_createColumnIMatrix(
  int32_t size, SIDL_bool useCreateCol, struct SIDL_int__array** result)
{
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.createColumnIMatrix) */
  if (useCreateCol) {
    *result = Ordering_IntOrderTest_makeColumnIMatrix(size, TRUE);
  }
  else{
    *result = Ordering_IntOrderTest_makeRowIMatrix(size, TRUE);
  }
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.createColumnIMatrix) */
}

/*
 * Create a row-major matrix satisfying condition I.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_createRowIMatrix"

void
impl_Ordering_IntOrderTest_createRowIMatrix(
  int32_t size, SIDL_bool useCreateRow, struct SIDL_int__array** result)
{
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.createRowIMatrix) */
  if (useCreateRow) {
    *result = Ordering_IntOrderTest_makeRowIMatrix(size, TRUE);
  }
  else{
    *result = Ordering_IntOrderTest_makeColumnIMatrix(size, TRUE);
  }
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.createRowIMatrix) */
}

/*
 * Make sure an array is column-major.  No changes to the dimension or
 * values in a are made.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_ensureColumn"

void
impl_Ordering_IntOrderTest_ensureColumn(
  struct SIDL_int__array** a)
{
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.ensureColumn) */
  /* no action required */
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.ensureColumn) */
}

/*
 * Make sure an array is row-major.  No changes to the dimension or
 * values in a are made.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_ensureRow"

void
impl_Ordering_IntOrderTest_ensureRow(
  struct SIDL_int__array** a)
{
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.ensureRow) */
  /* no action required */
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.ensureRow) */
}

/*
 *  Return <code>true</code> iff the implementation sees
 *  an incoming array satisfying condition I.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_isIMatrixOne"

SIDL_bool
impl_Ordering_IntOrderTest_isIMatrixOne(
  struct SIDL_int__array* A)
{
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isIMatrixOne) */
  return isIMatrix(A);
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isIMatrixOne) */
}

/*
 * Return <code>true</code> iff the implementation sees
 * an incoming column-major array satisfying condition I.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_isColumnIMatrixOne"

SIDL_bool
impl_Ordering_IntOrderTest_isColumnIMatrixOne(
  struct SIDL_int__array* A)
{
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isColumnIMatrixOne) */
  return SIDL_int__array_isColumnOrder(A) && isIMatrix(A);
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isColumnIMatrixOne) */
}

/*
 * Return <code>true</code> iff the implementation sees
 * an incoming row-major array satisfying condition I.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_isRowIMatrixOne"

SIDL_bool
impl_Ordering_IntOrderTest_isRowIMatrixOne(
  struct SIDL_int__array* A)
{
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isRowIMatrixOne) */
  return SIDL_int__array_isRowOrder(A) && isIMatrix(A);
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isRowIMatrixOne) */
}

/*
 *  Return <code>true</code> iff the implementation sees
 *  an incoming array satisfying condition I.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_isIMatrixTwo"

SIDL_bool
impl_Ordering_IntOrderTest_isIMatrixTwo(
  struct SIDL_int__array* A)
{
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isIMatrixTwo) */
  return isIMatrix(A);
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isIMatrixTwo) */
}

/*
 * Return <code>true</code> iff the implementation sees
 * an incoming column-major array satisfying condition I.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_isColumnIMatrixTwo"

SIDL_bool
impl_Ordering_IntOrderTest_isColumnIMatrixTwo(
  struct SIDL_int__array* A)
{
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isColumnIMatrixTwo) */
  return SIDL_int__array_isColumnOrder(A) && isIMatrix(A);
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isColumnIMatrixTwo) */
}

/*
 * Return <code>true</code> iff the implementation sees
 * an incoming row-major array satisfying condition I.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_isRowIMatrixTwo"

SIDL_bool
impl_Ordering_IntOrderTest_isRowIMatrixTwo(
  struct SIDL_int__array* A)
{
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isRowIMatrixTwo) */
  return SIDL_int__array_isRowOrder(A) && isIMatrix(A);
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isRowIMatrixTwo) */
}

/*
 *  Return <code>true</code> iff the implementation sees
 *  an incoming array satisfying condition I.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_isIMatrixFour"

SIDL_bool
impl_Ordering_IntOrderTest_isIMatrixFour(
  struct SIDL_int__array* A)
{
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isIMatrixFour) */
  return isIMatrix(A);
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isIMatrixFour) */
}

/*
 * Return <code>true</code> iff the implementation sees
 * an incoming column-major array satisfying condition I.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_isColumnIMatrixFour"

SIDL_bool
impl_Ordering_IntOrderTest_isColumnIMatrixFour(
  struct SIDL_int__array* A)
{
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isColumnIMatrixFour) */
  return SIDL_int__array_isColumnOrder(A) && isIMatrix(A);
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isColumnIMatrixFour) */
}

/*
 * Return <code>true</code> iff the implementation sees
 * an incoming row-major array satisfying condition I.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_isRowIMatrixFour"

SIDL_bool
impl_Ordering_IntOrderTest_isRowIMatrixFour(
  struct SIDL_int__array* A)
{
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isRowIMatrixFour) */
  return SIDL_int__array_isRowOrder(A) && isIMatrix(A);
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isRowIMatrixFour) */
}

/*
 * Return <code>true</code> iff the implementation of slice
 * and smart copy is correct.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_isSliceWorking"

SIDL_bool
impl_Ordering_IntOrderTest_isSliceWorking(
  SIDL_bool useCreateCol)
{
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isSliceWorking) */
  SIDL_bool result = TRUE;
  const int32_t maxDim = 16;
  const int32_t halfDim = maxDim >> 1;
  struct SIDL_int__array *A=NULL, *B=NULL;
  int32_t ind[2];
  int32_t stride[2] = {2, 2};
  int32_t numElem[2];
  int32_t newIndex[2];
  numElem[0] = numElem[1] = halfDim;
  if (useCreateCol) {
    A = Ordering_IntOrderTest_makeColumnIMatrix(maxDim,FALSE);
  }
  else {
    A = Ordering_IntOrderTest_makeRowIMatrix(maxDim,FALSE);
  }
  B = SIDL_int__array_slice(A, 2, numElem, NULL, stride, NULL);
  if (!(B && SIDL_int__array_dimen(B) == 2)) {
    result = FALSE;
    goto cleanup;
  }
  for(ind[1] = newIndex[1] = 0; newIndex[1] < halfDim; 
      ++newIndex[1], ind[1] += 2) {
    for(ind[0] = newIndex[0] = 0; newIndex[0] < halfDim;
        ++newIndex[0], ind[0] += 2) {
      if ((SIDLArrayElem2(B, newIndex[0], newIndex[1]) != iFunc(ind,2)) ||
          (SIDLArrayAddr2(B, newIndex[0], newIndex[1]) !=
           SIDLArrayAddr2(A, ind[0], ind[1]))) {
        result = FALSE;
        goto cleanup;
      }
    }
  }

  SIDL_int__array_deleteRef(B);
  ind[0] = ind[1] = 1;
  newIndex[0] = newIndex[1] = 0;
  B = SIDL_int__array_slice(A, 2, numElem, ind, stride, newIndex);
  if (!(B && SIDL_int__array_dimen(B) == 2)) {
    result = FALSE;
    goto cleanup;
  }
  for(newIndex[1] = 0; newIndex[1] < halfDim; 
      ++newIndex[1], ind[1] += 2) {
    for(ind[0] = 1, newIndex[0] = 0; newIndex[0] < halfDim;
        ++newIndex[0], ind[0] += 2) {
      if ((SIDLArrayElem2(B, newIndex[0], newIndex[1]) != iFunc(ind,2)) ||
          (SIDLArrayAddr2(B, newIndex[0], newIndex[1]) !=
           SIDLArrayAddr2(A, ind[0], ind[1]))) {
        result = FALSE;
        goto cleanup;
      }
    }
  }

  SIDL_int__array_deleteRef(B);
  ind[0] = ind[1] = 1;
  newIndex[1] = newIndex[0] = 1;
  B = SIDL_int__array_slice(A, 2, numElem, ind, stride, newIndex);
  if (!(B && SIDL_int__array_dimen(B) == 2)) {
    result = FALSE;
    goto cleanup;
  }
  for(newIndex[1] = 1; newIndex[1] <= halfDim; 
      ++newIndex[1], ind[1] += 2) {
    for(ind[0] = 1, newIndex[0] = 1; newIndex[0] <= halfDim;
        ++newIndex[0], ind[0] += 2) {
      if ((SIDLArrayElem2(B, newIndex[0], newIndex[1]) != iFunc(ind,2)) ||
          (SIDLArrayAddr2(B, newIndex[0], newIndex[1]) != 
           SIDLArrayAddr2(A, ind[0], ind[1]))){
        result = FALSE;
        goto cleanup;
      }
    }
  }

  SIDL_int__array_deleteRef(B);
  B = NULL;
  numElem[0] = 0;
  numElem[1] = maxDim;
  B = SIDL_int__array_slice(A, 1, numElem, NULL, NULL, NULL);
  if (!(B && SIDL_int__array_dimen(B) == 1)) {
    result = FALSE;
    goto cleanup;
  }
  ind[0] = newIndex[0] = 0;
  for(ind[1] = newIndex[1] = 0; newIndex[1] < maxDim; 
      ++newIndex[1], ++ind[1]) {
    if (SIDLArrayAddr1(B, newIndex[1]) != 
        SIDLArrayAddr2(A, ind[0], ind[1])) {
      result = FALSE;
      goto cleanup;
    }
  }
  
  SIDL_int__array_deleteRef(B);
  B = NULL;
  numElem[0] = maxDim;
  numElem[1] = 0;
  ind[0] = 0;
  ind[1] = 8;
  newIndex[0] = newIndex[1] = 0;
  B = SIDL_int__array_slice(A, 1, numElem, ind, NULL, newIndex);
  if (!(B && (SIDL_int__array_dimen(B) == 1))) {
    result = FALSE;
    goto cleanup;
  }
  for(ind[0] = newIndex[0] = 0; newIndex[0] < maxDim; 
      ++newIndex[0], ++ind[0]) {
    if (SIDLArrayAddr1(B, newIndex[0]) != 
        SIDLArrayAddr2(A, ind[0], ind[1])) {
      result = FALSE;
      goto cleanup;
    }
  }
  
  SIDL_int__array_deleteRef(B);
  B = NULL;
  numElem[0] = maxDim;
  numElem[1] = 0;
  ind[0] = 0;
  ind[1] = 0;
  B = SIDL_int__array_slice(A, 1, numElem, ind, NULL, NULL);
  if (!(B && (SIDL_int__array_dimen(B) == 1))) {
    result = FALSE;
    goto cleanup;
  }
  if (!(Ordering_IntOrderTest_isIMatrixOne(B) &&
        Ordering_IntOrderTest_isColumnIMatrixOne(B) &&
        Ordering_IntOrderTest_isRowIMatrixOne(B))) {
    result = FALSE;
    goto cleanup;
  }
        
  
 cleanup:
  if (B) SIDL_int__array_deleteRef(B);
  if (A) SIDL_int__array_deleteRef(A);
  return result;
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isSliceWorking) */
}
