#
# File:          IntOrderTest_Impl.py
# Symbol:        Ordering.IntOrderTest-v0.1
# Symbol Type:   class
# Babel Version: 0.8.8
# Description:   Implementation of SIDL class Ordering.IntOrderTest in Python.
# 
# WARNING: Automatically generated; changes will be lost
# 
# babel-version = 0.8.8
#


"""This class provides methods to verify that the array ordering
capabilities work for arrays of int.
"""

# DO-NOT-DELETE splicer.begin(_initial)
from Numeric import *;
# DO-NOT-DELETE splicer.end(_initial)

import Ordering.IntOrderTest
import SIDL.BaseInterface
import SIDL.BaseClass
import SIDL.ClassInfo

# DO-NOT-DELETE splicer.begin(_before_static)
# Put your code here...
# DO-NOT-DELETE splicer.end(_before_static)

def makeColumnIMatrix(size, useCreateCol):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int size
  # bool useCreateCol
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<int,2,column-major> _return
  #

  """\
Create a column-major matrix satisfying condition I.
"""
  # DO-NOT-DELETE splicer.begin(makeColumnIMatrix)
  result = zeros((size, size))
  for i in range(size):
    for j in range(size):
      result[i,j] = iFunc((i,j))
  return result
  # DO-NOT-DELETE splicer.end(makeColumnIMatrix)

def makeRowIMatrix(size, useCreateRow):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int size
  # bool useCreateRow
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<int,2,row-major> _return
  #

  """\
Create a row-major matrix satisfying condition I.
"""
  # DO-NOT-DELETE splicer.begin(makeRowIMatrix)
  result = zeros((size, size))
  for i in range(size):
    for j in range(size):
      result[i,j] = iFunc((i,j))
  return result
  # DO-NOT-DELETE splicer.end(makeRowIMatrix)

def makeIMatrix(size, useCreateColumn):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int size
  # bool useCreateColumn
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<int,4> _return
  #

  """\
Create a 4-D matrix satisfying condition I.  Each dimension has
size elements numbers 0 through size-1.
"""
  # DO-NOT-DELETE splicer.begin(makeIMatrix)
  result = zeros((size, size, size, size))
  for i in range(size):
    for j in range(size):
      for k in range(size):
        for l in range(size):
          result[i,j,k,l] = iFunc((i,j,k,l))
  return result
  # DO-NOT-DELETE splicer.end(makeIMatrix)

def createColumnIMatrix(size, useCreateCol):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int size
  # bool useCreateCol
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<int,2,column-major> result
  #

  """\
Create a column-major matrix satisfying condition I.
"""
  # DO-NOT-DELETE splicer.begin(createColumnIMatrix)
  if (useCreateCol):
    return makeColumnIMatrix(size, 1)
  else:
    return makeRowIMatrix(size, 1)
  # DO-NOT-DELETE splicer.end(createColumnIMatrix)

def createRowIMatrix(size, useCreateRow):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int size
  # bool useCreateRow
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<int,2,row-major> result
  #

  """\
Create a row-major matrix satisfying condition I.
"""
  # DO-NOT-DELETE splicer.begin(createRowIMatrix)
  if (useCreateRow):
    return makeRowIMatrix(size, 1)
  else:
    return makeColumnIMatrix(size, 1)
  # DO-NOT-DELETE splicer.end(createRowIMatrix)

def ensureColumn(a):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<int,2,column-major> a
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<int,2,column-major> a
  #

  """\
Make sure an array is column-major.  No changes to the dimension or
values in a are made.
"""
  # DO-NOT-DELETE splicer.begin(ensureColumn)
  return a
  # DO-NOT-DELETE splicer.end(ensureColumn)

def ensureRow(a):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<int,2,row-major> a
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<int,2,row-major> a
  #

  """\
Make sure an array is row-major.  No changes to the dimension or
values in a are made.
"""
  # DO-NOT-DELETE splicer.begin(ensureRow)
  return a
  # DO-NOT-DELETE splicer.end(ensureRow)

def isIMatrixOne(A):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<int> A
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # bool _return
  #

  """\
 Return <code>true</code> iff the implementation sees
 an incoming array satisfying condition I.
"""
  # DO-NOT-DELETE splicer.begin(isIMatrixOne)
  return isIMatrix(A)                 
  # DO-NOT-DELETE splicer.end(isIMatrixOne)

def isColumnIMatrixOne(A):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<int,column-major> A
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # bool _return
  #

  """\
Return <code>true</code> iff the implementation sees
an incoming column-major array satisfying condition I.
"""
  # DO-NOT-DELETE splicer.begin(isColumnIMatrixOne)
  return isIMatrix(A)                 
  # DO-NOT-DELETE splicer.end(isColumnIMatrixOne)

def isRowIMatrixOne(A):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<int,row-major> A
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # bool _return
  #

  """\
Return <code>true</code> iff the implementation sees
an incoming row-major array satisfying condition I.
"""
  # DO-NOT-DELETE splicer.begin(isRowIMatrixOne)
  return isIMatrix(A)                 
  # DO-NOT-DELETE splicer.end(isRowIMatrixOne)

def isIMatrixTwo(A):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<int,2> A
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # bool _return
  #

  """\
 Return <code>true</code> iff the implementation sees
 an incoming array satisfying condition I.
"""
  # DO-NOT-DELETE splicer.begin(isIMatrixTwo)
  return isIMatrix(A)                 
  # DO-NOT-DELETE splicer.end(isIMatrixTwo)

def isColumnIMatrixTwo(A):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<int,2,column-major> A
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # bool _return
  #

  """\
Return <code>true</code> iff the implementation sees
an incoming column-major array satisfying condition I.
"""
  # DO-NOT-DELETE splicer.begin(isColumnIMatrixTwo)
  return isIMatrix(A)                 
  # DO-NOT-DELETE splicer.end(isColumnIMatrixTwo)

def isRowIMatrixTwo(A):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<int,2,row-major> A
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # bool _return
  #

  """\
Return <code>true</code> iff the implementation sees
an incoming row-major array satisfying condition I.
"""
  # DO-NOT-DELETE splicer.begin(isRowIMatrixTwo)
  return isIMatrix(A)                 
  # DO-NOT-DELETE splicer.end(isRowIMatrixTwo)

def isIMatrixFour(A):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<int,4> A
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # bool _return
  #

  """\
 Return <code>true</code> iff the implementation sees
 an incoming array satisfying condition I.
"""
  # DO-NOT-DELETE splicer.begin(isIMatrixFour)
  return isIMatrix(A)                 
  # DO-NOT-DELETE splicer.end(isIMatrixFour)

def isColumnIMatrixFour(A):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<int,4,column-major> A
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # bool _return
  #

  """\
Return <code>true</code> iff the implementation sees
an incoming column-major array satisfying condition I.
"""
  # DO-NOT-DELETE splicer.begin(isColumnIMatrixFour)
  return isIMatrix(A)                 
  # DO-NOT-DELETE splicer.end(isColumnIMatrixFour)

def isRowIMatrixFour(A):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<int,4,row-major> A
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # bool _return
  #

  """\
Return <code>true</code> iff the implementation sees
an incoming row-major array satisfying condition I.
"""
  # DO-NOT-DELETE splicer.begin(isRowIMatrixFour)
  return isIMatrix(A)                 
  # DO-NOT-DELETE splicer.end(isRowIMatrixFour)

def isSliceWorking(useCreateCol):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # bool useCreateCol
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # bool _return
  #

  """\
Return <code>true</code> iff the implementation of slice
and smart copy is correct.
"""
  # DO-NOT-DELETE splicer.begin(isSliceWorking)
  return 1
  # DO-NOT-DELETE splicer.end(isSliceWorking)

# DO-NOT-DELETE splicer.begin(_before_type)
# Put your code here...
# DO-NOT-DELETE splicer.end(_before_type)

class IntOrderTest:
  """\
This class provides methods to verify that the array ordering
capabilities work for arrays of int.
"""

  # All calls to SIDL methods should use __IORself

  def __init__(self, IORself):
    self.__IORself = IORself
    # DO-NOT-DELETE splicer.begin(__init__)
    # Put your code here...
    # DO-NOT-DELETE splicer.end(__init__)

# DO-NOT-DELETE splicer.begin(_final)
# Put your code here...
# DO-NOT-DELETE splicer.end(_final)

pass
#
# ================= BEGIN UNREFERENCED METHOD(S) ================
# The following code segment(s) belong to unreferenced method(s).
# This can result from a method rename/removal in the SIDL file.
# Move or remove the code in order to compile cleanly.
#

# DO-NOT-DELETE splicer.begin(before_static)
def iFunc(ind):
  result = 0
  for i in range(len(ind)):
    result = result + (i+1) * ind[i]
  return result

def isIMatrix(A):
  if (len(A.shape) == 1):
    for i in range(A.shape[0]):
      if (A[i] != iFunc((i,))):
        return 0
  else:
    if (len(A.shape) == 2):
      for i in range(A.shape[0]):
        for j in range(A.shape[1]):
          if (A[i,j] != iFunc((i, j))):
              return 0
    else:
      if (len(A.shape) == 4):
        for i in range(A.shape[0]):
          for j in range(A.shape[1]):
            for k in range(A.shape[2]):
              for l in range(A.shape[3]):
                if (A[i,j,k,l] != iFunc((i, j, k, l))):
                    return 0
      else:
        return 0
  return 1
# DO-NOT-DELETE splicer.end(before_static)
# ================== END UNREFERENCED METHOD(S) =================
