//
// File:        OrderingTestDriver.java
// Package:     
// Copyright:   (c) 2002 The Regents of the University of California
// Release:     $Name: release-0-8-8 $
// Revision:    @(#) $Revision: 1.3 $
// Date:        $Date: 2002/04/23 15:55:37 $
// Description: Regression test for array ordering
// 

public class OrderingTestDriver {
  private final static int FAIL        = 0;
  private final static int XFAIL       = 1;
  private final static int PASS        = 2;
  private final static int XPASS       = 3;
  private final static int UNSUPPORTED = 4;

  private final static String[] s_results = {
    "FAIL",
    "XFAIL",
    "PASS",
    "XPASS",
    "UNSUPPORTED"
  };

  private static int s_part = 0;
  private static int s_result = PASS;

  /**
   * Check the results of the test case.
   */
  private static void check(int expected, boolean pass, String test) {
    System.out.println("PART " + String.valueOf(++s_part));
    System.out.println("COMMENT " + test);
    System.out.print("RESULT " + String.valueOf(s_part) + " ");

    if (expected == UNSUPPORTED) {
      System.out.println(s_results[expected]);
      if (s_result == PASS) {
        s_result = XFAIL;
      }
    } else if (expected == PASS) {
      System.out.println(s_results[pass ? PASS : FAIL]);
      if (!pass) {
        s_result = FAIL;
      }
    } else if (expected == XFAIL) {
      System.out.println(s_results[pass ? XPASS : XFAIL]);
      if (pass) {
        s_result = FAIL;
      } else if (s_result > XFAIL) {
        s_result = XFAIL;
      }
    }
  }

  public static void main(String args[]) {
    try {
      System.out.println("NPARTS -1");
      s_part = 0;
      s_result = PASS;
      
      SIDL.Integer.Array2 array = 
        Ordering.IntOrderTest.makeColumnIMatrix(10,true);
      check(PASS,
            (array != null),
            "(!array != null)");
      check(PASS,
            Ordering.IntOrderTest.isIMatrixTwo(array),
            "Ordering.IntOrderTest.isIMatrixTwo(array)");
      System.out.println("TEST_RESULT " + s_results[s_result]);
      Runtime.getRuntime().exit(0); /* workaround for Linux JVM 1.3.1 bug */
    }
    catch (Throwable ex) {
      System.out.println("TEST_RESULT FAIL");
      System.out.println(ex.toString());
      System.exit(1);
    }
  }
}
