!
! File:       overloadtest.F90
! Copyright:  (c) 2002 The Regents of the University of California
! Release:    $Name: release-0-8-8 $
! Revision:   @(#) $Revision: 1.5 $
! Date:       $Date: 2003/04/09 18:39:36 $
! Description:Simple F90 overload test client
!
!

#include "Overload_AClass_fAbbrev.h"
#include "Overload_AnException_fAbbrev.h"
#include "Overload_BClass_fAbbrev.h"
#include "Overload_ParentTest_fAbbrev.h"
#include "Overload_Test_fAbbrev.h"

subroutine starttest(number)
  implicit none
  integer (selected_int_kind(9)) :: number
  write (6, 100) number
100 format ('PART ', I4)
end subroutine starttest

subroutine reporttest(test, number, pass, fail)
  implicit none
  integer (selected_int_kind(9)) :: number, pass, fail
  logical                        :: test
  if (test) then
     write (6, 100) number, 'PASS'
     pass = pass + 1
  else
     write (6, 100) number, 'FAIL'
     fail = fail + 1
  endif
100 format ('RESULT', 1x, i2, 1x, A4)
  number = number + 1
end subroutine reporttest

subroutine testnone(t, test, pass, fail)
  use Overload_Test
  implicit none
  integer (selected_int_kind(9))  :: test, pass, fail
  type(Overload_Test_t) :: t
  integer (selected_int_kind(9))  :: retval

  retval = 0

  call starttest(test)
  call getValue(t, retval)
  call reporttest(retval .eq. 1, test, pass, fail)
end subroutine testnone

subroutine testone(t, test, pass, fail)
  use Overload_Test
  use Overload_AnException
  use Overload_AClass
  use Overload_BClass
  implicit none
  character*80 s1, sretval
  integer (selected_int_kind(9))       :: test, pass, fail
  type(Overload_Test_t)                :: t
  type(Overload_AnException_t)         :: ae
  type(Overload_AClass_t)              :: ac
  type(Overload_BClass_t)              :: bc
  integer (selected_int_kind(9))       :: i1, iretval
  real (selected_real_kind(15,307))    :: d1, dretval
  real (selected_real_kind(6,37))      :: f1, fretval
  logical                              :: b1, bretval
  complex (selected_real_kind(6,37))   :: fc, fcretval
  complex (selected_real_kind(15,307)) :: dc, dcretval

  b1 = .true.
  d1 = 1.0d0
  f1 = 1.0
  i1 = 1
  fc = (1.1, 1.1)
  dc = (2.2d0, 2.2d0)
  s1 = 'AnException'

  call starttest(test)
  call getValueBool(t, b1, bretval)
  call reporttest(bretval .eqv. b1, test, pass, fail)
  call starttest(test)
  call getValueDouble(t, d1, dretval)
  call reporttest(dretval .eq. d1, test, pass, fail)
  call starttest(test)
  call getValueDcomplex(t, dc, dcretval)
  call reporttest(dcretval .eq. dc, test, pass, fail)
  call starttest(test)
  call getValueFloat(t, f1, fretval)
  call reporttest(fretval .eq. f1, test, pass, fail)
  call starttest(test)
  call getValueFcomplex(t, fc, fcretval)
  call reporttest(fcretval .eq. fc, test, pass, fail)
  call starttest(test)
  call getValueInt(t, i1, iretval)
  call reporttest(iretval .eq. i1, test, pass, fail)
  call starttest(test)
  call getValueString(t, s1, sretval)
  call reporttest(sretval .eq. s1, test, pass, fail)

  call new(ae)
  call starttest(test)
  call getValueException(t, ae, sretval)
  call reporttest(sretval .eq. s1, test, pass, fail)
  call deleteRef(ae)
  call new(ac)
  call starttest(test)
  call getValueAClass(t, ac, iretval)
  call reporttest(iretval .eq. 2, test, pass, fail)
  call deleteRef(ac)
  call new(bc)
  call starttest(test)
  call getValueBClass(t, bc, iretval)
  call reporttest(iretval .eq. 2, test, pass, fail)
  call deleteRef(bc)
end subroutine testone

subroutine testtwo(t, test, pass, fail)
  use Overload_Test
  implicit none
  integer (selected_int_kind(9))    :: test, pass, fail
  type(Overload_Test_t)             :: t
  integer (selected_int_kind(9))    :: i1, iretval
  real (selected_real_kind(15,307)) :: d1, dretval, did
  real (selected_real_kind(6,37))   :: f1

  d1 = 1.0d0
  i1 = 1
  did =2.0d0

  call starttest(test)
  call getValueDoubleInt(t, d1, i1, dretval)
  call reporttest(dretval .eq. did, test, pass, fail)
  call starttest(test)
  call getValueIntDouble(t, i1, d1, dretval)
  call reporttest(dretval .eq. did, test, pass, fail)
end subroutine testtwo

subroutine testthree(t, test, pass, fail)
  use Overload_Test
  implicit none
  type(Overload_Test_t)             :: t
  integer (selected_int_kind(9))    :: i1
  integer (selected_int_kind(9))    :: test, pass, fail
  real (selected_real_kind(15,307)) :: d1, difd, dretval
  real (selected_real_kind(6,37))   :: f1

  d1 = 1.0d0
  f1 = 1.0
  i1 = 1
  difd = 3.0d0

  call starttest(test)
  call getValueDoubleIntFloat(t, d1, i1, f1, dretval)
  call reporttest(dretval .eq. difd, test, pass, fail)
  call starttest(test)
  call getValueIntDoubleFloat(t, i1, d1, f1, dretval)
  call reporttest(dretval .eq. difd, test, pass, fail)
  call starttest(test)
  call getValueDoubleFloatInt(t, d1, f1, i1, dretval)
  call reporttest(dretval .eq.  difd, test, pass, fail)
  call starttest(test)
  call getValueIntFloatDouble(t, i1, f1, d1, dretval)
  call reporttest(dretval .eq. difd, test, pass, fail)
  call starttest(test)
  call getValueFloatDoubleInt(t, f1, d1, i1, dretval)
  call reporttest(dretval .eq. difd, test, pass, fail)
  call starttest(test)
  call getValueFloatIntDouble(t, f1, i1, d1, dretval)
  call reporttest(dretval .eq. difd, test, pass, fail)
end subroutine testthree


program overloadtest
  use Overload_Test
  implicit none
  integer (selected_int_kind(9))  :: test, pass, fail, total
  type(Overload_Test_t) :: t

  call new(t)

  test = 1
  pass = 0
  fail = 0
  total = 19

  write(6,130) total
  write(6,110)
  write(6,120) 'No Argument test             '
  call testnone(t, test, pass, fail)
  write(6,110)
  write(6,120) 'Single Argument tests        '
  call testone(t, test, pass, fail)
  write(6,110)
  write(6,120) 'Double Argument tests        '
  call testtwo(t, test, pass, fail)
  write(6,110)
  write(6,120) 'Triple Argument tests        '
  call testthree(t, test, pass, fail)

  call deleteRef(t)

  write(6, 110) 
  if ((fail .eq. 0) .and. (pass .eq. total)) then
     write(6, 100) 'PASS'
  else
     write(6, 100) 'FAIL'
  endif
  write(6,110)
100 format ('TEST_RESULT', 1x, a4)
110 format (' ')
120 format ('COMMENT:', 1x, a30)
130 format ('NPARTS', 1x, i4)
end program overloadtest
