// 
// File:        OverloadTestDriver.java
// Copyright:   (c) 2001 The Regents of the University of California
// Release:     $Name: release-0-8-8 $
// Revision:    @(#) $Revision: 1.4 $
// Date:        $Date: 2002/07/26 18:29:22 $
// Description: overload regression test case for Java calling other languages
// 

/**
 * The following class runs the exception regression test cases for Java.
 */
public class OverloadTestDriver {
  private final static int FAIL        = 0;
  private final static int XFAIL       = 1;
  private final static int PASS        = 2;
  private final static int XPASS       = 3;
  private final static int UNSUPPORTED = 4;

  private final static String[] s_results = {
    "FAIL",
    "XFAIL",
    "PASS",
    "XPASS",
    "UNSUPPORTED"
  };

  private static int s_part = 0;
  private static int s_result = PASS;

  /**
   * Check the results of the test case.
   */
  private static void check(int expected, boolean pass, String test) {
    System.out.println("PART " + String.valueOf(++s_part));
    System.out.println("COMMENT " + test);
    System.out.print("RESULT " + String.valueOf(s_part) + " ");

    if (expected == UNSUPPORTED) {
      System.out.println(s_results[expected]);
      if (s_result == PASS) {
        s_result = XFAIL;
      }
    } else if (expected == PASS) {
      System.out.println(s_results[pass ? PASS : FAIL]);
      if (!pass) {
        s_result = FAIL;
      }
    } else if (expected == XFAIL) {
      System.out.println(s_results[pass ? XPASS : XFAIL]);
      if (pass) {
        s_result = FAIL;
      } else if (s_result > XFAIL) {
        s_result = XFAIL;
      }
    }
  }

  /**
   * The main test driver takes no command-line arguments and runs the
   * regression tests.
   */
  public static void main(String args[]) {
    boolean b1   = true;
    int     i1   = 1;
    double  d1   = 1.0;
    float   f1   = 1.0F;
    double  did  = 2.0;
    double  difd = 3.0;
    String  s1   = "AnException";

    SIDL.DoubleComplex dcret = null;
    SIDL.DoubleComplex dc1   = new SIDL.DoubleComplex(1.1, 1.1);
    SIDL.FloatComplex  fcret = null;
    SIDL.FloatComplex  fc1   = new SIDL.FloatComplex(2.2F, 2.2F);

    try {
      /*
       * Begin the test
       */
      System.out.println("NPARTS 19");

      s_part   = 0;
      s_result = PASS;

      Overload.Test t = new Overload.Test();

      if (t != null) {
        /*
         * Zero argument test
         */
        check(PASS, t.getValue() == 1, "Zero arguments, expecting a 1");

        /*
         * One-argument tests
         */
        check(PASS, t.getValue(b1) == b1, "boolean argument");
        check(PASS, t.getValue(d1) == d1, "double argument");
        dcret = t.getValue(dc1);
        check(PASS, dcret.real() == dc1.real() && dcret.imag() == dc1.imag(), 
              "dcomplex argument");
        check(PASS, t.getValue(f1) == f1, "float argument");
        fcret = t.getValue(fc1);
        check(PASS, fcret.real() == fc1.real() && fcret.imag() == fc1.imag(), 
              "fcomplex argument");
        check(PASS, t.getValue(i1) == i1, "integer argument");
        check(PASS, t.getValue(s1).equals(s1), "string argument");

        Overload.AnException ae = new Overload.AnException();
        check(PASS, t.getValue(ae).equals(s1), "AnException argument");

        Overload.AClass ac = new Overload.AClass();
        check(PASS, t.getValue(ac) == 2, "AClass argument");

        Overload.BClass bc = new Overload.BClass();
        check(PASS, t.getValue(bc) == 2, "BClass argument");

        /*
         * Two-argument tests
         */
        check(PASS, t.getValue(d1, i1) == did, "Double, Int arguments");
        check(PASS, t.getValue(i1, d1) == did, "Int, Double arguments");

        /*
         * Three-argument tests
         */
        check(PASS, t.getValue(d1, i1, f1) == difd, 
              "Double, Int, Float args");
        check(PASS, t.getValue(i1, d1, f1) == difd, 
              "Int, Double, Float args");
        check(PASS, t.getValue(d1, f1, i1) == difd, 
              "Double, Float, Int args");
        check(PASS, t.getValue(i1, f1, d1) == difd, 
              "Int, Float, Double args");
        check(PASS, t.getValue(f1, d1, i1) == difd, 
              "Float, Double, Int args");
        check(PASS, t.getValue(f1, i1, d1) == difd, 
              "Float, Int, Double args");
      } else {
        System.out.println("TEST_RESULT FAIL");
        System.out.println("COMMENT:  ** No test object was created! **");
        System.exit(1);
      }

      /*
       * Output final test results
       */
      System.out.println("TEST_RESULT " + s_results[s_result]);

      Runtime.getRuntime().exit(0); /* workaround for Linux JVM 1.3.1 bug */

    } catch (Throwable ex) {
      /*
       * Catch any unexpected exceptions and return a test failure
       */
      System.out.println("TEST_RESULT FAIL");
      System.out.println(ex.toString());
      System.exit(1);
    }
  }
}
