/*
 * File:          sort_HeapSort_Impl.c
 * Symbol:        sort.HeapSort-v0.1
 * Symbol Type:   class
 * Babel Version: 0.8.8
 * Description:   Server-side implementation for sort.HeapSort
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.8.8
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "sort.HeapSort" (version 0.1)
 * 
 * Heap sort
 */

#include "sort_HeapSort_Impl.h"

/* DO-NOT-DELETE splicer.begin(sort.HeapSort._includes) */
#include "SIDL_String.h"
#include "sort_Container.h"

static void remakeHeap(sort_Container elem,
                       sort_Comparator comp,
                       sort_Counter cmp,
                       sort_Counter swp,
                       const int32_t last,
                       int32_t first)
{
  const int32_t half = (last >> 1) - 1;
  int32_t child;
  while (first <= half) {
    child = first + first + 1;
    if ((child+1) < last) {
      sort_Counter_inc(cmp);
      if (sort_Container_compare(elem, child, child+1, comp) < 0) ++child;
    }
    sort_Counter_inc(cmp);
    if (sort_Container_compare(elem,first, child,comp) >= 0) break;
    sort_Counter_inc(swp);
    sort_Container_swap(elem, first, child);
    first = child;
  }
}
/* DO-NOT-DELETE splicer.end(sort.HeapSort._includes) */

/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_HeapSort__ctor"

void
impl_sort_HeapSort__ctor(
  sort_HeapSort self)
{
  /* DO-NOT-DELETE splicer.begin(sort.HeapSort._ctor) */
  /* Insert the implementation of the constructor method here... */
  /* DO-NOT-DELETE splicer.end(sort.HeapSort._ctor) */
}

/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_HeapSort__dtor"

void
impl_sort_HeapSort__dtor(
  sort_HeapSort self)
{
  /* DO-NOT-DELETE splicer.begin(sort.HeapSort._dtor) */
  /* Insert the implementation of the destructor method here... */
  /* DO-NOT-DELETE splicer.end(sort.HeapSort._dtor) */
}

/*
 * Sort elements using Heap Sort.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_HeapSort_sort"

void
impl_sort_HeapSort_sort(
  sort_HeapSort self, sort_Container elems, sort_Comparator comp)
{
  /* DO-NOT-DELETE splicer.begin(sort.HeapSort.sort) */
  int32_t i;
  const int32_t num = sort_Container_getLength(elems);
  sort_Counter cmp = sort_HeapSort_getCompareCounter(self);
  sort_Counter swp = sort_HeapSort_getSwapCounter(self);
  /* make the heap */
  for(i = ((num/2) - 1); i >= 0; --i) {
    remakeHeap(elems, comp, cmp, swp, num, i);
  }
  /* put top of heap at back and remake the heap */
  i = num - 1;
  while (i > 0) {
    sort_Counter_inc(swp);
    sort_Container_swap(elems, 0, i);
    remakeHeap(elems, comp, cmp, swp, i--, 0);
  }
  sort_Counter_deleteRef(cmp);
  sort_Counter_deleteRef(swp);
  /* DO-NOT-DELETE splicer.end(sort.HeapSort.sort) */
}

/*
 * Return heap sort.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_HeapSort_getName"

char*
impl_sort_HeapSort_getName(
  sort_HeapSort self)
{
  /* DO-NOT-DELETE splicer.begin(sort.HeapSort.getName) */
  return SIDL_String_strdup("Heap sort");
  /* DO-NOT-DELETE splicer.end(sort.HeapSort.getName) */
}
