/*
 * File:          sort_MergeSort_Impl.c
 * Symbol:        sort.MergeSort-v0.1
 * Symbol Type:   class
 * Babel Version: 0.8.8
 * Description:   Server-side implementation for sort.MergeSort
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.8.8
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "sort.MergeSort" (version 0.1)
 * 
 * Merge sort
 */

#include "sort_MergeSort_Impl.h"

/* DO-NOT-DELETE splicer.begin(sort.MergeSort._includes) */
#include "sort_Container.h"
#include "sort_Comparator.h"
#include "sort_Counter.h"
#include "SIDL_String.h"

static void
mergeLists(sort_Container  elems,
           sort_Comparator comp,
           sort_Counter    cmp,
           sort_Counter    swp,
           int32_t         start,
           int32_t         mid,
           const int32_t   end)
{
  int32_t j;
  while ((start < mid) && (mid < end)) {
    sort_Counter_inc(cmp);
    if (sort_Container_compare(elems, start, mid, comp) > 0) {
      /* move first element of upper list into place */
      for(j = mid;j > start; --j) {
        sort_Counter_inc(swp);
        sort_Container_swap(elems, j, j - 1);
      }
      ++mid;
    }
    ++start;
  }
}

/**
 * end is one past the end
 */
static void
mergeSort(sort_Container  elems,
          sort_Comparator comp,
          sort_Counter    cmp,
          sort_Counter    swp,
          const int32_t   start,
          const int32_t   end)
{
  if ((end - start) > 1) {
    int32_t mid = (start + end) >> 1;
    mergeSort(elems, comp, cmp, swp, start, mid);
    mergeSort(elems, comp, cmp, swp, mid, end);
    mergeLists(elems, comp, cmp, swp, start, mid, end);
  }
}
/* DO-NOT-DELETE splicer.end(sort.MergeSort._includes) */

/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_MergeSort__ctor"

void
impl_sort_MergeSort__ctor(
  sort_MergeSort self)
{
  /* DO-NOT-DELETE splicer.begin(sort.MergeSort._ctor) */
  /* Insert the implementation of the constructor method here... */
  /* DO-NOT-DELETE splicer.end(sort.MergeSort._ctor) */
}

/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_MergeSort__dtor"

void
impl_sort_MergeSort__dtor(
  sort_MergeSort self)
{
  /* DO-NOT-DELETE splicer.begin(sort.MergeSort._dtor) */
  /* Insert the implementation of the destructor method here... */
  /* DO-NOT-DELETE splicer.end(sort.MergeSort._dtor) */
}

/*
 * Sort elements using Merge Sort.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_MergeSort_sort"

void
impl_sort_MergeSort_sort(
  sort_MergeSort self, sort_Container elems, sort_Comparator comp)
{
  /* DO-NOT-DELETE splicer.begin(sort.MergeSort.sort) */
  const int32_t num = sort_Container_getLength(elems);
  sort_Counter cmp = sort_MergeSort_getCompareCounter(self);
  sort_Counter swp = sort_MergeSort_getSwapCounter(self);
  mergeSort(elems, comp, cmp, swp, 0, num);
  sort_Counter_deleteRef(cmp);
  sort_Counter_deleteRef(swp);
  /* DO-NOT-DELETE splicer.end(sort.MergeSort.sort) */
}

/*
 * Return merge sort.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_MergeSort_getName"

char*
impl_sort_MergeSort_getName(
  sort_MergeSort self)
{
  /* DO-NOT-DELETE splicer.begin(sort.MergeSort.getName) */
  return SIDL_String_strdup("Merge sort");
  /* DO-NOT-DELETE splicer.end(sort.MergeSort.getName) */
}
