/*
 * File:          sort_SortTest_Impl.c
 * Symbol:        sort.SortTest-v0.1
 * Symbol Type:   class
 * Babel Version: 0.8.8
 * Description:   Server-side implementation for sort.SortTest
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.8.8
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "sort.SortTest" (version 0.1)
 * 
 * Run a bunch of sorts through a stress test.
 */

#include "sort_SortTest_Impl.h"

/* DO-NOT-DELETE splicer.begin(sort.SortTest._includes) */
#include <stdlib.h>
#include <stdio.h>
#include "sort_CompInt.h"
#include "sort_IntegerContainer.h"

static const int32_t s_testSizes[] = {
  0,
  1,
  2,
  3,
  4,
  7,
  10,
  51,
  100,
  -1
};

static int
notSorted(sort_Container cont,
          sort_Comparator comp)
{
  const int32_t length = sort_Container_getLength(cont);
  int32_t i;
  for(i = 1 ; i < length ; ++i ){
    if (sort_Container_compare(cont, i-1, i, comp) > 0) return TRUE;
  }
  return FALSE;
}

static void
sortAndReport(sort_SortingAlgorithm alg,
              sort_Container cont,
              sort_Comparator comp,
              SIDL_bool *result)
{
  sort_Counter swpCnt = NULL;
  sort_Counter cmpCnt = NULL;
  sort_SortingAlgorithm_reset(alg);
  sort_SortingAlgorithm_sort(alg, cont, comp);
  swpCnt = sort_SortingAlgorithm_getSwapCounter(alg);
  cmpCnt = sort_SortingAlgorithm_getCompareCounter(alg);
  printf("COMMENT: compares (%d) swaps (%d)\n",
         sort_Counter_getCount(cmpCnt),
         sort_Counter_getCount(swpCnt));
  sort_Counter_deleteRef(cmpCnt);
  sort_Counter_deleteRef(swpCnt);
  if (notSorted(cont, comp)) {
    printf("COMMENT: sort failed!!\n");
    *result = FALSE;
  }
}
/* DO-NOT-DELETE splicer.end(sort.SortTest._includes) */

/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_SortTest__ctor"

void
impl_sort_SortTest__ctor(
  sort_SortTest self)
{
  /* DO-NOT-DELETE splicer.begin(sort.SortTest._ctor) */
  /* Insert the implementation of the constructor method here... */
  /* DO-NOT-DELETE splicer.end(sort.SortTest._ctor) */
}

/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_SortTest__dtor"

void
impl_sort_SortTest__dtor(
  sort_SortTest self)
{
  /* DO-NOT-DELETE splicer.begin(sort.SortTest._dtor) */
  /* Insert the implementation of the destructor method here... */
  /* DO-NOT-DELETE splicer.end(sort.SortTest._dtor) */
}

/*
 * Perform the array stress test.
 * 
 * Return true if all the algorithms work okay.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_SortTest_stressTest"

SIDL_bool
impl_sort_SortTest_stressTest(
  struct sort_SortingAlgorithm__array* algs)
{
  /* DO-NOT-DELETE splicer.begin(sort.SortTest.stressTest) */
  SIDL_bool result = FALSE;
  if (algs) {
    const int32_t lower = sort_SortingAlgorithm__array_lower(algs, 0);
    const int32_t upper = sort_SortingAlgorithm__array_upper(algs, 0);
    int32_t i,j;
    result = TRUE;
    for(i = lower; i <= upper; ++i) {
      sort_SortingAlgorithm alg =
        sort_SortingAlgorithm__array_get1(algs, i);
      if (alg) {
        sort_IntegerContainer data = sort_IntegerContainer__create();
        sort_Container cont = sort_Container__cast(data);
        sort_CompInt intcomp = sort_CompInt__create();
        sort_Comparator comp = sort_Comparator__cast(intcomp);
        char *name           = sort_SortingAlgorithm_getName(alg);
        j = 0;
        printf("COMMENT: ****ALGORITHM IS %s****\n", name);
        free((void *)name);
        while (s_testSizes[j] >= 0) {
          sort_CompInt_setSortIncreasing(intcomp, TRUE);
          printf("COMMENT: DATA SIZE %d\n", s_testSizes[j]);
          sort_IntegerContainer_setLength(data, s_testSizes[j]);
          sortAndReport(alg, cont, comp, &result);
          printf("COMMENT: pre-sorted list\n");
          sortAndReport(alg, cont, comp, &result);
          printf("COMMENT: reverse sorted list\n");
          sort_CompInt_setSortIncreasing(intcomp, FALSE);
          sortAndReport(alg, cont, comp, &result);
          ++j;
        }
        sort_IntegerContainer_deleteRef(data);
        sort_SortingAlgorithm_deleteRef(alg);
        sort_CompInt_deleteRef(intcomp);
      }
      else{
        result = FALSE;
      }
    }
  }
  fflush(stdout);
  return result;
  /* DO-NOT-DELETE splicer.end(sort.SortTest.stressTest) */
}
