! 
! File:          sort_MergeSort_Impl.F90
! Symbol:        sort.MergeSort-v0.1
! Symbol Type:   class
! Babel Version: 0.8.8
! Description:   Server-side implementation for sort.MergeSort
! 
! WARNING: Automatically generated; only changes within splicers preserved
! 
! babel-version = 0.8.8
! 


! 
! Symbol "sort.MergeSort" (version 0.1)
! 
! Merge sort
! 


#include "sort_Counter_fAbbrev.h"
#include "sort_SortingAlgorithm_fAbbrev.h"
#include "SIDL_BaseInterface_fAbbrev.h"
#include "SIDL_BaseClass_fAbbrev.h"
#include "sort_MergeSort_fAbbrev.h"
#include "sort_Comparator_fAbbrev.h"
#include "SIDL_ClassInfo_fAbbrev.h"
#include "sort_Container_fAbbrev.h"
! DO-NOT-DELETE splicer.begin(_miscellaneous_code_start)
! This file contains an interative (non-recursive) version of mergesort.

subroutine mergeLists(elems, comp, cmp, swp, start, mid, last)
  use sort_Container
  use sort_Comparator
  use sort_Counter
  type(sort_Container_t) :: elems
  type(sort_Comparator_t) :: comp
  type(sort_Counter_t) :: cmp, swp
  integer(selected_int_kind(9)) start, mid, last, j
  integer(selected_int_kind(9)) compres, counter
  integer(selected_int_kind(9)) m, s
  m = mid
  s = start
  do while ((s .lt. m) .and. (m .lt. last))
     call inc(cmp, counter)
     call compare(elems, s, m, comp, compres)
     if (compres .gt. 0) then
        do j = m, s + 1, -1
           call inc(swp, counter)
           call swap(elems, j, j - 1)
        enddo
        m = m + 1
     endif
     s = s + 1
  enddo
end subroutine mergeLists
! DO-NOT-DELETE splicer.end(_miscellaneous_code_start)




! 
! Class constructor called when the class is created.
! 

recursive subroutine sort_MergeSort__ctor_mi(self)
  use sort_MergeSort
  use sort_MergeSort_impl
  ! DO-NOT-DELETE splicer.begin(sort.MergeSort._ctor.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(sort.MergeSort._ctor.use)
  implicit none
  type(sort_MergeSort_t) :: self

! DO-NOT-DELETE splicer.begin(sort.MergeSort._ctor)
! DO-NOT-DELETE splicer.end(sort.MergeSort._ctor)
end subroutine sort_MergeSort__ctor_mi


! 
! Class destructor called when the class is deleted.
! 

recursive subroutine sort_MergeSort__dtor_mi(self)
  use sort_MergeSort
  use sort_MergeSort_impl
  ! DO-NOT-DELETE splicer.begin(sort.MergeSort._dtor.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(sort.MergeSort._dtor.use)
  implicit none
  type(sort_MergeSort_t) :: self

! DO-NOT-DELETE splicer.begin(sort.MergeSort._dtor)
! DO-NOT-DELETE splicer.end(sort.MergeSort._dtor)
end subroutine sort_MergeSort__dtor_mi


! 
! Sort elements using Merge Sort.
! 

recursive subroutine sort_MergeSort_sort_mi(self, elems, comp)
  use sort_MergeSort
  use sort_Comparator
  use sort_Container
  use sort_MergeSort_impl
  ! DO-NOT-DELETE splicer.begin(sort.MergeSort.sort.use)
  use sort_Counter
  ! DO-NOT-DELETE splicer.end(sort.MergeSort.sort.use)
  implicit none
  type(sort_MergeSort_t) :: self
  type(sort_Container_t) :: elems
  type(sort_Comparator_t) :: comp

! DO-NOT-DELETE splicer.begin(sort.MergeSort.sort)
  type(sort_Counter_t) :: cmp, swp
  integer(selected_int_kind(9)) stride, i, mid, last, len
  mid = 1
  stride = 2
  call getLength(elems, len)
  call getCompareCounter(self, cmp)
  call getSwapCounter(self, swp)
  do while (mid .lt. len)
     do i = 0, len - mid, stride
        last = i + stride
        if (last .gt. len) then
           last = len
        endif
        call mergeLists(elems, comp, cmp, swp, i, i + mid, last)
     enddo
     mid = stride
     stride = stride + stride
  enddo
  call deleteRef(cmp)
  call deleteRef(swp)
! DO-NOT-DELETE splicer.end(sort.MergeSort.sort)
end subroutine sort_MergeSort_sort_mi


! 
! Return merge sort.
! 

recursive subroutine sort_MergeSort_getName_mi(self, retval)
  use sort_MergeSort
  use sort_MergeSort_impl
  ! DO-NOT-DELETE splicer.begin(sort.MergeSort.getName.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(sort.MergeSort.getName.use)
  implicit none
  type(sort_MergeSort_t) :: self
  character (len=*) :: retval

! DO-NOT-DELETE splicer.begin(sort.MergeSort.getName)
  retval = 'Merge sort (non-recursive)'
! DO-NOT-DELETE splicer.end(sort.MergeSort.getName)
end subroutine sort_MergeSort_getName_mi


! DO-NOT-DELETE splicer.begin(_miscellaneous_code_end)
! Insert extra code here...
! DO-NOT-DELETE splicer.end(_miscellaneous_code_end)
