! 
! File:          sort_SortTest_Impl.F90
! Symbol:        sort.SortTest-v0.1
! Symbol Type:   class
! Babel Version: 0.8.8
! Description:   Server-side implementation for sort.SortTest
! 
! WARNING: Automatically generated; only changes within splicers preserved
! 
! babel-version = 0.8.8
! 


! 
! Symbol "sort.SortTest" (version 0.1)
! 
! Run a bunch of sorts through a stress test.
! 


#include "sort_SortingAlgorithm_fAbbrev.h"
#include "SIDL_BaseInterface_fAbbrev.h"
#include "SIDL_BaseClass_fAbbrev.h"
#include "SIDL_ClassInfo_fAbbrev.h"
#include "sort_SortTest_fAbbrev.h"
! DO-NOT-DELETE splicer.begin(_miscellaneous_code_start)
#include "sort_CompInt_fAbbrev.h"
#include "sort_Container_fAbbrev.h"
#include "sort_Counter_fAbbrev.h"
#include "sort_IntegerContainer_fAbbrev.h"

subroutine sortAndReport(alg, cont, comp)
  use sort_SortingAlgorithm
  use sort_Counter
  use sort_Container
  use sort_Comparator
  implicit none
  type(sort_SortingAlgorithm_t) :: alg
  type(sort_Container_t) :: cont
  type(sort_Comparator_t) :: comp
  type(sort_Counter_t) :: swpCnt, cmpCnt
  integer(selected_int_kind(9)) numswap, numcmp
  call reset(alg)
  call sort(alg, cont, comp)
  call getSwapCounter(alg, swpCnt)
  call getCount(swpCnt, numswap)
  call deleteRef(swpCnt)
  call getCompareCounter(alg, cmpCnt)
  call getCount(cmpCnt, numcmp)
  call deleteRef(cmpCnt)
  write (*,*) 'COMMENT: compares (', numcmp, ') swaps (', numswap, ')'
end subroutine sortAndReport

logical function notSorted(cont, comp)
  use sort_Container
  use sort_Comparator
  implicit none
  type(sort_Container_t) :: cont
  type(sort_Comparator_t) :: comp
  integer(selected_int_kind(9)) csize, i, result
  call getLength(cont, csize)
  do i = 1, csize - 1
     call compare(cont, i-1, i, comp, result)
     if (result .gt. 0) then
        notSorted = .true.
        goto 100
     endif
  enddo
  notSorted = .false.
100 return
end function notSorted

subroutine testAlgorithm(alg, retval)
  use sort_SortingAlgorithm
  use sort_IntegerContainer
  use sort_Container
  use sort_Comparator
  use sort_CompInt
  implicit none
  type(sort_SortingAlgorithm_t) :: alg
  type(sort_Container_t) :: cont
  type(sort_IntegerContainer_t) :: intcont
  type(sort_Comparator_t) :: comp
  type(sort_CompInt_t) ::intcomp
  character*30 name
  logical notSorted, retval
  integer(selected_int_kind(9)) j, testsizes(10)
  data testsizes / 0, 1, 2, 3, 4, 7, 10, 51, 100, -1 /

  call getName(alg, name)
  write(*,*) 'COMMENT: ****ALGORITHM IS ' // name // '****'
  call new(intcont)
  call cast(intcont, cont)
  call new(intcomp)
  call cast(intcomp, comp)
  j = 1
  do while (testsizes(j) .ge. 0)
     call setSortIncreasing(intcomp, .true.)
     write (*,*) 'COMMENT: DATA SIZE ', testsizes(j)
     call setLength(intcont, testsizes(j))
     call sortAndReport(alg, cont, comp)
     if (notSorted(cont, comp)) then
        write(*,*) 'COMMENT: sort failed!!'
        retval = .false.
     endif
     write (*, *) 'COMMENT: pre-sorted list'
     call sortAndReport(alg, cont, comp)
     if (notSorted(cont, comp)) then
        write(*,*) 'COMMENT: sort failed!!'
        retval = .false.
     endif
     write (*, *) 'COMMENT: reverse sorted list'
     call setSortIncreasing(intcomp, .false.)
     call sortAndReport(alg, cont, comp)
     if (notSorted(cont, comp)) then
        write(*,*) 'COMMENT: sort failed!!'
        retval = .false.
     endif
     j = j + 1
  enddo

  call deleteRef(intcont)
  call deleteRef(alg)
  call deleteRef(intcomp)
end subroutine testAlgorithm
! DO-NOT-DELETE splicer.end(_miscellaneous_code_start)




! 
! Class constructor called when the class is created.
! 

recursive subroutine sort_SortTest__ctor_mi(self)
  use sort_SortTest
  use sort_SortTest_impl
  ! DO-NOT-DELETE splicer.begin(sort.SortTest._ctor.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(sort.SortTest._ctor.use)
  implicit none
  type(sort_SortTest_t) :: self

! DO-NOT-DELETE splicer.begin(sort.SortTest._ctor)
! Insert the implementation here...
! DO-NOT-DELETE splicer.end(sort.SortTest._ctor)
end subroutine sort_SortTest__ctor_mi


! 
! Class destructor called when the class is deleted.
! 

recursive subroutine sort_SortTest__dtor_mi(self)
  use sort_SortTest
  use sort_SortTest_impl
  ! DO-NOT-DELETE splicer.begin(sort.SortTest._dtor.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(sort.SortTest._dtor.use)
  implicit none
  type(sort_SortTest_t) :: self

! DO-NOT-DELETE splicer.begin(sort.SortTest._dtor)
! Insert the implementation here...
! DO-NOT-DELETE splicer.end(sort.SortTest._dtor)
end subroutine sort_SortTest__dtor_mi


! 
! Perform the array stress test.
! 
! Return true if all the algorithms work okay.
! 

recursive subroutine sort_SortTest_stressTest_mi(algs, retval)
  use sort_SortingAlgorithm
  use sort_SortTest
  use sort_SortingAlgorithm_array
  use sort_SortTest_impl
  ! DO-NOT-DELETE splicer.begin(sort.SortTest.stressTest.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(sort.SortTest.stressTest.use)
  implicit none
  type(sort_SortingAlgorithm_1d) :: algs
  logical :: retval

! DO-NOT-DELETE splicer.begin(sort.SortTest.stressTest)
  integer(selected_int_kind(9)) low, up, i
  type(sort_SortingAlgorithm_t) ::alg
  if (not_null(algs)) then
     low = lower(algs, 0)
     up = upper(algs, 0)
     retval = .true.
     do i = low, up
        call get(algs, i, alg)
        if (not_null(alg)) then
           call testAlgorithm(alg, retval)
        else
           retval = .false.
        endif
     enddo
  endif
! DO-NOT-DELETE splicer.end(sort.SortTest.stressTest)
end subroutine sort_SortTest_stressTest_mi


! DO-NOT-DELETE splicer.begin(_miscellaneous_code_end)
! Insert extra code here...
! DO-NOT-DELETE splicer.end(_miscellaneous_code_end)
