
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Strings.h"

void test_string( int * part_no, int * final_result );
void declare_part( int *part_no );
void end_part( int part_no, int result, int *final_result );


char * result_string[] = { "FAIL", "XFAIL", "PASS" };
const int pass = 2;
const int xfail = 1;
const int fail = 0;

#define MYASSERT( AAA ) \
  declare_part( &part_no ); \
  printf("COMMENT: %s\n", #AAA ); \
  if ( AAA ) result = pass; \
  else result = fail;  \
  end_part( part_no, result, &final_result );

int main(int argc, char **argv) { 
  int result = pass; 
  int final_result = pass;
  int part_no = 0;
  Strings_Cstring obj;
  printf("NPARTS -1\n");
  
  { 
    char* out;
    char* temp;
    char* inout = (char*)(malloc(sizeof(char)*6));
    strcpy(inout,"Three");
    obj = Strings_Cstring__create();
 
    MYASSERT((temp =  Strings_Cstring_returnback( obj, TRUE )) &&
             !strcmp(temp, "Three"));
    free(temp);
    MYASSERT( (!(temp = Strings_Cstring_returnback(obj, FALSE))) || 
               !strcmp(temp, ""));
    if (temp) free(temp);
    MYASSERT( Strings_Cstring_passin( obj, "Three" ) == TRUE );
    MYASSERT( Strings_Cstring_passin( obj, NULL ) == FALSE );
    MYASSERT( Strings_Cstring_passout( obj, TRUE, &out ) == TRUE && !(strcmp(out, "Three")));
    free(out);
    out = NULL;
    MYASSERT( Strings_Cstring_passout( obj, FALSE, &out ) == FALSE && 
              !(out && strcmp(out, "")));
    if (out) free(out);
    MYASSERT( Strings_Cstring_passinout( obj, &inout ) == TRUE && !(strcmp(inout,"threes")));
    MYASSERT( (temp=Strings_Cstring_passeverywhere( obj, "Three", &out,
                                                   &inout )) &&
              !(strcmp(temp, "Three"))  &&
	      !(strcmp(out, "Three")) && !(strcmp(inout, "Three")) );
    MYASSERT( Strings_Cstring_mixedarguments( obj, "Test", 'z', "Test", 'z')
              );
    MYASSERT( !Strings_Cstring_mixedarguments( obj, "Not", 'A', "Equal", 'a')
             );

    free(out);
    free(temp);
    free(inout);
    inout = NULL;
    MYASSERT( (Strings_Cstring_passinout( obj, &inout) == FALSE));
    if (inout) free(inout);
    
    Strings_Cstring_deleteRef( obj );
  }

  printf("TEST_RESULT %s\n", result_string[ final_result ] );
  return 0;
}


void declare_part( int * part_no ) {
  ++(*part_no);
  printf("PART %d\n", *part_no );
}

void end_part( int part_no, int result, int *final_result ) {
  printf("RESULT %d %s\n", part_no, result_string[ result ] );
  if ( result < *final_result ) { 
    *final_result = result;
  }
}

