
#include <iostream>
#include <string>
using namespace std;
#include "Strings.hh"

void test_string( int * part_no, int * final_result );
void declare_part( int *part_no );
void end_part( int part_no, int result, int *final_result );



const char * result_string[] = { "FAIL", "XFAIL", "PASS", "XPASS", "UNSUPPORTED"  };
const int unsupported = 4;
const int xpass = 3;
const int pass = 2;
const int xfail = 1;
const int fail = 0;

#define MYASSERT( AAA ) \
  declare_part( &part_no ); \
  cout << "COMMENT: " <<  #AAA << endl; \
  if ( AAA ) result = pass; \
  else result = fail;  \
  end_part( part_no, result, &final_result );

#define MYXFAIL( AAA ) \
  declare_part( &part_no ); \
  cout << "COMMENT: " << #AAA << endl; \
  if ( AAA ) result = xpass; \
  else result = xfail; \
  end_part( part_no, result, &final_result );

#define MYBROKEN( AAA ) \
  declare_part( &part_no ); \
  cout << "COMMENT: " << #AAA << endl; \
  end_part( part_no, unsupported, &final_result );

int main() { 
  int result = pass; 
  int final_result = pass;
  int part_no = 0;
  Strings::Cstring obj = Strings::Cstring::_create();
  cout << "NPARTS -1" << endl;
  
  { 
    string in = "Three";
    string out;
    string inout = "Three";
 
    MYASSERT( obj.returnback(true) == "Three" );
    MYASSERT( obj.returnback(false) == "" );
    MYASSERT( obj.passin( in ) == true );
    MYASSERT( obj.passout(true, out ) == true && out == "Three" );
    MYASSERT( obj.passout(false, out ) == false && out == "" );
    MYASSERT( obj.passinout( inout ) == true && inout == "threes" );
    MYASSERT( obj.passeverywhere( in, out, inout ) == "Three" &&
	      out == "Three" && inout == "Three" );
    MYASSERT( obj.mixedarguments( "Test", 'z', "Test", 'z') );
    MYASSERT( !obj.mixedarguments( "Not", 'A', "Equal", 'a') );
    
  }

  cout << "TEST_RESULT " << result_string[ final_result ]  << endl;
  return 0;
}


void declare_part( int * part_no ) {
  ++(*part_no);
  cout << "PART " << *part_no << endl;
}

void end_part( int part_no, int result, int *final_result ) {
  cout << "RESULT " << part_no << " " << result_string[ result ] << endl;
  if ( result == xpass ) {
    *final_result = fail;
  } else if ( result == unsupported && *final_result == pass ) { 
    *final_result = xfail;
  } else if ( result < *final_result ) { 
    *final_result = result;
  }
}

