c
c     File:       argstest.f
c     Copyright:  (c) 2001 The Regents of the University of California
c     Release:    $Name: release-0-8-8 $
c     Revision:   @(#) $Revision: 1.5 $
c     Date:       $Date: 2002/09/30 23:01:01 $
c     Description:Exercise the FORTRAN interface
c
c
      subroutine starttest(number)
      implicit none
      integer number
      write (6, 100) number
 100  format ('PART ', I4)
      end

      subroutine reporttest(test, number, pass, fail)
      implicit none
      integer number, pass, fail
      logical test
      if (test) then
         write (6, 100) number, 'PASS'
         pass = pass + 1
      else
         write (6, 100) number, 'FAIL'
         fail = fail + 1
      endif
 100  format ('RESULT', 1x, i2, 1x, A4)
      number = number + 1
      end

      subroutine teststring(test, pass, fail)
      implicit none
      integer*8 obj
      integer test, pass, fail
      logical retval
      character*80 in, inout, out, sreturn
      character ch1, ch2
      call Strings_Cstring__create_f(obj)
      sreturn = 'Not three'
      call starttest(test)
      call Strings_Cstring_returnback_f(obj, .true., sreturn)
      call reporttest(sreturn .eq. 'Three', test, pass, fail)
      retval = .false.
      call starttest(test)
      call Strings_Cstring_passin_f(obj, 'Three', retval)
      call reporttest(retval, test, pass, fail)
      in = 'Three'
      call starttest(test)
      call Strings_Cstring_passin_f(obj, in, retval)
      call reporttest(retval, test, pass, fail)
      call starttest(test)
      call Strings_Cstring_passin_f(obj, 'Four', retval)
      call reporttest(.not. retval, test, pass, fail)
      out = 'Not three'
      call starttest(test)
      call Strings_Cstring_passout_f(obj, .true., out, retval)
      call reporttest(retval .and. out .eq. 'Three', test,
     $     pass, fail)
      inout = 'Three'
      call starttest(test)
      call Strings_Cstring_passinout_f(obj, inout, retval)
      call reporttest(retval .and. inout .eq. 'threes', test,
     $     pass, fail)
      call starttest(test)
      call Strings_Cstring_passeverywhere_f(obj,
     $     'Three', out, inout, sreturn)
      call reporttest(sreturn .eq. 'Three' .and.
     $     out .eq. 'Three' .and. inout .eq. 'Three',
     $     test, pass, fail)
      call starttest(test)
      call Strings_Cstring_mixedarguments_f(obj, 'Test', 'z',
     $     'Test', 'z', retval)
      call reporttest(retval, test, pass, fail)
      call starttest(test)
      call Strings_Cstring_mixedarguments_f(obj, 'Not', 'A',
     $     'Equal', 'a', retval)
      call reporttest(.not. retval, test,
     $     pass, fail)
      ch1 = 'z'
      ch2 = 'z'
      call starttest(test)
      call Strings_Cstring_mixedarguments_f(obj, 'Test', ch1,
     $     'Test', ch1, retval)
      call reporttest(retval, test, pass, fail)
      call starttest(test)
      call Strings_Cstring_mixedarguments_f(obj, 'Test', ch1,
     $     'Test', ch2, retval)
      call reporttest(retval, test, pass, fail)
      ch2 = 'A'
      call starttest(test)
      call Strings_Cstring_mixedarguments_f(obj, 'Not', ch1,
     $     'Equal', ch2, retval)
      call reporttest(.not. retval, test, pass, fail)
      call Strings_Cstring_deleteRef_f(obj)

      end

      program stringstest
      integer test, pass, fail
      test = 1
      pass = 0
      fail = 0
      write(6,120) 12
      write(6,110) 'String tests'
      call teststring(test, pass, fail)
      if ((fail .eq. 0) .and. (pass .eq. 12)) then
         write(6, 100) 'PASS'
      else
         write(6, 100) 'FAIL'
      endif
 100  format ('TEST_RESULT', 1x, a4)
 110  format ('COMMENT:', 1x, a20)
 120  format ('NPARTS', 1x, i4)
      end
