/*
 * File:        SIDL_Python.c
 * Release:     $Name: release-0-8-8 $
 * Revision:    @(#) $Revision: 1.14 $
 * Date:        $Date: 2003/10/03 16:35:37 $
 * Description: Initialize a Python language interpretter
 *
 */

#include "SIDL_Python.h"
#include "babel_config.h"
#ifndef included_SIDL_DLL_h
#include "SIDL_DLL.h"
#endif
#ifndef included_SIDL_Loader_h
#include "SIDL_Loader.h"
#endif
#ifndef included_SIDL_String_h
#include "SIDL_String.h"
#endif
#include <stdio.h>
#include <stdlib.h>


void SIDL_Python_Init(void)
{
  static int python_notinitialized = 1;
#ifdef PYTHON_SHARED_LIBRARY
  static const char libName[] = PYTHON_SHARED_LIBRARY;
#endif
  SIDL_DLL dll;
  static const char initName[] = "Py_Initialize";
  static const char finalName[] = "Py_Finalize";
  void (*pyinit)(void);
  void *handle;
  if (python_notinitialized) {
    dll = SIDL_DLL__create();
    if (dll) {
      if (SIDL_DLL_loadLibrary(dll, "main:")) {
        pyinit = (void (*)(void))SIDL_DLL_lookupSymbol(dll, initName);
        if (pyinit) {
          (*pyinit)();
          python_notinitialized = 0;
          pyinit = (void (*)(void))SIDL_DLL_lookupSymbol(dll, finalName);
          if (pyinit) {
            atexit(pyinit);
          }
        }
      }
      SIDL_DLL_deleteRef(dll);
    }

    if (python_notinitialized) {
#ifdef PYTHON_SHARED_LIBRARY
      char *url = SIDL_String_concat2("file:", PYTHON_SHARED_LIBRARY);
      dll = SIDL_DLL__create();
      if (dll && url) {
        if (SIDL_DLL_loadLibrary(dll, url)) {
          pyinit = (void (*)(void))SIDL_DLL_lookupSymbol(dll, initName);
          if (pyinit) {
            python_notinitialized = 0;
            (*pyinit)();
            pyinit = (void (*)(void))SIDL_DLL_lookupSymbol(dll, finalName);
            if (pyinit) {
              atexit(pyinit);
            }
            SIDL_Loader_addDLL(dll);
          } 
          else {
            fprintf(stderr, "Babel: Error: Unable to find symbol %s in %s",
                    initName, libName);
            SIDL_DLL_unloadLibrary(dll);
          }
        }
        else {
          fprintf(stderr,
                  "Babel: Error: Unable to load library %s\n", libName);
        }
      }
      else {
        fprintf(stderr, "Unable to allocate string or SIDL.DDL object\n");
      }
      if (url) SIDL_String_free(url);
      if (dll) SIDL_DLL_deleteRef(dll);
#else
      fprintf(stderr, "Babel: Error: Unable to initialize Python.\n\
The BABEL runtime library was not configured for Python support,\n\
and Python is not already loaded into the global symbol space.\n");
      python_notinitialized = 0;
#endif
    }
  }
}
