/*

 ============================================================================
                   The Apache Software License, Version 1.1
 ============================================================================

 Copyright (C) 1999-2003 The Apache Software Foundation. All rights reserved.

 Redistribution and use in source and binary forms, with or without modifica-
 tion, are permitted provided that the following conditions are met:

 1. Redistributions of  source code must  retain the above copyright  notice,
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.

 3. The end-user documentation included with the redistribution, if any, must
    include  the following  acknowledgment:  "This product includes  software
    developed  by the  Apache Software Foundation  (http://www.apache.org/)."
    Alternately, this  acknowledgment may  appear in the software itself,  if
    and wherever such third-party acknowledgments normally appear.

 4. The names "Batik" and  "Apache Software Foundation" must  not  be
    used to  endorse or promote  products derived from  this software without
    prior written permission. For written permission, please contact
    apache@apache.org.

 5. Products  derived from this software may not  be called "Apache", nor may
    "Apache" appear  in their name,  without prior written permission  of the
    Apache Software Foundation.

 THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 FITNESS  FOR A PARTICULAR  PURPOSE ARE  DISCLAIMED.  IN NO  EVENT SHALL  THE
 APACHE SOFTWARE  FOUNDATION  OR ITS CONTRIBUTORS  BE LIABLE FOR  ANY DIRECT,
 INDIRECT, INCIDENTAL, SPECIAL,  EXEMPLARY, OR CONSEQUENTIAL  DAMAGES (INCLU-
 DING, BUT NOT LIMITED TO, PROCUREMENT  OF SUBSTITUTE GOODS OR SERVICES; LOSS
 OF USE, DATA, OR  PROFITS; OR BUSINESS  INTERRUPTION)  HOWEVER CAUSED AND ON
 ANY  THEORY OF LIABILITY,  WHETHER  IN CONTRACT,  STRICT LIABILITY,  OR TORT
 (INCLUDING  NEGLIGENCE OR  OTHERWISE) ARISING IN  ANY WAY OUT OF THE  USE OF
 THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 This software  consists of voluntary contributions made  by many individuals
 on  behalf of the Apache Software  Foundation. For more  information on the
 Apache Software Foundation, please see <http://www.apache.org/>.

*/

package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

/**
 * This implementation of RenderedImage only serves to put the tiles
 * generated by it's input into the TileCache.
 *
 * @author <a href="mailto:thomas.deweese@kodak.com">Thomas DeWeese</a>
 * @version $Id: TileCacheRed.java,v 1.6 2003/08/08 11:39:07 vhardy Exp $ 
 */
public class TileCacheRed extends AbstractTiledRed {

    /**
     * Place the results of computations of cr into the global tile cache.
     * @param cr The operation to cache results from.
     */
    public TileCacheRed(CachableRed cr) {
        super(cr, null);
    }

    /**
     * Place the results of computations of cr into the global tile cache.
     * @param cr The operation to cache results from.
     */
    public TileCacheRed(CachableRed cr, int tileWidth, int tileHeight) {
        super();
        ColorModel  cm = cr.getColorModel();
        Rectangle bounds = cr.getBounds();
        if (tileWidth  > bounds.width)  tileWidth  = bounds.width;
        if (tileHeight > bounds.height) tileHeight = bounds.height;
        SampleModel sm = cm.createCompatibleSampleModel(tileWidth, tileHeight);
        init(cr, cr.getBounds(), cm, sm, 
             cr.getTileGridXOffset(), cr.getTileGridYOffset(), 
             null);
    }

    public void genRect(WritableRaster wr) {
        // Get my source.
        CachableRed src = (CachableRed)getSources().get(0);
        
        src.copyData(wr);
    }

    public void flushCache(Rectangle rect) {
        int tx0 = getXTile(rect.x);
        int ty0 = getYTile(rect.y);
        int tx1 = getXTile(rect.x+rect.width -1);
        int ty1 = getYTile(rect.y+rect.height-1);

        if (tx0 < minTileX) tx0 = minTileX;
        if (ty0 < minTileY) ty0 = minTileY;

        if (tx1 >= minTileX+numXTiles) tx1 = minTileX+numXTiles-1;
        if (ty1 >= minTileY+numYTiles) ty1 = minTileY+numYTiles-1;

        if ((tx1 < tx0) || (ty1 < ty0))
            return;

        TileStore store = getTileStore();
        for (int y=ty0; y<=ty1; y++)
            for (int x=tx0; x<=tx1; x++)
                store.setTile(x, y, null);
    }
}
