/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included with this distribution in  *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.batik.gvt.event;

/**
 * An abstract adapter class for receiving graphics node key
 * events. The methods in this class are empty. This class exists as
 * convenience for creating listener objects.
 *
 * <p>Extend this class to create a <tt>GraphicsNodeKeyEvent</tt>
 * listener and override the methods for the events of interest. (If
 * you implement the <tt>GraphicsNodeKeyListener</tt> interface, you
 * have to define all of the methods in it. This abstract class
 * defines null methods for them all, so you can only have to define
 * methods for events you care about.)
 *
 * @author <a href="mailto:Thierry.Kormann@sophia.inria.fr">Thierry Kormann</a>
 * @version $Id: GraphicsNodeKeyAdapter.java,v 1.1.1.1 2000/10/10 18:39:51 hillion Exp $
 */
public abstract class GraphicsNodeKeyAdapter
        implements GraphicsNodeKeyListener {

    public void keyPressed(GraphicsNodeKeyEvent evt) {}

    public void keyReleased(GraphicsNodeKeyEvent evt) {}

    public void keyTyped(GraphicsNodeKeyEvent evt) {}

}
