/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included with this distribution in  *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.batik.parser;

import java.io.Reader;

import org.apache.batik.i18n.Localizable;

/**
 * This interface represents a parser.
 *
 * @author <a href="mailto:stephane@hillion.org">Stephane Hillion</a>
 * @version $Id: Parser.java,v 1.3 2003/04/11 13:58:51 vhardy Exp $
 */
public interface Parser extends Localizable {
    /**
     * Parses the given reader
     */
    public void parse(Reader r) throws ParseException;

    /**
     * Parses the given string
     */
    public void parse(String s) throws ParseException;

    /**
     * Allows an application to register an error event handler.
     *
     * <p>If the application does not register an error event handler,
     * all error events reported by the parser will cause an exception
     * to be thrown.
     *
     * <p>Applications may register a new or different handler in the
     * middle of a parse, and the parser must begin using the new
     * handler immediately.</p>
     * @param handler The error handler.
     */
    void setErrorHandler(ErrorHandler handler);
}
