/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included with this distribution in  *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.batik.swing.svg;

/**
 * This interface represents a listener to the GVTTreeBuilderEvent events.
 *
 * @author <a href="mailto:stephane@hillion.org">Stephane Hillion</a>
 * @version $Id: GVTTreeBuilderListener.java,v 1.2 2001/05/07 17:34:24 hillion Exp $
 */
public interface GVTTreeBuilderListener {

    /**
     * Called when a build started.
     */
    void gvtBuildStarted(GVTTreeBuilderEvent e);

    /**
     * Called when a build was completed.
     */
    void gvtBuildCompleted(GVTTreeBuilderEvent e);

    /**
     * Called when a build was cancelled.
     */
    void gvtBuildCancelled(GVTTreeBuilderEvent e);

    /**
     * Called when a build failed.
     */
    void gvtBuildFailed(GVTTreeBuilderEvent e);

}
