/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included with this distribution in  *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.batik.util;

/**
 * This <tt>SecurityManager</tt> extension exposes the <tt>getClassContext</tt>
 * method so that it can be used by the <tt>BatikSecuritySupport</tt> or other
 * security related class.
 *
 * @author <a mailto="vincent.hardy@sun.com">Vincent Hardy</a>
 * @version $Id: BatikSecurityManager.java,v 1.1 2002/05/07 09:00:06 vhardy Exp $
 */
public class BatikSecurityManager extends SecurityManager {
    /**
     * Returns the current execution stack as an array of classes. 
     * <p>
     * The length of the array is the number of methods on the execution 
     * stack. The element at index <code>0</code> is the class of the 
     * currently executing method, the element at index <code>1</code> is 
     * the class of that method's caller, and so on. 
     *
     * @return  the execution stack.
     */
    public Class[] getClassContext(){
        return super.getClassContext();
    }

    
}
