/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.benchmarks.client;

import com.google.gwt.benchmarks.client.Operator;
import com.google.gwt.benchmarks.client.RangeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntRange
implements Iterable<Integer> {
    int end;
    Operator operator;
    int start;
    int step;

    public IntRange(int start, int end, Operator operator, int step) {
        this.start = start;
        this.end = end;
        this.operator = operator;
        this.step = step;
        if (step <= 0) {
            throw new IllegalArgumentException("step must be > 0");
        }
    }

    public IntRangeIterator iterator() {
        return new IntRangeIterator(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntRangeIterator
    extends RangeIterator<Integer> {
        int end;
        Operator operator;
        int step;
        int value;

        IntRangeIterator(IntRange r) {
            this.value = r.start;
            this.end = r.end;
            this.operator = r.operator;
            if (this.operator == null) {
                throw new IllegalArgumentException("operator must be \"*\" or \"+\"");
            }
            this.step = r.step;
        }

        @Override
        public boolean hasNext() {
            return this.value <= this.end;
        }

        @Override
        public Integer next() {
            int currentValue = this.value;
            this.value = this.step();
            return currentValue;
        }

        public int step() {
            if (this.operator == Operator.MULTIPLY) {
                return this.value * this.step;
            }
            return this.value + this.step;
        }
    }
}

