/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ur" locale.
 */
public class LocalizedNamesImpl_ur extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "PK",
        "IN",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AD",
        "AI",
        "AW",
        "AX",
        "BB",
        "BH",
        "BL",
        "BM",
        "BN",
        "BZ",
        "CI",
        "CP",
        "CR",
        "CV",
        "DG",
        "DJ",
        "DM",
        "EA",
        "EU",
        "FJ",
        "GD",
        "GI",
        "GP",
        "GT",
        "GU",
        "GY",
        "HK",
        "IC",
        "IM",
        "JM",
        "KW",
        "LU",
        "MC",
        "ME",
        "MF",
        "MQ",
        "MS",
        "MT",
        "MU",
        "MV",
        "NR",
        "NU",
        "PA",
        "PN",
        "PR",
        "PW",
        "QA",
        "QO",
        "RE",
        "RS",
        "SG",
        "SJ",
        "ST",
        "SV",
        "TA",
        "YT",
        "IE",
        "IS",
        "AZ",
        "AM",
        "AT",
        "AU",
        "AR",
        "JO",
        "ER",
        "UZ",
        "GQ",
        "IL",
        "AF",
        "AL",
        "DZ",
        "AS",
        "AQ",
        "AG",
        "ID",
        "AO",
        "IT",
        "ET",
        "IR",
        "EE",
        "EC",
        "BS",
        "IO",
        "BR",
        "GB",
        "BI",
        "BF",
        "BG",
        "BD",
        "BA",
        "BO",
        "BW",
        "IN",
        "BT",
        "BY",
        "BE",
        "BJ",
        "TW",
        "TJ",
        "TM",
        "TR",
        "TZ",
        "TO",
        "TH",
        "TN",
        "GE",
        "JP",
        "JE",
        "DE",
        "SB",
        "FO",
        "FK",
        "MH",
        "VI",
        "VG",
        "CC",
        "CK",
        "KY",
        "TC",
        "BV",
        "NF",
        "CX",
        "HM",
        "CF",
        "CZ",
        "ZA",
        "GS",
        "TF",
        "KR",
        "RW",
        "RU",
        "RO",
        "US",
        "UM",
        "ZW",
        "ZM",
        "WS",
        "SM",
        "CS",
        "LK",
        "SA",
        "SI",
        "SK",
        "CH",
        "SZ",
        "SR",
        "SD",
        "SE",
        "ES",
        "SL",
        "SY",
        "LC",
        "PM",
        "KN",
        "VC",
        "SH",
        "SN",
        "SC",
        "MP",
        "KP",
        "SO",
        "IQ",
        "OM",
        "GA",
        "FR",
        "PF",
        "GF",
        "PS",
        "PH",
        "FI",
        "CY",
        "KZ",
        "LA",
        "LR",
        "LB",
        "LT",
        "LV",
        "LI",
        "LY",
        "LS",
        "FM",
        "MD",
        "ML",
        "MO",
        "AE",
        "MA",
        "TL",
        "EG",
        "EH",
        "MK",
        "MY",
        "MW",
        "MN",
        "MR",
        "MZ",
        "MG",
        "MM",
        "MX",
        "NE",
        "NG",
        "NO",
        "NA",
        "NI",
        "NL",
        "AN",
        "NZ",
        "NC",
        "NP",
        "WF",
        "VU",
        "VN",
        "VE",
        "VA",
        "TT",
        "TV",
        "TK",
        "TG",
        "PG",
        "PK",
        "PT",
        "PL",
        "PY",
        "PE",
        "TD",
        "CL",
        "CN",
        "DK",
        "DO",
        "CG",
        "CD",
        "KG",
        "HR",
        "KH",
        "CO",
        "KM",
        "KI",
        "CM",
        "KE",
        "CA",
        "CU",
        "GG",
        "GL",
        "GN",
        "GW",
        "GH",
        "GM",
        "HT",
        "HU",
        "UY",
        "HN",
        "YE",
        "GR",
        "UA",
        "UG",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AE", "متحدہ عرب امارات");
    namesMap.put("AF", "افغانستان");
    namesMap.put("AG", "انٹیگوا اور باربودا");
    namesMap.put("AL", "البانیا");
    namesMap.put("AM", "آر مینیا");
    namesMap.put("AN", "نیدرلینڈز انٹیلیز");
    namesMap.put("AO", "انگولا");
    namesMap.put("AQ", "انٹار ٹکا");
    namesMap.put("AR", "ارجنٹینا");
    namesMap.put("AS", "امریکی ساموا");
    namesMap.put("AT", "آسٹریا");
    namesMap.put("AU", "آسٹریلیا");
    namesMap.put("AZ", "آذر بائجان");
    namesMap.put("BA", "بوسنیا ہرزگوینا");
    namesMap.put("BD", "بنگلا دیش");
    namesMap.put("BE", "بیلجئیم");
    namesMap.put("BF", "برکینا فاسو");
    namesMap.put("BG", "بلغاریہ");
    namesMap.put("BI", "برنڈی");
    namesMap.put("BJ", "بینن");
    namesMap.put("BO", "بولیویا");
    namesMap.put("BR", "برازیل");
    namesMap.put("BS", "باھا ماس");
    namesMap.put("BT", "بھوٹان");
    namesMap.put("BV", "جزیرہ بووٹ");
    namesMap.put("BW", "بوٹسوانا");
    namesMap.put("BY", "بیلا رس");
    namesMap.put("CA", "کینیڈا");
    namesMap.put("CC", "جزائر کوکوز");
    namesMap.put("CD", "کانگو، جمہوری ریاست");
    namesMap.put("CF", "جمہوریہ وسطی افریقہ");
    namesMap.put("CG", "کانگو");
    namesMap.put("CH", "سوئزر لینڈ");
    namesMap.put("CK", "جزائر کُک");
    namesMap.put("CL", "چلی");
    namesMap.put("CM", "کیمرون");
    namesMap.put("CN", "چین");
    namesMap.put("CO", "کولمبیا");
    namesMap.put("CS", "سربیا اور مانٹینیگرو");
    namesMap.put("CU", "کیوبا");
    namesMap.put("CX", "جزیرہ کرسمس");
    namesMap.put("CY", "قبرص");
    namesMap.put("CZ", "جمہوریہ چیک");
    namesMap.put("DE", "جرمنی");
    namesMap.put("DK", "ڈنمارک");
    namesMap.put("DO", "ڈومینیکن ریپبلک");
    namesMap.put("DZ", "الجیریا");
    namesMap.put("EC", "ایکواڈور");
    namesMap.put("EE", "ایسٹونیا");
    namesMap.put("EG", "مصر");
    namesMap.put("EH", "مغربی صحارا");
    namesMap.put("ER", "اریٹیریا");
    namesMap.put("ES", "سپین");
    namesMap.put("ET", "ایتھوپیا");
    namesMap.put("FI", "فن لینڈ");
    namesMap.put("FK", "جزائر فاک لینڈ");
    namesMap.put("FM", "مائکرونیزیا");
    namesMap.put("FO", "جزائرفارو");
    namesMap.put("FR", "فرانس");
    namesMap.put("GA", "غیبون");
    namesMap.put("GB", "برطانیہ");
    namesMap.put("GE", "جارجیا");
    namesMap.put("GF", "فرانسیسی گی آنا");
    namesMap.put("GG", "گرنزی");
    namesMap.put("GH", "گھانا");
    namesMap.put("GL", "گرین لینڈ");
    namesMap.put("GM", "گیمبیا");
    namesMap.put("GN", "گنی");
    namesMap.put("GQ", "استوائی گنی");
    namesMap.put("GR", "یونان");
    namesMap.put("GS", "جنوبی جارجیا اور جزائر جنوبی سینڈوچ");
    namesMap.put("GW", "گنی بسائو");
    namesMap.put("HM", "جزیرہ ہرڈ اور جزائر مکڈونلڈ");
    namesMap.put("HN", "ہونڈوراس");
    namesMap.put("HR", "کروشیا");
    namesMap.put("HT", "ہائٹی");
    namesMap.put("HU", "ہنگری");
    namesMap.put("ID", "انڈونیشیا");
    namesMap.put("IE", "آئر لینڈ");
    namesMap.put("IL", "اسرائیل");
    namesMap.put("IN", "بھارت");
    namesMap.put("IO", "بحرھند کا برٹش علاقہ");
    namesMap.put("IQ", "عراق");
    namesMap.put("IR", "ایران");
    namesMap.put("IS", "آئس لینڈ");
    namesMap.put("IT", "اٹلی");
    namesMap.put("JE", "جرسی");
    namesMap.put("JO", "اردن");
    namesMap.put("JP", "جاپان");
    namesMap.put("KE", "کینیا");
    namesMap.put("KG", "کرغستان");
    namesMap.put("KH", "کمبوڈیا");
    namesMap.put("KI", "کِرباتی");
    namesMap.put("KM", "کوموروس");
    namesMap.put("KN", "سینٹ کٹس اور نیوس");
    namesMap.put("KP", "شمالی کوریا");
    namesMap.put("KR", "جنوبی کوریا");
    namesMap.put("KY", "جزائر کیمن");
    namesMap.put("KZ", "قزاقستان");
    namesMap.put("LA", "لاؤس");
    namesMap.put("LB", "لبنان");
    namesMap.put("LC", "سینٹ لوسیا");
    namesMap.put("LI", "لکٹنسٹائن");
    namesMap.put("LK", "سری لنکا");
    namesMap.put("LR", "لائبیریا");
    namesMap.put("LS", "لیسوتھو");
    namesMap.put("LT", "لتھوانیا");
    namesMap.put("LV", "لٹوِیا");
    namesMap.put("LY", "لیبیا");
    namesMap.put("MA", "مراکش");
    namesMap.put("MD", "مالدووا");
    namesMap.put("MG", "مڈغاسکر");
    namesMap.put("MH", "جزائر مارشل");
    namesMap.put("MK", "مقدونیہ");
    namesMap.put("ML", "مالی");
    namesMap.put("MM", "میانمر");
    namesMap.put("MN", "منگولیا");
    namesMap.put("MO", "ماکاؤ");
    namesMap.put("MP", "شمالی ماریاناجزائر");
    namesMap.put("MR", "موریطانیہ");
    namesMap.put("MW", "ملاوی");
    namesMap.put("MX", "میکسیکو");
    namesMap.put("MY", "ملائیشیا");
    namesMap.put("MZ", "موزنبیق");
    namesMap.put("NA", "نمیبیا");
    namesMap.put("NC", "نیو کیلیڈونیا");
    namesMap.put("NE", "نائیجر");
    namesMap.put("NF", "جزیرہ نارفولک");
    namesMap.put("NG", "نائیجیریا");
    namesMap.put("NI", "نکاراگوا");
    namesMap.put("NL", "نیدرلینڈ");
    namesMap.put("NO", "ناروے");
    namesMap.put("NP", "نیپال");
    namesMap.put("NZ", "نیوزی لینڈ");
    namesMap.put("OM", "عمان");
    namesMap.put("PE", "پیرو");
    namesMap.put("PF", "فرانسیسی پولینیسیا");
    namesMap.put("PG", "پاپوا نیو گنی");
    namesMap.put("PH", "فلپائن");
    namesMap.put("PK", "پاکستان");
    namesMap.put("PL", "پولینڈ");
    namesMap.put("PM", "سینٹ پائرے اور میکویلون");
    namesMap.put("PS", "فلسطین");
    namesMap.put("PT", "پرتگال");
    namesMap.put("PY", "پیراگوئے");
    namesMap.put("RO", "رومانیہ");
    namesMap.put("RU", "روس");
    namesMap.put("RW", "روانڈا");
    namesMap.put("SA", "سعودی عرب");
    namesMap.put("SB", "جزائرسولمون");
    namesMap.put("SC", "سے شلز");
    namesMap.put("SD", "سوڈان");
    namesMap.put("SE", "سویڈن");
    namesMap.put("SH", "سینٹ ھیلینا");
    namesMap.put("SI", "سلوانیہ");
    namesMap.put("SK", "سلوواکیہ");
    namesMap.put("SL", "سیرالیون");
    namesMap.put("SM", "سان میرینو");
    namesMap.put("SN", "سینیگال");
    namesMap.put("SO", "صوپالیہ");
    namesMap.put("SR", "سورینام");
    namesMap.put("SY", "سیریا");
    namesMap.put("SZ", "سوازی لینڈ");
    namesMap.put("TC", "جزائر کیکس اور ترکیّہ");
    namesMap.put("TD", "چاڈ");
    namesMap.put("TF", "جنوبی فرانسیسی علاقہ جات");
    namesMap.put("TG", "ٹوگو");
    namesMap.put("TH", "تھائی لینڈ");
    namesMap.put("TJ", "تاجکستان");
    namesMap.put("TK", "ٹوکیلاؤ");
    namesMap.put("TL", "مشرقی تیمور");
    namesMap.put("TM", "ترکمانستان");
    namesMap.put("TN", "تیونس");
    namesMap.put("TO", "تونگا");
    namesMap.put("TR", "ترکی");
    namesMap.put("TT", "ٹرینیڈاڈ اور ٹوباگو");
    namesMap.put("TV", "ٹوالو");
    namesMap.put("TW", "تائیوان");
    namesMap.put("TZ", "تنزانیہ");
    namesMap.put("UA", "یوکرائن");
    namesMap.put("UG", "یوگنڈا");
    namesMap.put("UM", "ریاست ہائے متحدہ اور بیرونی جزائر");
    namesMap.put("US", "ریاست ہائے متحدہ امریکا");
    namesMap.put("UY", "ہوراگوئے");
    namesMap.put("UZ", "ازبکستان");
    namesMap.put("VA", "ویٹیکن سٹی");
    namesMap.put("VC", "سینٹ کیرن اور گریناڈائنز");
    namesMap.put("VE", "وینزولا");
    namesMap.put("VG", "جزائر ورجن، برٹش");
    namesMap.put("VI", "جزائر ورجن، امریکہ");
    namesMap.put("VN", "ویت نام");
    namesMap.put("VU", "وانواٹو");
    namesMap.put("WF", "والس اور فتونہ");
    namesMap.put("WS", "ساموا");
    namesMap.put("YE", "یمن");
    namesMap.put("ZA", "جنوبی افریقہ");
    namesMap.put("ZM", "زیمبیا");
    namesMap.put("ZW", "زمبابوے");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AE": "متحدہ عرب امارات",
        "AF": "افغانستان",
        "AG": "انٹیگوا اور باربودا",
        "AL": "البانیا",
        "AM": "آر مینیا",
        "AN": "نیدرلینڈز انٹیلیز",
        "AO": "انگولا",
        "AQ": "انٹار ٹکا",
        "AR": "ارجنٹینا",
        "AS": "امریکی ساموا",
        "AT": "آسٹریا",
        "AU": "آسٹریلیا",
        "AZ": "آذر بائجان",
        "BA": "بوسنیا ہرزگوینا",
        "BD": "بنگلا دیش",
        "BE": "بیلجئیم",
        "BF": "برکینا فاسو",
        "BG": "بلغاریہ",
        "BI": "برنڈی",
        "BJ": "بینن",
        "BO": "بولیویا",
        "BR": "برازیل",
        "BS": "باھا ماس",
        "BT": "بھوٹان",
        "BV": "جزیرہ بووٹ",
        "BW": "بوٹسوانا",
        "BY": "بیلا رس",
        "CA": "کینیڈا",
        "CC": "جزائر کوکوز",
        "CD": "کانگو، جمہوری ریاست",
        "CF": "جمہوریہ وسطی افریقہ",
        "CG": "کانگو",
        "CH": "سوئزر لینڈ",
        "CK": "جزائر کُک",
        "CL": "چلی",
        "CM": "کیمرون",
        "CN": "چین",
        "CO": "کولمبیا",
        "CS": "سربیا اور مانٹینیگرو",
        "CU": "کیوبا",
        "CX": "جزیرہ کرسمس",
        "CY": "قبرص",
        "CZ": "جمہوریہ چیک",
        "DE": "جرمنی",
        "DK": "ڈنمارک",
        "DO": "ڈومینیکن ریپبلک",
        "DZ": "الجیریا",
        "EC": "ایکواڈور",
        "EE": "ایسٹونیا",
        "EG": "مصر",
        "EH": "مغربی صحارا",
        "ER": "اریٹیریا",
        "ES": "سپین",
        "ET": "ایتھوپیا",
        "FI": "فن لینڈ",
        "FK": "جزائر فاک لینڈ",
        "FM": "مائکرونیزیا",
        "FO": "جزائرفارو",
        "FR": "فرانس",
        "GA": "غیبون",
        "GB": "برطانیہ",
        "GE": "جارجیا",
        "GF": "فرانسیسی گی آنا",
        "GG": "گرنزی",
        "GH": "گھانا",
        "GL": "گرین لینڈ",
        "GM": "گیمبیا",
        "GN": "گنی",
        "GQ": "استوائی گنی",
        "GR": "یونان",
        "GS": "جنوبی جارجیا اور جزائر جنوبی سینڈوچ",
        "GW": "گنی بسائو",
        "HM": "جزیرہ ہرڈ اور جزائر مکڈونلڈ",
        "HN": "ہونڈوراس",
        "HR": "کروشیا",
        "HT": "ہائٹی",
        "HU": "ہنگری",
        "ID": "انڈونیشیا",
        "IE": "آئر لینڈ",
        "IL": "اسرائیل",
        "IN": "بھارت",
        "IO": "بحرھند کا برٹش علاقہ",
        "IQ": "عراق",
        "IR": "ایران",
        "IS": "آئس لینڈ",
        "IT": "اٹلی",
        "JE": "جرسی",
        "JO": "اردن",
        "JP": "جاپان",
        "KE": "کینیا",
        "KG": "کرغستان",
        "KH": "کمبوڈیا",
        "KI": "کِرباتی",
        "KM": "کوموروس",
        "KN": "سینٹ کٹس اور نیوس",
        "KP": "شمالی کوریا",
        "KR": "جنوبی کوریا",
        "KY": "جزائر کیمن",
        "KZ": "قزاقستان",
        "LA": "لاؤس",
        "LB": "لبنان",
        "LC": "سینٹ لوسیا",
        "LI": "لکٹنسٹائن",
        "LK": "سری لنکا",
        "LR": "لائبیریا",
        "LS": "لیسوتھو",
        "LT": "لتھوانیا",
        "LV": "لٹوِیا",
        "LY": "لیبیا",
        "MA": "مراکش",
        "MD": "مالدووا",
        "MG": "مڈغاسکر",
        "MH": "جزائر مارشل",
        "MK": "مقدونیہ",
        "ML": "مالی",
        "MM": "میانمر",
        "MN": "منگولیا",
        "MO": "ماکاؤ",
        "MP": "شمالی ماریاناجزائر",
        "MR": "موریطانیہ",
        "MW": "ملاوی",
        "MX": "میکسیکو",
        "MY": "ملائیشیا",
        "MZ": "موزنبیق",
        "NA": "نمیبیا",
        "NC": "نیو کیلیڈونیا",
        "NE": "نائیجر",
        "NF": "جزیرہ نارفولک",
        "NG": "نائیجیریا",
        "NI": "نکاراگوا",
        "NL": "نیدرلینڈ",
        "NO": "ناروے",
        "NP": "نیپال",
        "NZ": "نیوزی لینڈ",
        "OM": "عمان",
        "PE": "پیرو",
        "PF": "فرانسیسی پولینیسیا",
        "PG": "پاپوا نیو گنی",
        "PH": "فلپائن",
        "PK": "پاکستان",
        "PL": "پولینڈ",
        "PM": "سینٹ پائرے اور میکویلون",
        "PS": "فلسطین",
        "PT": "پرتگال",
        "PY": "پیراگوئے",
        "RO": "رومانیہ",
        "RU": "روس",
        "RW": "روانڈا",
        "SA": "سعودی عرب",
        "SB": "جزائرسولمون",
        "SC": "سے شلز",
        "SD": "سوڈان",
        "SE": "سویڈن",
        "SH": "سینٹ ھیلینا",
        "SI": "سلوانیہ",
        "SK": "سلوواکیہ",
        "SL": "سیرالیون",
        "SM": "سان میرینو",
        "SN": "سینیگال",
        "SO": "صوپالیہ",
        "SR": "سورینام",
        "SY": "سیریا",
        "SZ": "سوازی لینڈ",
        "TC": "جزائر کیکس اور ترکیّہ",
        "TD": "چاڈ",
        "TF": "جنوبی فرانسیسی علاقہ جات",
        "TG": "ٹوگو",
        "TH": "تھائی لینڈ",
        "TJ": "تاجکستان",
        "TK": "ٹوکیلاؤ",
        "TL": "مشرقی تیمور",
        "TM": "ترکمانستان",
        "TN": "تیونس",
        "TO": "تونگا",
        "TR": "ترکی",
        "TT": "ٹرینیڈاڈ اور ٹوباگو",
        "TV": "ٹوالو",
        "TW": "تائیوان",
        "TZ": "تنزانیہ",
        "UA": "یوکرائن",
        "UG": "یوگنڈا",
        "UM": "ریاست ہائے متحدہ اور بیرونی جزائر",
        "US": "ریاست ہائے متحدہ امریکا",
        "UY": "ہوراگوئے",
        "UZ": "ازبکستان",
        "VA": "ویٹیکن سٹی",
        "VC": "سینٹ کیرن اور گریناڈائنز",
        "VE": "وینزولا",
        "VG": "جزائر ورجن، برٹش",
        "VI": "جزائر ورجن، امریکہ",
        "VN": "ویت نام",
        "VU": "وانواٹو",
        "WF": "والس اور فتونہ",
        "WS": "ساموا",
        "YE": "یمن",
        "ZA": "جنوبی افریقہ",
        "ZM": "زیمبیا",
        "ZW": "زمبابوے"
    };
  }-*/;
}
