/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "oc" locale.
 */
public class LocalizedNamesImpl_oc extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AE",
        "AF",
        "AL",
        "DE",
        "AN",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "SA",
        "AR",
        "DZ",
        "AM",
        "AU",
        "AT",
        "AW",
        "AX",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "PW",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BY",
        "MM",
        "BL",
        "BG",
        "BO",
        "BA",
        "BT",
        "BW",
        "BR",
        "BN",
        "BF",
        "BI",
        "KH",
        "CM",
        "CA",
        "CV",
        "KZ",
        "CC",
        "TD",
        "CL",
        "CN",
        "CY",
        "CK",
        "CO",
        "KM",
        "CG",
        "CD",
        "KP",
        "KR",
        "CI",
        "CR",
        "CP",
        "HR",
        "CU",
        "CX",
        "DK",
        "DG",
        "DM",
        "EA",
        "EG",
        "EH",
        "EC",
        "ER",
        "ES",
        "US",
        "EE",
        "ET",
        "FJ",
        "FI",
        "FK",
        "FM",
        "FO",
        "FR",
        "GA",
        "GD",
        "GE",
        "GG",
        "GH",
        "GI",
        "GL",
        "GM",
        "GN",
        "GP",
        "GR",
        "GS",
        "GT",
        "GU",
        "GF",
        "GQ",
        "GW",
        "GY",
        "HK",
        "HM",
        "HN",
        "HT",
        "HU",
        "IC",
        "ID",
        "IE",
        "IM",
        "IN",
        "IO",
        "IQ",
        "IR",
        "IS",
        "BV",
        "KY",
        "IL",
        "IT",
        "JP",
        "JE",
        "DJ",
        "JM",
        "JO",
        "KE",
        "KG",
        "KI",
        "KN",
        "KW",
        "LA",
        "LB",
        "LC",
        "LI",
        "LY",
        "LK",
        "SV",
        "LR",
        "LS",
        "LT",
        "LU",
        "LV",
        "MA",
        "MR",
        "MD",
        "ME",
        "MF",
        "MG",
        "MH",
        "MK",
        "ML",
        "MN",
        "MO",
        "MZ",
        "MC",
        "MP",
        "MQ",
        "MS",
        "MT",
        "MU",
        "MV",
        "MW",
        "MX",
        "MY",
        "NA",
        "NC",
        "NE",
        "NF",
        "NG",
        "NI",
        "NL",
        "NO",
        "NP",
        "NR",
        "NU",
        "NZ",
        "OM",
        "PA",
        "PE",
        "PF",
        "PG",
        "PH",
        "PK",
        "PL",
        "PM",
        "PN",
        "PT",
        "PR",
        "PS",
        "PY",
        "QA",
        "QO",
        "RE",
        "GB",
        "CF",
        "CZ",
        "DO",
        "RO",
        "RS",
        "RU",
        "RW",
        "AS",
        "SB",
        "SC",
        "SD",
        "SE",
        "SG",
        "SH",
        "SI",
        "SJ",
        "SK",
        "SL",
        "SM",
        "SN",
        "SO",
        "CH",
        "SR",
        "ST",
        "SY",
        "SZ",
        "TA",
        "TC",
        "TF",
        "TG",
        "TH",
        "TL",
        "TJ",
        "TK",
        "TM",
        "TN",
        "TO",
        "TR",
        "TT",
        "TV",
        "TW",
        "TZ",
        "UA",
        "UG",
        "UM",
        "EU",
        "UY",
        "UZ",
        "VA",
        "VC",
        "VE",
        "VG",
        "VI",
        "VN",
        "VU",
        "WF",
        "WS",
        "YE",
        "YT",
        "ZA",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("013", "America centrala");
    namesMap.put("053", "Austràlia e Nòva Zelanda");
    namesMap.put("143", "Asia centrala");
    namesMap.put("150", "Euròpa");
    namesMap.put("AD", "Andòrra");
    namesMap.put("AF", "Afganistan");
    namesMap.put("AG", "Antigua e Barbuda");
    namesMap.put("AM", "Armènia");
    namesMap.put("AO", "Angòla");
    namesMap.put("AQ", "Antartica");
    namesMap.put("AS", "Samòa americana");
    namesMap.put("AT", "Àustria");
    namesMap.put("AU", "Austràlia");
    namesMap.put("BA", "Bòsnia e Ercegovina");
    namesMap.put("BE", "Belgica");
    namesMap.put("BG", "Bolgària");
    namesMap.put("BO", "Bolívia");
    namesMap.put("BR", "Brasil");
    namesMap.put("BT", "Botan");
    namesMap.put("BV", "Isla Bouvet");
    namesMap.put("BY", "Bielorussia");
    namesMap.put("CA", "Canadà");
    namesMap.put("CD", "Còngo - Kinshasa");
    namesMap.put("CF", "Republica Centraficana");
    namesMap.put("CG", "Còngo - Brazzaville");
    namesMap.put("CH", "Soïssa");
    namesMap.put("CI", "Còsta d'Evòri");
    namesMap.put("CM", "Cameron");
    namesMap.put("CO", "Colómbia");
    namesMap.put("CR", "Còsta Rica");
    namesMap.put("CV", "Cap Verd");
    namesMap.put("CY", "Chipre");
    namesMap.put("CZ", "Republica chèca");
    namesMap.put("DE", "Alemanha");
    namesMap.put("DJ", "Jiboti");
    namesMap.put("DK", "Danemarc");
    namesMap.put("DO", "Republica dominicana");
    namesMap.put("DZ", "Argeria");
    namesMap.put("EC", "Eqüator");
    namesMap.put("EE", "Estònia");
    namesMap.put("EG", "Egipte");
    namesMap.put("ER", "Eritrèa");
    namesMap.put("ES", "Espanha");
    namesMap.put("ET", "Etiopia");
    namesMap.put("EU", "Union Europèa");
    namesMap.put("FI", "Finlàndia");
    namesMap.put("FR", "França");
    namesMap.put("GB", "Reiaume Unit");
    namesMap.put("GF", "Guiana francesa");
    namesMap.put("GQ", "Guinèa Eqüatoriala");
    namesMap.put("HR", "Croàcia");
    namesMap.put("IL", "Israèl");
    namesMap.put("IN", "Índia");
    namesMap.put("IT", "Itàlia");
    namesMap.put("JP", "Japon");
    namesMap.put("KH", "Cambòja");
    namesMap.put("KM", "Comòros");
    namesMap.put("KP", "Corèa del Nòrd");
    namesMap.put("KR", "Corèa del Sud");
    namesMap.put("KY", "Islas Caiman");
    namesMap.put("KZ", "Cazacstan");
    namesMap.put("LY", "Libia");
    namesMap.put("MA", "Marròc");
    namesMap.put("MC", "Mónegue");
    namesMap.put("MM", "Birmania");
    namesMap.put("MR", "Mauritània");
    namesMap.put("MZ", "Moçambic");
    namesMap.put("PE", "Peró");
    namesMap.put("PW", "Belau");
    namesMap.put("SA", "Arabia Saudita");
    namesMap.put("SV", "Lo Salvador");
    namesMap.put("SY", "Súria");
    namesMap.put("TL", "Timòr Èst");
    namesMap.put("UA", "Ucràina");
    namesMap.put("US", "Estats Units");
    namesMap.put("VE", "Veneçuèla");
    namesMap.put("ZZ", "Desconegut o Region invalida");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "013": "America centrala",
        "053": "Austràlia e Nòva Zelanda",
        "143": "Asia centrala",
        "150": "Euròpa",
        "AD": "Andòrra",
        "AF": "Afganistan",
        "AG": "Antigua e Barbuda",
        "AM": "Armènia",
        "AO": "Angòla",
        "AQ": "Antartica",
        "AS": "Samòa americana",
        "AT": "Àustria",
        "AU": "Austràlia",
        "BA": "Bòsnia e Ercegovina",
        "BE": "Belgica",
        "BG": "Bolgària",
        "BO": "Bolívia",
        "BR": "Brasil",
        "BT": "Botan",
        "BV": "Isla Bouvet",
        "BY": "Bielorussia",
        "CA": "Canadà",
        "CD": "Còngo - Kinshasa",
        "CF": "Republica Centraficana",
        "CG": "Còngo - Brazzaville",
        "CH": "Soïssa",
        "CI": "Còsta d'Evòri",
        "CM": "Cameron",
        "CO": "Colómbia",
        "CR": "Còsta Rica",
        "CV": "Cap Verd",
        "CY": "Chipre",
        "CZ": "Republica chèca",
        "DE": "Alemanha",
        "DJ": "Jiboti",
        "DK": "Danemarc",
        "DO": "Republica dominicana",
        "DZ": "Argeria",
        "EC": "Eqüator",
        "EE": "Estònia",
        "EG": "Egipte",
        "ER": "Eritrèa",
        "ES": "Espanha",
        "ET": "Etiopia",
        "EU": "Union Europèa",
        "FI": "Finlàndia",
        "FR": "França",
        "GB": "Reiaume Unit",
        "GF": "Guiana francesa",
        "GQ": "Guinèa Eqüatoriala",
        "HR": "Croàcia",
        "IL": "Israèl",
        "IN": "Índia",
        "IT": "Itàlia",
        "JP": "Japon",
        "KH": "Cambòja",
        "KM": "Comòros",
        "KP": "Corèa del Nòrd",
        "KR": "Corèa del Sud",
        "KY": "Islas Caiman",
        "KZ": "Cazacstan",
        "LY": "Libia",
        "MA": "Marròc",
        "MC": "Mónegue",
        "MM": "Birmania",
        "MR": "Mauritània",
        "MZ": "Moçambic",
        "PE": "Peró",
        "PW": "Belau",
        "SA": "Arabia Saudita",
        "SV": "Lo Salvador",
        "SY": "Súria",
        "TL": "Timòr Èst",
        "UA": "Ucràina",
        "US": "Estats Units",
        "VE": "Veneçuèla",
        "ZZ": "Desconegut o Region invalida"
    };
  }-*/;
}
