/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.jsonp.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.jsonp.client.JsonpRequest;
import com.google.gwt.user.client.rpc.AsyncCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonpRequestBuilder {
    private int timeout = 10000;
    private String callbackParam = "callback";
    private String failureCallbackParam = null;
    private String predeterminedId = null;

    public String getCallbackParam() {
        return this.callbackParam;
    }

    public String getFailureCallbackParam() {
        return this.failureCallbackParam;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public JsonpRequest<Boolean> requestBoolean(String url, AsyncCallback<Boolean> callback) {
        return this.send(url, callback, false);
    }

    public JsonpRequest<Double> requestDouble(String url, AsyncCallback<Double> callback) {
        return this.send(url, callback, false);
    }

    public JsonpRequest<Integer> requestInteger(String url, AsyncCallback<Integer> callback) {
        return this.send(url, callback, true);
    }

    public <T extends JavaScriptObject> JsonpRequest<T> requestObject(String url, AsyncCallback<T> callback) {
        return this.send(url, callback, false);
    }

    public JsonpRequest<String> requestString(String url, AsyncCallback<String> callback) {
        return this.send(url, callback, false);
    }

    public void send(String url) {
        this.send(url, null, false);
    }

    public JsonpRequest<Void> send(String url, AsyncCallback<Void> callback) {
        return this.send(url, callback, false);
    }

    public void setCallbackParam(String callbackParam) {
        this.callbackParam = callbackParam;
    }

    public void setFailureCallbackParam(String failureCallbackParam) {
        this.failureCallbackParam = failureCallbackParam;
    }

    public void setPredeterminedId(String id) {
        this.predeterminedId = id;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    private <T> JsonpRequest<T> send(String url, AsyncCallback<T> callback, boolean expectInteger) {
        JsonpRequest<T> request = this.predeterminedId != null ? new JsonpRequest<T>(callback, this.timeout, expectInteger, this.callbackParam, this.failureCallbackParam, this.predeterminedId) : new JsonpRequest<T>(callback, this.timeout, expectInteger, this.callbackParam, this.failureCallbackParam);
        request.send(url);
        return request;
    }
}

