// Copyright (c) 2006   INRIA Sophia-Antipolis (France).
// All rights reserved.
//
// This file is part of CGAL (www.cgal.org); you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; version 2.1 of the License.
// See the file LICENSE.LGPL distributed with CGAL.
//
// Licensees holding a valid commercial license may use this file in
// accordance with the commercial license agreement provided with the software.
//
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
// $URL: svn+ssh://scm.gforge.inria.fr/svn/cgal/branches/CGAL-3.3-branch/Testsuite/include/CGAL/Testsuite/assert.h $
// $Id: assert.h 34910 2006-10-24 15:21:25Z ameyer $
//
// Author(s)     : Sylvain Pion

#ifndef CGAL_TESTSUITE_ASSERT_H
#define CGAL_TESTSUITE_ASSERT_H

#include <CGAL/assertions.h>

// CGAL_test_assert() is a macro similar to assert(),
// except that NDEBUG and other macros do not affect it.

#define CGAL_test_assert(EX) \
   ((EX)?(static_cast<void>(0)): ::CGAL::assertion_fail( # EX , __FILE__, __LINE__, 0))

#define CGAL_test_assert_msg(EX,MSG) \
   ((EX)?(static_cast<void>(0)): ::CGAL::assertion_fail( # EX , __FILE__, __LINE__, MSG))

#endif // CGAL_TESTSUITE_ASSERT_H
