@echo off
rem "This batchfile runs the Charva test program."
rem "It is intended to be run from the '%CHARVA_HOME%\java\src' 
rem "directory in a DOS command shell."
rem "It expects to find Terminal.dll in the directory
rem '%CHARVA_HOME%\c\src', and the charva.jar file in the directory
rem '%CHARVA_HOME%\java\lib'.
rem "Last Modified: 2003/7/25 by Rob Pitman <rob@pitman.co.za>"

rem Check that we are in the right directory to run this script.
if not exist "..\..\c\src\Terminal.dll" goto noDLL
if not exist "..\..\java\lib\charva.jar" goto noJAR

rem JAVA_HOME must be set to the JDK or JRE installation directory 
rem (for example, C:\jdk1.4 or C:\jre1.4)
set JAVA_HOME=C:\j2sdk1.4.1_01

rem Uncomment the next line to log keystrokes and debug key-mappings 
rem (the script file is %HOME%\script.charva).
rem set TEST_OPTS="-Dcharva.script.record=%HOME%/script.charva"

rem Uncomment the following option to test for memory leaks.
rem set TEST_OPTS=-Xrunhprof:heap=sites

%JAVA_HOME%\bin\java %TEST_OPTS% -cp ../classes;../lib/charva.jar -Djava.library.path=..\..\c\src -Duser.home="%HOME%" tutorial.charva.Tutorial
goto end


:noDLL
echo The Terminal.dll library is not available!
goto end

:noJAR
echo The charva.jar file is not available!
goto end

:end
