/****************************************************************************
**
** Copyright (C) 2002-2006 Tilo Riemer <riemer@crossvc.com>,
**                         Frank Hemer <frank@hemer.at>,
**                         Jose Hernandez <joseh@tesco.net> and
**                         Joerg Preiss <auba@auba.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** CrossVC is available under two different licenses:
**
** If CrossVC is linked against the GPLed version of Qt 
** CrossVC is released under the terms of GPL also.
**
** If CrossVC is linked against a nonGPLed version of Qt 
** CrossVC is released under the terms of the 
** CrossVC License for non-Unix platforms (CLNU)
**
**
** CrossVC License for non-Unix platforms (CLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than CrossVC.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** CrossVC License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation, version 2 of the License.
** This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License version 2 for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/


#include "config.h"

//----------------------------------------------------------------------------

#include <qregexp.h>

//----------------------------------------------------------------------------

#include "globals.h"
#include "cvsconfig_old.h"

//----------------------------------------------------------------------------

const char CvsConfigOld::Version[]                 = "/lincvs/Version";
const char CvsConfigOld::Debug[]                   = "/lincvs/Debug";
const char CvsConfigOld::LogLevel[]                = "/lincvs/LogLevel";
const char CvsConfigOld::CheckStatusIntervall[]    = "/lincvs/Timer/checkStatusIntervall";
const char CvsConfigOld::CheckStatusLevel[]        = "/lincvs/Timer/checkStatusLevel";
const char CvsConfigOld::ProgressIntervall[]       = "/lincvs/Timer/progressIntervall";

const char CvsConfigOld::AutoUpdate[]              = "/lincvs/AutoUpdate/Enabled";
const char CvsConfigOld::AutoUpdateIntervall[]     = "/lincvs/AutoUpdate/Intervall";

const char CvsConfigOld::cvsPassFile[]             = "/lincvs/CvsPassFilePath";
const char CvsConfigOld::cvsPath[]                 = "/lincvs/CvsPath";
const char CvsConfigOld::cvsVersion[]              = "/lincvs/CvsVersion";
const char CvsConfigOld::useDirWatch[]             = "/lincvs/useDirWatch";

const char CvsConfigOld::SshKeyList[]              = "/lincvs/SshKeyList";
const char CvsConfigOld::SshAgent[]                = "/lincvs/SshAgent";
const char CvsConfigOld::RemoteBrowser[]           = "/lincvs/remoteBrowser";
const char CvsConfigOld::LocalBrowser[]            = "/lincvs/localBrowser";
const char CvsConfigOld::CVSRsh[]                  = "/lincvs/cvsRsh";
const char CvsConfigOld::LocalShell[]              = "/lincvs/localShell";
const char CvsConfigOld::DirPopupMenu[]            = "/lincvs/dirPopupMenu";
const char CvsConfigOld::FilePopupMenu[]           = "/lincvs/filePopupMenu";
const char CvsConfigOld::KeyboarsShortcuts[]       = "/lincvs/keyboardShortcuts";
const char CvsConfigOld::OpenFileList[]            = "/lincvs/openFileList";
const char CvsConfigOld::ViewFileList[]            = "/lincvs/viewFileList";
const char CvsConfigOld::ScanOnTheFly[]            = "/lincvs/scanOnTheFly";
const char CvsConfigOld::ScanNonCvs[]              = "/lincvs/scanNonCvs";
const char CvsConfigOld::CvsIgnoreFiles[]          = "/lincvs/cvsIgnoreFiles";
const char CvsConfigOld::BinaryFileSpecList[]      = "/lincvs/binaryFileSpec";
const char CvsConfigOld::UseExternalDiff[]         = "/lincvs/useExternalDiffForSideBySide";
const char CvsConfigOld::ExtDiffProgram[]          = "/lincvs/externalDiffProgram";
const char CvsConfigOld::HistSizeComments[]        = "/lincvs/historySizeComments";
const char CvsConfigOld::HistSizeWorkdirs[]        = "/lincvs/historySizeWorkdirs";
const char CvsConfigOld::HistSizeProfiles[]        = "/lincvs/historySizeProfiles";

const char CvsConfigOld::GeomX[]                   = "/lincvs/Geometry/geomX";
const char CvsConfigOld::GeomY[]                   = "/lincvs/Geometry/geomY";
const char CvsConfigOld::GeomWidth[]               = "/lincvs/Geometry/geomWidth";
const char CvsConfigOld::GeomHeight[]              = "/lincvs/Geometry/geomHeight";
const char CvsConfigOld::SplitterPosH[]            = "/lincvs/Geometry/splitterPosH";
const char CvsConfigOld::SplitterPosV[]            = "/lincvs/Geometry/splitterPosV";
const char CvsConfigOld::WorkbenchColumnWidth[]    = "/lincvs/Geometry/workbenchColumnWidth";
const char CvsConfigOld::ToolbarPos[]              = "/lincvs/Geometry/ToolbarPosition";
const char CvsConfigOld::FileHeaderPos[]           = "/lincvs/Geometry/FileHeaderPosition";

const char CvsConfigOld::IconDir[]                 = "/lincvs/Looknfeel/iconDir";
const char CvsConfigOld::ColorRevA[]               = "/lincvs/Looknfeel/colorRevisionA";
const char CvsConfigOld::ColorRevB[]               = "/lincvs/Looknfeel/colorRevisionB";
const char CvsConfigOld::UseStandardDialogs[]      = "/lincvs/Looknfeel/useStdDialogs";
const char CvsConfigOld::DateTimeOrder[]           = "/lincvs/Looknfeel/DateTimeOrder";
const char CvsConfigOld::DateTimeFormat[]          = "/lincvs/Looknfeel/DateTimeFormat";
const char CvsConfigOld::Use0AsParent[]            = "/lincvs/Looknfeel/use0AsParent";
const char CvsConfigOld::TopLevelWidget[]          = "/lincvs/Looknfeel/topLevelWidget";

const char CvsConfigOld::Compression[]             = "/lincvs/CvsGlobal/compression";
const char CvsConfigOld::RwPermission[]            = "/lincvs/CvsGlobal/RwPermission";
const char CvsConfigOld::VirtualInFiletab[]        = "/lincvs/CvsGlobal/virtualInFileTab";
const char CvsConfigOld::DiffPrecision[]           = "/lincvs/CvsGlobal/diffPrecision";
const char CvsConfigOld::UnifiedDiffOutput[]       = "/lincvs/CvsGlobal/unifiedDiffOutput";

const char CvsConfigOld::PruneDirs[]               = "/lincvs/CvsSubcommands/pruneDirs";
const char CvsConfigOld::BringOverNewDirs[]        = "/lincvs/CvsSubcommands/bringOverNewDirs";
const char CvsConfigOld::KeywordSuppression[]      = "/lincvs/CvsSubcommands/keywordSuppression";
const char CvsConfigOld::IgnoreWhiteSpace[]        = "/lincvs/CvsSubcommands/diffIgnoreWhiteSpace";
const char CvsConfigOld::HistoryPeriod[]           = "/lincvs/CvsSubcommands/historyPeriod";
const char CvsConfigOld::Quiet[]                   = "/lincvs/CvsSubcommands/quiet";

const char CvsConfigOld::UserList[]                = "/lincvs/CvsServer/users";
const char CvsConfigOld::ServerList[]              = "/lincvs/CvsServer/servers";
const char CvsConfigOld::RepositoryList[]          = "/lincvs/CvsServer/repositories";
const char CvsConfigOld::ProfileList[]             = "/lincvs/CvsServer/profiles";
const char CvsConfigOld::XProfileList[]            = "/lincvs/CvsServer/xprofiles";
const char CvsConfigOld::ModuleList[]              = "/lincvs/CvsServer/modules";
const char CvsConfigOld::WorkdirList[]             = "/lincvs/CvsServer/workDirs";
const char CvsConfigOld::CheckoutAsList[]          = "/lincvs/CvsServer/checkoutAs";
const char CvsConfigOld::ProxyList[]               = "/lincvs/CvsServer/proxys";

const char CvsConfigOld::Projects[]                = "/lincvs/Projects";

const char CvsConfigOld::UseSyntaxHighlight[]      = "/lincvs/SyntaxHighlight/UseSyntaxHighlight";
const char CvsConfigOld::SynHighQuestionMarkStyle[]= "/lincvs/SyntaxHighlight/SynHighQuestionMarkStyle";
const char CvsConfigOld::SynHighQuestionMarkRgb[]  = "/lincvs/SyntaxHighlight/SynHighQuestionMarkRgb";
const char CvsConfigOld::SynHighModifiedStyle[]    = "/lincvs/SyntaxHighlight/SynHighModifiedStyle";
const char CvsConfigOld::SynHighModifiedRgb[]      = "/lincvs/SyntaxHighlight/SynHighModifiedRgb";
const char CvsConfigOld::SynHighNeedsUpdateStyle[] = "/lincvs/SyntaxHighlight/SynHighNeedsUpdateStyle";
const char CvsConfigOld::SynHighNeedsUpdateRgb[]   = "/lincvs/SyntaxHighlight/SynHighNeedsUpdateRgb";
const char CvsConfigOld::SynHighMergingStyle[]     = "/lincvs/SyntaxHighlight/SynHighMergingStyle";
const char CvsConfigOld::SynHighMergingRgb[]       = "/lincvs/SyntaxHighlight/SynHighMergingRgb";
const char CvsConfigOld::SynHighConflictStyle[]    = "/lincvs/SyntaxHighlight/SynHighConflictStyle";
const char CvsConfigOld::SynHighConflictRgb[]      = "/lincvs/SyntaxHighlight/SynHighConflictRgb";
const char CvsConfigOld::SynHighAddedStyle[]       = "/lincvs/SyntaxHighlight/SynHighAddedStyle";
const char CvsConfigOld::SynHighAddedRgb[]         = "/lincvs/SyntaxHighlight/SynHighAddedRgb";
const char CvsConfigOld::SynHighRemovedStyle[]     = "/lincvs/SyntaxHighlight/SynHighRemovedStyle";
const char CvsConfigOld::SynHighRemovedRgb[]       = "/lincvs/SyntaxHighlight/SynHighRemovedRgb";
const char CvsConfigOld::SynHighRemovedByOtherStyle[]= "/lincvs/SyntaxHighlight/SynHighRemovedByOtherStyle";
const char CvsConfigOld::SynHighRemovedByOtherRgb[]  = "/lincvs/SyntaxHighlight/SynHighRemovedByOtherRgb";
const char CvsConfigOld::SynHighDiffOldStyle[]     = "/lincvs/SyntaxHighlight/SynHighDiffOldStyle";
const char CvsConfigOld::SynHighDiffOldRgb[]       = "/lincvs/SyntaxHighlight/SynHighDiffOldRgb";
const char CvsConfigOld::SynHighDiffNewStyle[]     = "/lincvs/SyntaxHighlight/SynHighDiffNewStyle";
const char CvsConfigOld::SynHighDiffNewRgb[]       = "/lincvs/SyntaxHighlight/SynHighDiffNewRgb";
const char CvsConfigOld::SynHighScmErrStyle[]      = "/lincvs/SyntaxHighlight/SynHighScmErrStyle";
const char CvsConfigOld::SynHighScmErrRgb[]        = "/lincvs/SyntaxHighlight/SynHighScmErrRgb";

const char CvsConfigOld::FontGeneral[]             = "/lincvs/Font/General";
const char CvsConfigOld::FontMessage[]             = "/lincvs/Font/Message";
const char CvsConfigOld::FontDiff[]                = "/lincvs/Font/Diff";

const char CvsConfigOld::TextEncoder[]             = "/lincvs/I18n/TextEncoder";
const char CvsConfigOld::TextDecoder[]             = "/lincvs/I18n/TextDecoder";

#ifdef Q_WS_MAC
const char CvsConfigOld::defCvsPath[]              = "ocvs";
const char CvsConfigOld::defCvsVersion[]           = "cvs";
const char CvsConfigOld::defSshAgent[]             = "start-ssh-agent.sh\n%n";
const char CvsConfigOld::defRemoteBrowser[]        = "open";
const char CvsConfigOld::defLocalBrowser[]         = "open";
const char CvsConfigOld::defOpenFileList[]         = "*\nopen\n%n\n-";
const char CvsConfigOld::defViewFileList[]         = "*\nopen\n%n\n-";
const char CvsConfigOld::defLocalShell[]           = "/Applications/Utilities/Terminal";
#else
#ifdef Q_WS_X11
const char CvsConfigOld::defCvsPath[]              = "cvs";
const char CvsConfigOld::defCvsVersion[]           = "cvs";
const char CvsConfigOld::defSshAgent[]             = "start-ssh-agent.sh\n%n";
const char CvsConfigOld::defRemoteBrowser[]        = "mozilla";
const char CvsConfigOld::defLocalBrowser[]         = "mozilla";
const char CvsConfigOld::defOpenFileList[]         = "*\nxterm\n-e vi %1\n-";
const char CvsConfigOld::defViewFileList[]         = "*\nxterm\n-e more %1\n-";
const char CvsConfigOld::defLocalShell[]           = "xterm";
#else
#ifdef Q_WS_QWS
const char CvsConfigOld::defCvsPath[]              = "cvs";
const char CvsConfigOld::defCvsVersion[]           = "cvs";
const char CvsConfigOld::defSshAgent[]             = "";
const char CvsConfigOld::defRemoteBrowser[]        = "";
const char CvsConfigOld::defLocalBrowser[]         = "";
const char CvsConfigOld::defOpenFileList[]         = "";
const char CvsConfigOld::defViewFileList[]         = "";
const char CvsConfigOld::defLocalShell[]           = "";
#endif
#endif
#endif
const char CvsConfigOld::defCvsRsh[]               = "ssh";
const char CvsConfigOld::defCvsIgnoreFiles[]       = "RCS SCCS CVS CVS.adm RCSLOG cvslog.* tags TAGS .make.state .nse.depinfo *~ #* .#* ,* _$* *$ *.old *.bak *.BAK *.orig *.rej .del-* *.a *.olb *.o *.obj *.so *.exe *.Z *.elc *.ln core";

#ifdef Q_WS_MAC
const char CvsConfigOld::defKeyboarsShortcuts[]     = "4,12582980:7,8388677:8,4194373:10,4194392:11,4194376:12,12582984:15,8388684:16,4194384:18,8388689:25,4194386:29,4194388:30,8388692:33,4194389:34,8388693:46,12582991:47,4194370:48,4194387:54,4194371:55,8388694:59,4194372:83,4194385:";
#else
const char CvsConfigOld::defKeyboarsShortcuts[]     = "4,12582980:7,8388677:8,4194373:10,4194392:11,4194376:12,12582984:15,8388684:16,4194384:18,8388689:25,4194386:29,4194388:30,8388692:33,4194389:34,8388693:46,12582991:47,4194370:48,4194387:54,4194371:55,8388694:59,4194372:62,4194385:";
#endif

//----------------------------------------------------------------------------

/*!	Initialize the cvs configuration with the default values.
  \brief c'tor
*/
#ifndef Q_WS_WIN
CvsConfigOld::CvsConfigOld()
{
   m_pSettings = new QSettings();
#ifdef Q_WS_X11
   if (!Misc::g_rcPath.isEmpty()) m_pSettings->insertSearchPath(QSettings::Unix, Misc::g_rcPath);
#endif
#ifdef Q_WS_MAC
   m_pSettings->setPath("lincvs.com", "LinCVS", QSettings::User);
#endif
   readCfg();
}
#endif
//----------------------------------------------------------------------------

/*!	Free all resources.
  \brief d'tor
*/
CvsConfigOld::~CvsConfigOld()
{
   delete m_pSettings;
}

//----------------------------------------------------------------------------

void CvsConfigOld::readCfg()
{
   /*! Section external apps */
   readExtApps();
   
   /*! Section GENERAL */
   DIRPOPUPMENU  = dirPopupMenu(); 
   FILEPOPUPMENU = filePopupMenu();
   KEYBOARDSHORTCUTS = getKeyboardShortcuts();
   Mapping::openFileAppList = extractMapping(getOpenFileList());
   Mapping::viewFileAppList = extractMapping(getViewFileList());

   if (bOVERRIDEONTHEFLYSCANNING) {//startup option
      ONTHEFLYSCANNING = true;
   } else {
      ONTHEFLYSCANNING = getOnTheFlyScanning();
   }
   bSCANNONCVS = getScanNonCvs();
   CVSIGNOREFILES = cvsIgnoreFiles();
   BINARYFILESPECLIST = getBinaryFileSpecList();

   bUSEEXTERNALDIFFFORSIDEBYSIDE = useExtDiff(); 

   Debug::g_bDebug         = debug();
   Debug::g_logLevel       = logLevel();
   DirWatch::b_useDirWatch = getUseDirWatch();
   CVSVERSION              = getCvsVersion();
   CVSPATH                 = getCvsPath();
   CVSPASSPATH             = getCvsPassPath();

   /*! Section TIMER */
   CHECKSTATUSINTERVALL = checkStatusIntervall();
   Polling::checkStatusLevel = getCheckStatusLevel();
   PROGRESSINTERVALL    = progressIntervall();

   /*! Section AutoUpdate */
   AUTOUPDATE = getAutoUpdate();
   AUTOUPDATEINTERVALL = getAutoUpdateIntervall();

   HistorySize::g_workdirs   = historySizeWorkdirs();
   HistorySize::g_profiles   = historySizeProfiles();
   HistorySize::g_commitinfo = historySizeComments();

   iconDir = iconDirectory();

   int rgbColor = colorRev(false);   //Revision A
   SELECTION_COLOR_OF_LOGDLG[0] = QColor(rgbColor);
   rgbColor = colorRev(true);        //Revision B
   SELECTION_COLOR_OF_LOGDLG[1] = QColor(rgbColor);

   /*! Section LookAndFeel */
   LookAndFeel::g_stdDlg = getStdDlg();
   LookAndFeel::g_dateTimeOrder = static_cast<QDateEdit::Order>(getDateTimeOrder());
   LookAndFeel::g_dateTimeFormat = getDateTimeFormat();
   LookAndFeel::g_b0AsParent = get0AsParent();
   LookAndFeel::g_bTopLevel = getTopLevelW();

   /*! SECTION GEOMETRY */
   QRect geom        = geometry();
   GEOM_X            = geom.x();
   GEOM_Y            = geom.y();
   GEOM_WIDTH        = geom.width();
   GEOM_HEIGHT       = geom.height();

   SPLITTER_POS_H    = splitterPosH();
   SPLITTER_POS_V    = splitterPosV();
   WORKBENCH_COLUMN_WIDTH           = workbenchColumnWidth();
   TOOLBARPOS                          = getToolbarPos();
   SizeProperties::g_fileHeader = getFileHeaderPos();

   /*! SECTION SyntaxHighlight */
   HighlightProperties::g_bUseSyntaxHighlighting   = getUseSyntaxHighlighting();
   HighlightProperties::g_updateQuestionMark.style = getQuestionMarkStyle();
   HighlightProperties::g_updateQuestionMark.color = getQuestionMarkColor();
   HighlightProperties::g_updateModified.style     = getModifiedStyle();
   HighlightProperties::g_updateModified.color     = getModifiedColor();
   HighlightProperties::g_updateNeedsUpdate.style  = getNeedsUpdateStyle();
   HighlightProperties::g_updateNeedsUpdate.color  = getNeedsUpdateColor();
   HighlightProperties::g_updateMerging.style      = getMergingStyle();
   HighlightProperties::g_updateMerging.color      = getMergingColor();
   HighlightProperties::g_updateConflict.style     = getConflictStyle();
   HighlightProperties::g_updateConflict.color     = getConflictColor();
   HighlightProperties::g_updateAdded.style        = getAddedStyle();
   HighlightProperties::g_updateAdded.color        = getAddedColor();
   HighlightProperties::g_updateRemoved.style      = getRemovedStyle();
   HighlightProperties::g_updateRemoved.color      = getRemovedColor();
   HighlightProperties::g_updateRemovedByOther.style = getRemovedByOtherStyle();
   HighlightProperties::g_updateRemovedByOther.color = getRemovedByOtherColor();
   HighlightProperties::g_diffOld.style            = getDiffOldStyle();
   HighlightProperties::g_diffOld.color            = getDiffOldColor();
   HighlightProperties::g_diffNew.style            = getDiffNewStyle();
   HighlightProperties::g_diffNew.color            = getDiffNewColor();
   HighlightProperties::g_scmErr.style             = getScmErrStyle();
   HighlightProperties::g_scmErr.color             = getScmErrColor();

   /*! SECTION Font */
   Font::g_general = getFontGeneral();
   Font::g_message = getFontMessage();
   Font::g_diff    = getFontDiff();
    
   /*! SECTION I18n */
   I18n::g_nameOfEncoder = getTextEncoder();
   I18n::g_nameOfDecoder = getTextDecoder();

   /*! SECTION CvsGlobal */
   CvsOptions::g_compression = compression();
   bRWPermission = rwPermission();
   CvsOptions::g_bShowVirtualInFiletab = getShowVirtualInFiletab();
   CvsOptions::g_precision = getDiffPrecision();
   CvsOptions::g_bUnifiedDiffOutput = getUnifiedDiffOutput();

   /*! SECTION CvsSubcommands */
   CvsOptions::g_bPruneDirs = pruneDirs();
   CvsOptions::g_bBringOverNewDirs = bringOverNewDirs();
   bKeywordSuppression = keywordSuppression();
   bDiffIgnoreWhiteSpace = getIgnoreWhiteSpace();
   CvsOptions::g_historyPeriod = getHistoryPeriod();
   CvsOptions::g_bQuietCvs = getQuiet();

   /*! SECTION CvsServer */
   cvsUsers           = userList();
   cvsServers         = serverList();
   cvsRepositories    = repositoryList();
   MODULEHISTORYLIST  = moduleList();
   WORKDIRHISTORYLIST = workdirList();  //list of locale dirs of working copy
   CHECKOUTASLIST     = getCheckoutAsList();
   proxyList          = getProxyList();

   //read profile list, generate *namelist and *contentlist...
   readProfiles(xprofileList());

   simplifyStringList(&cvsServers);
   simplifyStringList(&cvsRepositories);
   simplifyStringList(&cvsUsers);
   simplifyStringList(&MODULEHISTORYLIST);
   simplifyStringList(&WORKDIRHISTORYLIST);

   //project settings
   if (!bStartedInDir) {//startup option
      readProjectSettings( Projects);
   }

   QString lastVersion = m_pSettings->readEntry(Version, "");
   if (lastVersion < getVersion()) {
      updateVersionOnRead(lastVersion,getVersion());
   } else {
      m_needUpdate = FALSE;
   }
}

//----------------------------------------------------------------------------

void CvsConfigOld::readProjectSettings( QString projectPath) {
    
    unsigned int i = 0;
    QStringList projectList = m_pSettings->subkeyList( projectPath);
    
    if (projectList.isEmpty()) {//fallback to old project settings model, will be removed in near future
        
        QStringList projectNameList     = m_pSettings->readListEntry("/lincvs/Workbench/projectList");
        QStringList projectDisabledList = m_pSettings->readListEntry("/lincvs/Workbench/projectDisabledList");
        
        for( i = 0; i < projectNameList.count(); i++) {
            
            QString projectName = projectNameList[i].mid(projectNameList[i].findRev("/")+1);
            projectSettings->set( projectName,WORKDIR,projectNameList[i]);
            
            QStringList::iterator it;
            QStringList disabled;
            for ( it = projectDisabledList.begin(); it != projectDisabledList.end(); ++it ) {
                if ((*it).startsWith(projectNameList[i]) &&
                    ( ((*it).length() == projectNameList[i].length()) ||
                      ((*it).at(projectNameList[i].length())=='/'))) {
                    
                    disabled.append(*it);
                    
                }
            }
            projectSettings->set( projectName,DISABLED,disabled);
        }
        return;
    }
    
    projectSettings->readFromSettings( m_pSettings, projectPath);
}

//----------------------------------------------------------------------------

/* Called on reading the settings. If m_needUpdate is set to true here,
 * updateVersionOnWrite() will be called on writing the settings.
 * For the versionString to be updated, m_needUpdate needs to be
 * set to true here.
 */
void CvsConfigOld::updateVersionOnRead( const QString& oldVersion, const QString& newVersion) {

   qDebug(QObject::tr("Detected old LinCVS resource file")
	 +",\n"
	 + QObject::tr("updating from LinCVS version: ")
	 +QString(oldVersion.isEmpty() ? QObject::tr("unknown") : oldVersion)
	 +"\n"
	 +QObject::tr("to new version: ")+newVersion);

   m_needUpdate = FALSE;
   bool updated = FALSE;

   if (oldVersion <= QString("1.3.1")) {
      qDebug(QObject::tr("Update in progress"));
    
      readProfiles(profileList());  // read old profiles list
      simplifyStringList(&cvsServers);
      simplifyStringList(&cvsRepositories);
      simplifyStringList(&cvsUsers);

      m_needUpdate = TRUE;
      updated = TRUE;
   }
   if (oldVersion < QString("1.4.0")) {//change to new values on release here
      m_needUpdate = TRUE;
   }

   /* as long as the settings format has not changed, the next lines might be adapted
    * to the new values. Otherwise, the update requires a separat section as see above
    */
//    if (oldVersion < QString("1.4.1")) {//change to new values on release here
//       m_needUpdate = TRUE;
//    }

   if (!updated) qDebug(QObject::tr("No update required"));

}

//----------------------------------------------------------------------------

void CvsConfigOld::readExtApps()
{
   QString tmpExtApp;
   int pos;

   ExtApps::g_sshKeyFiles = getSshKeyList();
    
   tmpExtApp = sshAgent(); pos = tmpExtApp.find("\n");
   if (pos >= 0) {
      ExtApps::g_sshAgent.path = tmpExtApp.left(pos).stripWhiteSpace();
      ExtApps::g_sshAgent.options = tmpExtApp.right(tmpExtApp.length() - pos).stripWhiteSpace();
   } else {
      ExtApps::g_sshAgent.path = tmpExtApp.stripWhiteSpace();
      ExtApps::g_sshAgent.options = QString::null;
   }
      
   tmpExtApp = localShell(); pos = tmpExtApp.find("\n");
   if (pos >= 0) {
      ExtApps::g_localShell.path = tmpExtApp.left(pos).stripWhiteSpace();
      ExtApps::g_localShell.options = tmpExtApp.right(tmpExtApp.length() - pos).stripWhiteSpace();
   } else {
      ExtApps::g_localShell.path = tmpExtApp.stripWhiteSpace();
      ExtApps::g_localShell.options = QString::null;
   }
   tmpExtApp = localBrowser(); pos = tmpExtApp.find("\n");
   if (pos >= 0) {
      ExtApps::g_localBrowser.path = tmpExtApp.left(pos).stripWhiteSpace();
      ExtApps::g_localBrowser.options = tmpExtApp.right(tmpExtApp.length() - pos).stripWhiteSpace();
   } else {
      ExtApps::g_localBrowser.path = tmpExtApp.stripWhiteSpace();
      ExtApps::g_localBrowser.options = QString::null;
   }
   
   tmpExtApp = remoteBrowser(); pos = tmpExtApp.find("\n");
   if (pos >= 0) {
      ExtApps::g_remoteBrowser.path = tmpExtApp.left(pos).stripWhiteSpace();
      ExtApps::g_remoteBrowser.options = tmpExtApp.right(tmpExtApp.length() - pos).stripWhiteSpace();
   } else {
      ExtApps::g_remoteBrowser.path = tmpExtApp.stripWhiteSpace();
      ExtApps::g_remoteBrowser.options = QString::null;
   }

   tmpExtApp = CvsRsh(); pos = tmpExtApp.find("\n");
   if (pos >= 0) {
      ExtApps::g_cvsRsh.path = tmpExtApp.left(pos).stripWhiteSpace();
      ExtApps::g_cvsRsh.options = tmpExtApp.right(tmpExtApp.length() - pos).stripWhiteSpace();
   } else {
      ExtApps::g_cvsRsh.path = tmpExtApp.stripWhiteSpace();
      ExtApps::g_cvsRsh.options = QString::null;
   }
   //at the moment we don't use options for cvsRsh
   ExtApps::g_cvsRsh.options = QString::null;

   tmpExtApp = extDiffProgram(); pos = tmpExtApp.find("\n");
   if (pos >= 0) {
      ExtApps::g_diffProg.path = tmpExtApp.left(pos).stripWhiteSpace();
      ExtApps::g_diffProg.options = tmpExtApp.right(tmpExtApp.length() - pos).stripWhiteSpace();
   } else {
      ExtApps::g_diffProg.path = tmpExtApp.stripWhiteSpace();
      ExtApps::g_diffProg.options = QString::null;
   }
}

//----------------------------------------------------------------------------

Mapping::FileAppList CvsConfigOld::extractMapping(const QStringList & src) {
   Mapping::FileAppList dst;
   QStringList::ConstIterator it;
   for (it = src.begin(); it != src.end(); ++it) {
      Mapping::FileAppItem item;
      int pos1 = (*it).find('\n');
      int pos2 = (*it).find('\n',pos1+1);
      int pos3 = (*it).find('\n',pos2+1);
      item.wildcard = (*it).mid(0,pos1);
      item.app = (*it).mid(pos1+1,pos2-pos1-1);
      item.params = (*it).mid(pos2+1,pos3-pos2-1);
      if ((*it).at( pos3+1) == '+') item.isRegExp = TRUE;
      else item.isRegExp = FALSE;
      dst.append(item);
   }
   return dst;
}

//----------------------------------------------------------------------------

QStringList CvsConfigOld::joinMapping(const Mapping::FileAppList & src) {
   QStringList l;
   Mapping::FileAppList::ConstIterator it;
   for ( it = src.begin(); it != src.end(); ++it ) {
      l.append((*it).wildcard+'\n'+(*it).app+'\n'+(*it).params+'\n'+((*it).isRegExp ? "+" : "-"));
   }
   return l;
}

//----------------------------------------------------------------------------

void CvsConfigOld::readProfiles(QStringList tmpList)
{
   cvsProfileContentList.clear();

   /*! insert items from qstringlist into a qlist */
   QStringList::Iterator it;
   for ( it = tmpList.begin(); it != tmpList.end(); ++it ) {
      QString line = (*it);
      line.prepend (',');
      line.append  (',');
      // qDebug(line);

      unsigned int i, idx, oldidx;
      idx = oldidx = 0;
      i = 0;
      const unsigned int nbItems = 6;
      QString lItem[nbItems + 1];  // one more for the overlast empty item
        
      /*! separate items */
      do {
	 oldidx = idx+1;
	 idx = line.find (',', oldidx); // WARNING: -1 --> 2^[32|64]
	 lItem[i++] = line.mid(oldidx, idx-oldidx);
      } while ((idx < line.length()) && (i < nbItems)); // terminate also if more items than expected
        
      /*! add item to qlist */
      int sshClientPreset = NOSSH;
      if (!lItem[5].isEmpty()) {
	 sshClientPreset = lItem[5].stripWhiteSpace().toInt();
	 if (sshClientPreset < NOSSH) sshClientPreset = NOSSH;
	 else if (sshClientPreset > USESSHAGENTVARS) sshClientPreset = USESSHAGENTVARS;
      }
      cvsProfileContentList.append(CLincvsProfile(lItem[0].stripWhiteSpace(),
					 lItem[1].stripWhiteSpace().toInt(),
					 lItem[2].stripWhiteSpace(),
					 lItem[3].stripWhiteSpace(),
					 lItem[4].stripWhiteSpace(),
					 sshClientPreset));
   }

   cvsProfileNameList.clear(); 

   QValueList<CLincvsProfile>::const_iterator itPro;
   for (itPro = cvsProfileContentList.begin(); itPro != cvsProfileContentList.end(); itPro++) {
      cvsProfileNameList.append((*itPro).name().stripWhiteSpace());
      cvsUsers.append((*itPro).user().stripWhiteSpace());
      cvsServers.append((*itPro).server().stripWhiteSpace());
      cvsRepositories.append((*itPro).repository().stripWhiteSpace());
   }
}

//----------------------------------------------------------------------------
