#!/bin/bash
#
# dm-initialize.sh
#
#    Initialization. This script should work for every distros.
#
#    Copyright (c) 2005-2006 Userful Corporation
#    
#    Jason Kim <jason@userful.com>
#
#
logfile="/var/log/userful-start.log"

# Stop redhat graphical boot if it exist
if [ -x /usr/bin/rhgb-client ]; then
	/usr/bin/rhgb-client -quit
fi

# remove files 
rm -f /tmp/mx-trial
rm -f /tmp/mx-config-error
rm -f /etc/usbinput.tmp
rm -f /tmp/unplug-inputdev
rm -f /tmp/unplug.tmp
rm -f /tmp/plug-inputdev
rm -f /var/run/pid.kbdlink*
rm -f /tmp/touchscreen-dev

if [ ! -d /etc/X11/Xinput ]; then
	mkdir /etc/X11/Xinput
fi

# backup log files
# 1box-server.log usbinput.log userful-start.log
/opt/userful/bin/dm-backup-log.sh

# check path of fonts directory.
# Ubuntu has different fonts path.
if [ ! -d /usr/X11R6/lib/X11/fonts -a -d /usr/share/X11/fonts ]; then
	ln -sf /usr/share/X11/fonts /usr/X11R6/lib/X11/fonts
fi

# check the symbolic link for the X server exist.
# SuSE varients have different link path for X.
if [ ! -x /usr/X11R6/bin/X ]; then
	rm -f /usr/X11R6/bin/X
	if [ -d /var/X11R6/bin ]; then  # For SuSE linux
		ln -s /var/X11R6/bin/X /usr/X11R6/bin/X
		if [ -x /usr/X11R6/bin/XFree86 ]; then
	       	ln -s /usr/X11R6/bin/XFree86 /var/X11R6/bin/X
	   	elif [ -x /usr/X11R6/bin/Xorg ]; then
	       	ln -s /usr/X11R6/bin/Xorg /var/X11R6/bin/X
	   	fi
    else
		if [ -x /usr/X11R6/bin/XFree86 ]; then
	       	ln -s /usr/X11R6/bin/XFree86 /usr/X11R6/bin/X
	   	elif [ -x /usr/X11R6/bin/Xorg ]; then
	       	ln -s /usr/X11R6/bin/Xorg /usr/X11R6/bin/X
	   	fi
	fi
fi

# check some directories and files needed
# In FC5 (new X Server), some directories and files don't exist. 
if [ ! -e /usr/X11R6/lib/X11/xkb ]; then
	if [ -e /usr/share/X11/xkb ]; then
		mkdir -p /usr/X11R6/lib/X11
		ln -s /usr/share/X11/xkb /usr/X11R6/lib/X11/xkb
	fi
fi

if [ ! -e /usr/X11R6/lib/X11/xkb/compiled ]; then
	if [ -e /var/lib/xkb ]; then
		ln -s /var/lib/xkb /usr/X11R6/lib/X11/xkb/compiled
	fi
fi

if [ ! -e /usr/X11R6/lib/X11/xkb/xkbcomp ]; then
	if [ -e /usr/bin/xkbcomp ]; then
		ln -s /usr/bin/xkbcomp /usr/X11R6/lib/X11/xkb/xkbcomp
	fi
fi

# check current Display Manager
if [ -f /etc/sysconfig/desktop -o -f /etc/sysconfig/displaymanager ]; then
	if [ -f /etc/sysconfig/desktop ]; then
		source /etc/sysconfig/desktop
	fi
	if [ -f /etc/sysconfig/displaymanager ]; then
		source /etc/sysconfig/displaymanager
	fi

	case "$DISPLAYMANAGER" in
		GNOME|GDM|gnome|gdm|Gnome)  CURRENTDM=gdm ;;
		KDE|KDM|kde|kdm)    CURRENTDM=kdm ;;
		XDM|xdm)    CURRENTDM=xdm ;;
		*)  echo "Unsupported Display manager specified" ;;
	esac
fi

if [ -z "$CURRENTDM" ] || ! which $CURRENTDM > /dev/null 2>&1; then
	if which gdm >/dev/null 2>&1; then
       	CURRENTDM=gdm
		echo "DISPLAYMANAGER=GNOME" > /etc/sysconfig/desktop 
	elif which kdm >/dev/null 2>&1; then
       	CURRENTDM=kdm
		echo "DISPLAYMANAGER=KDM" > /etc/sysconfig/desktop 
	elif which xdm >/dev/null 2>&1; then
       	CURRENTDM=xdm
		echo "DISPLAYMANAGER=XDM" > /etc/sysconfig/desktop 
	fi
fi

# check if Display Manager has been changed from last time
if [ -f /etc/userful/currentdm ]; then
	if ! grep $CURRENTDM /etc/userful/currentdm > /dev/null 2>&1; then
		rm -f /etc/X11/xdm/Xservers
	fi
fi
echo "CURRENTDM=$CURRENTDM" > /etc/userful/currentdm

# add comments into xorg.conf
if [ -e /etc/X11/xorg.conf ]; then
	TMP=`head -n 1 /etc/X11/xorg.conf`

	if [ "$TMP" != "# Note:" ]; then
		echo "# Note:" > /tmp/xorg.conf.tmp
		echo "# This is the default configuration file for Xorg.  To change the Desktop" >> /tmp/xorg.conf.tmp
		echo "# Multiplier configuration, you need to edit the userful.Mxorg.conf file." >> /tmp/xorg.conf.tmp
		echo "" >> /tmp/xorg.conf.tmp
		cat /etc/X11/xorg.conf >> /tmp/xorg.conf.tmp
		rm -f /etc/X11/xorg.conf
		mv -f /tmp/xorg.conf.tmp /etc/X11/xorg.conf
	fi
fi
