#!/usr/bin/env python

# Copyright (c) 2002-2006 Userful Corporation. All rights reserved.
# http://userful.com/

# about-dialog.py

import gtk 
import gtk.glade
import os
import time
import errno

use_sp = True
try:
    import subprocess as sp
except:
    use_sp = False

class PyGlade:
    glade_filename = 'about-dialog.glade'
    paths = []
    paths.append('./')
    paths.append('/usr/share/1box-utils/')

    config_changed = False

    def __init__(self):
        glade_file = self.find_file(self.glade_filename)
        
        if os.access(glade_file, os.R_OK) == 1:
            self.gtk_glade_xml = gtk.glade.XML(glade_file)
        else:
            exit

        widget = self.gtk_glade_xml.get_widget("main_dialog")
        widget.set_icon_from_file(self.find_file("multi-station-system-64.png"))

        widget = self.gtk_glade_xml.get_widget("logo")
        widget.set_from_file(self.find_file("userful-logo-transparent-background.png"))

        widget = self.gtk_glade_xml.get_widget("version_label")
        output = os.popen("rpm -q 1box-utils-k26 --qf '%{VERSION} Release: %{RELEASE}'")
        widget.set_text("Desktop Multiplier Version: " + output.read())
        output.close()

        widget = self.gtk_glade_xml.get_widget("os_label")
        issue_file = file('/etc/issue', 'r')
        for line in issue_file.readlines():
            if line.strip() == "":
                continue
            break
        line = line.strip()
        if line.upper().find("WELCOME") == 0:
            line = line[line.find(" ")+1:]
        if line.upper().find("TO") == 0:
            line = line[line.find(" ")+1:]
        widget.set_text("OS Version: " + line)
        issue_file.close()

        # check the box is we are in "Multi" mode
        checkmultiply = self.gtk_glade_xml.get_widget("checkbutton_multiply")
        checkmultiply.set_active(True)
        try:
            conf_file = file("/etc/sysconfig/xtype", "r")
        except IOError:
            checkmultiply.set_active(False)
            checkmultiply.set_sensitive(False)

        if checkmultiply.get_active():
            conf_file_cont = conf_file.readline()
            if conf_file_cont.strip() == "XTYPE=MULTI":
                checkmultiply.set_active(True)
            else:
                checkmultiply.set_active(False)
            
        # check if the multiuser device thingy exists, hide the button
        # to lanuch it if it's not
        if not os.access("/usr/bin/userful-device-assignment", os.R_OK) == 1:
            widget = self.gtk_glade_xml.get_widget("device_config_button")
            widget.hide()
            widget = self.gtk_glade_xml.get_widget("device_config_label")
            widget.hide()
            widget = self.gtk_glade_xml.get_widget("device_config_hseparator")
            widget.hide()

        # get a dictionary of all the class' methods
        signal_handlers = {}
        for key in dir(self.__class__):
            signal_handlers[key] = getattr(self, key)

        # this will connect all the signals defined in the glade file to functions
        # witth the same name, this will warn if signals are not handled 
        self.gtk_glade_xml.signal_autoconnect(signal_handlers)

    def find_file (self, file_name):
        for path in self.paths:
            file_path = os.path.join(path, file_name)
            if os.path.isfile(file_path):
                break
        return file_path

        widget = self.gtk_glade_xml.get_widget("error_text_label")
        widget.set_text("Error: " + text)
        widget = self.gtk_glade_xml.get_widget("error_dialog")
        widget.show_all()
        return
    def hide_error(self):
        widget = self.gtk_glade_xml.get_widget("main_dialog")
        widget.set_sensitive(True)
    def get_system_mac(self):
        output = os.popen('/sbin/ifconfig -a eth0')
        time.sleep(0.1)
        system_text=output.read()
        output.close()
        system_text = system_text.split(" ")
        get_next = False
        for item in system_text:
            if get_next:
                return item
            if item == "HWaddr":
                get_next = True
        return 0

    ################ CALLBACKS ################

    def on_checkbutton_multiply_toggled(self, widget):
        self.config_changed = True
        
    def on_ok_button_clicked(self, widget):
        if self.config_changed:
            checkmultiply = self.gtk_glade_xml.get_widget("checkbutton_multiply")
            write_file = True
            try:
                conf_file = file("/etc/sysconfig/xtype", "w")
            except:
                write_file = False
                if write_file:
                    if checkmultiply.get_active():
                        conf_file.write("XTYPE=MULTI")
                    else:
                        conf_file.write("XTYPE=SINGLE")
                    conf_file.close()
                else:
                    err_dlg = self.find_file("error-dialog.py")
                    os.system(err_dlg + " " + "\"Could not write DesktopMultiplier configuration. Could not write to /etc/sysconfig/xtype.\" &")
        
        gtk.main_quit()
        return 

    def on_register_button_clicked(self, widget):
        ret = os.system(self.find_file("register.sh") + " &");
        if ret == 1:
            err_dlg = self.find_file("error-dialog.py")
            message = "Could not launch web browser. Visit http://store.userful.com/."
            os.system(err_dlg + " " + "\"" + message + "\" &")
        return

    def on_install_license_button_clicked(self, widget):
        os.system(self.find_file("install-license.sh") + " &");
        return

    def on_Help_OK_button_clicked(self, widget):
        gtk.main_quit()
        return 

    def on_support_button_clicked(self, widget):
        os.system(self.find_file("help-dialog.py") + " &");
        return

    def on_report_button_clicked(self, widget):
        # url = "http://userful.com/support/issue?p=dm"
        ret = os.system(self.find_file("submit-debug-info.sh") + " -g &");
        #if ret == 1:
        #    err_dlg = self.find_file("error-dialog.py")
        #    message = "Could not launch web browser. Goto " + url + " in a web browser."
        #    os.system(err_dlg + " " + "\"" + message + "\" &")
        return

    def on_main_dialog_destroy(self, widget):
        gtk.main_quit()

    def on_device_config_button_clicked(self, widget):
        os.system("userful-device-assignment &");

    def on_website_button_clicked(self, widget):
        url = "http://userful.com/"
        ret = os.system(self.find_file("launch-preferred-browser.sh") + " " + url + " &");
        if not ret == 0:
            err_dlg = self.find_file("error-dialog.py")
            message = "Could not launch web browser. Goto " + url + " in a web browser."
            os.system(err_dlg + " " + "\"" + message + "\" &")
        return

    def on_license_details_button_clicked(self, widget):
        os.system(self.find_file("license-details.py &"))
        return
    def on_reassign_button_clicked(self, widget):
        (in_pipe, out_pipe) = os.popen4("/opt/userful/bin/usbinput-reconf.sh")
        #time.sleep(1)
        output = out_pipe.read()
        ret = out_pipe.close()
        in_pipe.close()
        if not output == "":
            err_dlg = self.find_file("error-dialog.py")
            output = output.replace("`", "")
            output = output.replace("'", "")
            message = "Error: " + output
            os.system(err_dlg + " " + "\"" + message + "\" &")
        return
        
    def on_reconfig_button_clicked(self, widget):
        (in_pipe, out_pipe) = os.popen4("rm -f /etc/X11/userful.Mxorg.conf", mode='r')
        output = out_pipe.read()
        ret = out_pipe.close()
        in_pipe.close()
        err_dlg = self.find_file("error-dialog.py")
        if not output == "":
            output = output.replace("`", "")
            output = output.replace("'", "")
            message = "Error: Could not reset station settings. Reason: " + output
            os.system(err_dlg + " " + "\'" + message + "\' &")
        else:
            err_dlg += " type=sucess \"text=Successfully removed config file. System will reconfigure on next boot.\" &"
            os.system(err_dlg)
        return

def main():

    PyGlade_ins = PyGlade()

    gtk.main()

if __name__ == "__main__":
    main()

