#!/usr/bin/env python

# Copyright (c) 2002-2006 Userful Corporation. All rights reserved.
# http://www.userful.com/

# activation-dialog.py

# this is the dialog the appears when the user clicks "Register" in the
# about dialog.

import gtk 
import gtk.glade
import os
import time
import sys

class PyGlade:
    glade_filename = 'activation-dialog.glade'
    paths = []
    paths.append('./')
    paths.append('/usr/share/1box-utils/')

    def __init__(self):
        glade_file = self.find_file(self.glade_filename)
        
        if os.access(glade_file, os.R_OK) == 1:
            self.gtk_glade_xml = gtk.glade.XML(glade_file)
        else:
            sys.exit(1)

        widget = self.gtk_glade_xml.get_widget("activation_dialog")
        widget.set_icon_from_file(self.find_file("multi-station-system-64.png"))

        widget = self.gtk_glade_xml.get_widget("activation_instructions_label")
        widget.set_text("If you have an activation code, enter it here:")

        widget = self.gtk_glade_xml.get_widget("error_label")
        widget.set_text("")

        widget = self.gtk_glade_xml.get_widget("register_instructions_label")
        widget.set_text("If you do not have an activation code, you will need to register to get one. Click the button below to launch a web browser to start the registration process")

        num_stations = 10
        # read /etc/X11/stations (if not exists, find number of video heads)
        widget = self.gtk_glade_xml.get_widget("stations_spinbutton")
        stations_available = True
        try:
            stations_file = file("/etc/X11/stations", "rU")
        except IOError:
            stations_available = False
            
        if stations_available:
            station_number_read = stations_file.readline()
            station_number = station_number_read.strip()
            if station_number.isdigit():
                num_stations = int(station_number)
            else:
                widget.set_sensitive(False)

        widget.set_range(1, 64)
        widget.set_value(num_stations)


        # get a dictionary of all the class' methods
        signal_handlers = {}
        for key in dir(self.__class__):
            signal_handlers[key] = getattr(self, key)

        # this will connect all the signals defined in the glade file to functions
        # witth the same name, this will warn if signals are not handled 
        self.gtk_glade_xml.signal_autoconnect(signal_handlers)

    def set_error_text (self, text):
        widget = self.gtk_glade_xml.get_widget("error_label")
        #widget.set_text(text)
        text_prefix = "<span foreground=\"red\" weight=\"bold\">"
        text_postfix = "</span>"
        if (len(text) > 256):
            text = text[:255]
        text = text.replace("&", "&amp;")
        text = text.replace("<", "&lt;")
        text = text.replace(">", "&gt;")
        try:
            widget.set_markup(text_prefix + text + text_postfix)
        except:
            widget.set_markup(text_prefix + "server error" + text_postfix)
        return

    def set_key_text (self, text):
        widget = self.gtk_glade_xml.get_widget("activation_key_entry")
        widget.set_text(text)
        return

    def find_file (self, file_name):
        for path in self.paths:
            file_path = os.path.join(path, file_name)
            if os.path.isfile(file_path):
                break
        return file_path

    ################ CALLBACKS ################

    def on_activation_dialog_destroy(self, widget):
        gtk.main_quit()
        return 

    def on_launch_browser_button_clicked(self, widget):
        os.system(self.find_file("register.sh") + " &")
        # Ryan wants to leave the window open
        #gtk.main_quit()
        return 
    def on_activate_button_clicked(self, widget):
        widget = self.gtk_glade_xml.get_widget("activation_key_entry")
        activation_key = widget.get_text()

        widget = self.gtk_glade_xml.get_widget("stations_spinbutton")
        num_stations = widget.get_value_as_int()

        os.system(self.find_file("install-license.sh") + " " + activation_key + " &")

        gtk.main_quit()
        return 
    def on_activation_key_entry_editing_done(self, widget):
        on_activate_button_clicked(self, widget)
        return

def read_args():
   return_dict = {}
   for arg in sys.argv[1:]:
      (keyname, keyvalue)=arg.split('=',1)
      keyvalue = keyvalue.strip()
      keyname = keyname.strip()
      return_dict[keyname]=keyvalue
   return return_dict


def main():
    PyGlade_ins = PyGlade()

    arg_dict = read_args()

    if arg_dict.has_key("error_text") and arg_dict["error_text"] != "":
        PyGlade_ins.set_error_text(arg_dict["error_text"])

    if arg_dict.has_key("key") and arg_dict["key"] != "":
        PyGlade_ins.set_key_text(arg_dict["key"])

    gtk.main()


if __name__ == "__main__":
    main()

