#!/bin/bash
#
# Copyright (c) 2005-2006 Userful Corporation Ltd.

# Name: config-gen.sh
# Author:  Jason Kim 
# Description:
# generate config file for 1Box-Server.
#########################

logfile="/var/log/userful-start.log"
ProgramName=`basename $0`

source /opt/userful/bin/userful-bash-lib.sh

MXDEVNO=0 # For Multi X configuration
SXDEVNO=0 # For Normal X configuration
HEADNO=
NUM_OF_HEAD=
CURR_CARD_TYPE=

STATION_TYPE=

SUCCESS=0

BUSID=
VENDORNAME=
VENDORID=
VIDEOID=
DEVID=
BOARDNAME=
DRIVER=

KILLX=1
XKBRULES=
XKBMODEL=
XKBLAYOUT=
XKBOPTIONS=
XKBVARIANT=
MODES=

DISABLEXVIDMODE=0

# error-out function
bomb() {
	echo "$PROGRAM_NAME: error: $*" >> $logfile
	exit 1
}

# set LSPCI
if which lspci > /dev/null 2>&1; then
	LSPCI="lspci"
else
	LSPCI="/opt/userful/bin/listpci"
fi
BUSID_LEN=`$LSPCI -n | grep -m 1 "0300: " | cut -d ' ' -f 1 | wc -m`

#
# generate File section
# $1: config type
gen_Header()
{
	echo '#######################################' > tmpconfig

	if [ "$1" == "-1box" ] || [ "$1" == "-ds" ]; then
		echo '# userful.Mxorg.conf' >> tmpconfig
	elif [ "$1" == "-all" ]; then
		echo '# userful.xorg.conf.all' >> tmpconfig
	elif [ "$1" == "-one" ]; then
		echo '# userful.xorg.conf.one' >> tmpconfig
	elif [ "$1" == "-check" ]; then
		echo '# userful.xorg.conf.check' >> tmpconfig
	fi
	echo '# Created by mx-config-gen.sh' >> tmpconfig
	echo '# arg: '$1'' >> tmpconfig
	echo '#######################################' >> tmpconfig
}

#
# generate File section
# $1: config type
gen_Files()
{
	if [ -f /etc/userful/MXVERSION ]; then
		source /etc/userful/MXVERSION
	else
		MXVER=MX11R6
	fi

	echo '
Section "Files"
	RgbPath		"/usr/X11R6/lib/X11/rgb"' >> tmpconfig

	if [ "$1" == "-1box" ] || [ "$1" == "-ds" ]; then
		if [ "$MXVER" == "MX11R6" ]; then
			echo '	ModulePath	"/opt/MX11R6/'$LIB'/modules"' >> tmpconfig
		else
			echo '	ModulePath	"/opt/MX11R7/lib/xorg/modules"' >> tmpconfig
		fi
	fi

	if [ "$MXVER" == "MX11R6" ]; then
		echo '	ModulePath	"/usr/X11R6/'$LIB'/modules"
    FontPath	"unix/:7100"
    FontPath	"/usr/X11R6/lib/X11/fonts/local/"
	FontPath	"/usr/X11R6/lib/X11/fonts/misc/"
	FontPath	"/usr/X11R6/lib/X11/fonts/75dpi/:unscaled"
	FontPath	"/usr/X11R6/lib/X11/fonts/100dpi/:unscaled"
	FontPath	"/usr/X11R6/lib/X11/fonts/Type1/"
	FontPath	"/usr/X11R6/lib/X11/fonts/CID/"
	FontPath	"/usr/X11R6/lib/X11/fonts/Speedo/"
	FontPath	"/usr/X11R6/lib/X11/fonts/75dpi/"
	FontPath	"/usr/X11R6/lib/X11/fonts/100dpi/"
EndSection' >> tmpconfig

	else
		echo '	ModulePath	"/usr/'$LIB'/xorg/modules"
    FontPath	"unix/:7100"
    FontPath	"/opt/MX11R7/share/X11/fonts/local/"
    FontPath	"/opt/MX11R7/share/X11/fonts/misc/"
    FontPath	"/opt/MX11R7/share/X11/fonts/75dpi/:unscaled"
    FontPath	"/opt/MX11R7/share/X11/fonts/100dpi/:unscaled"
    FontPath	"/opt/MX11R7/share/X11/fonts/Type1/"
    FontPath	"/opt/MX11R7/share/X11/fonts/CID/"
    FontPath	"/opt/MX11R7/share/X11/fonts/Speedo/"
    FontPath	"/opt/MX11R7/share/X11/fonts/75dpi/"
    FontPath	"/opt/MX11R7/share/X11/fonts/100dpi/"
EndSection' >> tmpconfig
	fi
}

#
# ServerFlags section
# $1: config type 
gen_ServerFlags()
{
	if [ "$1" == "-1box" ] || [ "$1" == "-ds" ]; then
		echo '
Section "ServerFlags"
	Option  "Xinerama"	"off"
   	Option  "Clone"		"off"
   	Option  "RandR"		"off"
	Option	"DontVTSwitch"	"on"
	#Option	"DontZap"	"on"
	Option	"DontZoom"	"on"
	Option  "DisableVidModeExtension"   "on"
EndSection' >> tmpconfig 
	fi
}

#
# Module section
# $1: config type 
gen_Module()
{
	echo '
Section "Module"
	Load "dbe"
	SubSection "extmod"
            Option "omit XFree86-DGA"
    	EndSubSection
	Load "record"
	Load "freetype"
	Load "type1"
EndSection' >> tmpconfig
}

# wrapper around db_get
fetch()
{
	FETCH_VAL=""
	db_get $DB_PATH$1
	if [ $? -eq 0 -a -n "$RET" ]; then
		FETCH_VAL="$RET"
	fi

	if [ -z "$FETCH_VAL" ]; then
		case "$1" in
			rules)
				FETCH_VAL="xorg"
				;;
			layout)
				FETCH_VAL="us"
				;;
			model)
				FETCH_VAL="pc105"
				;;
			variant)
				FETCH_VAL="NULL"
				;;
			options)
				FETCH_VAL="NULL"
				;;
			*)
				bomb "Invalid argument for db_get."
				;;
		esac
	fi
}

#
# InputDevice section for Keyboard
# $1: config type 
# . /etc/sysconfig/keyboard ; KEYTABLE=`echo $KEYTABLE | awk -F'.' '{print $1}'` ; cat ./XKB-KEYTABLE | grep ^$KEYTABLE\^ | awk -F'^' '{print $5}'
gen_InputDevice_kbd()
{
	if [ -f /usr/X11R6/bin/Xorg ]; then
		XKBRULES="xorg"
	elif [ -f /usr/X11R6/bin/XFree86 ]; then
		XKBRULES="xfree86"
	else
		XKBRULES="xorg"
	fi

	if [ -f /etc/sysconfig/keyboard ]; then
		source /etc/sysconfig/keyboard

		KEYTABLE=`echo $KEYTABLE | awk -F'.' '{printf $1}'`
		XKBSTRING=`cat /opt/userful/bin/XKB-KEYTABLE | grep ^$KEYTABLE\^`
		XKBLAYOUT=`echo $XKBSTRING | awk -F'^' '{printf $2}'`
		XKBMODEL=`echo $XKBSTRING | awk -F'^' '{printf $3}'`
		XKBVARIANT=`echo $XKBSTRING | awk -F'^' '{printf $4}'`
		XKBOPTIONS=`echo $XKBSTRING | awk -F'^' '{printf $5}'`

	elif which dexconf > /dev/null 2>&1; then
		. /usr/share/debconf/confmodule
		DB_PATH="xserver-xorg/config/inputdevice/keyboard/"

		# need to check xorg.conf file first
		if [ -f /etc/X11/xorg.conf ]; then

			# XKBRULES
			XKBVAL=`grep "XkbRules" /etc/X11/xorg.conf | awk -- '{print $3}' | tr -d \"`
			if [ -n "$XKBVAL" ]; then
				XKBRULES="$XKBVAL"
			else
				fetch rules
				XKBRULES="$FETCH_VAL"
			fi

			# XKBLAYOUT
			XKBVAL=`grep "XkbLayout" /etc/X11/xorg.conf | awk -- '{print $3}' | tr -d \"`
			if [ -n "$XKBVAL" ]; then
				XKBLAYOUT="$XKBVAL"
			else
				fetch layout
				XKBLAYOUT="$FETCH_VAL"
			fi

			# XKBMODEL
			XKBVAL=`grep "XkbModel" /etc/X11/xorg.conf | awk -- '{print $3}' | tr -d \"`
			if [ -n "$XKBVAL" ]; then
				XKBMODEL="$XKBVAL"
			else
				fetch model
				XKBMODEL="$FETCH_VAL"
			fi

			# XKBVARIANT
			XKBVAL=`grep "XkbVariant" /etc/X11/xorg.conf | awk -- '{print $3}' | tr -d \"`
			if [ -n "$XKBVAL" ]; then
				XKBVARIANT="$XKBVAL"
			else
				fetch variant
				XKBVARIANT="$FETCH_VAL"
			fi

			# XKBOPTIONS
			XKBVAL=`grep "XkbOptions" /etc/X11/xorg.conf | awk -- '{print $3}' | tr -d \"`
			if [ -n "$XKBVAL" ]; then
				XKBOPTIONS="$XKBVAL"
			else
				fetch options
				XKBOPTIONS="$FETCH_VAL"
			fi

		else
			for ARG in rules layout model variant options; do
				fetch $ARG
				case "$ARG" in
					rules)
						XKBRULES="$FETCH_VAL"
						;;
					layout)
						XKBLAYOUT="$FETCH_VAL"
						;;
					model)
						XKBMODEL="$FETCH_VAL"
						;;
					variant)
						XKBVARIANT="$FETCH_VAL"
						;;
					options)
						XKBOPTIONS="$FETCH_VAL"
						;;
					*)
						bomb "Invalid argument for db_get."
						;;
				esac
			done

		fi
	else
		XKBLAYOUT="us"
		XKBMODEL="pc105"
		XKBVARIANT="NULL"
		XKBOPTIONS="NULL"
	fi	

	echo '
##############################
# keyboard section 
##############################' >> tmpconfig

	if [ "$1" == "-1box" ] || [ "$1" == "-ds" ]; then
		for (( i=0; i<10; i++ )); do
			echo 'Section "InputDevice"
	Identifier "Keyboard'$i'"
	Driver "usbkbd"
	Option "Protocol" "usb_event"
	Option "Device" "/etc/X11/Xinput/keyboard'$i'"
	Option "Screen" "'$i'"
	Option "XkbRules" "'$XKBRULES'"
	Option "XkbLayout" "'$XKBLAYOUT'"
	Option "XkbModel" "'$XKBMODEL'"' >> tmpconfig

			if [ "$XKBVARIANT" != "NULL" ]; then
				echo '	Option "XkbVariant" "'$XKBVARIANT'"' >> tmpconfig
			fi
			if [ "$XKBOPTIONS" != "NULL" ]; then
				echo '	Option "XkbOptions" "'$XKBOPTIONS'"' >> tmpconfig
			fi
			
			echo 'EndSection' >> tmpconfig
		done

		echo '
##############################
# Bar Code Scanner section 
##############################' >> tmpconfig
		for (( i=0; i<10; i++ )); do
			echo 'Section "InputDevice"
	Identifier "Barcode'$i'"
	Driver "usbkbd"
	Option "Protocol" "usb_event"
	Option "Device" "/etc/X11/Xinput/barcode'$i'"
	Option "Screen" "'$i'"
	Option "XkbRules" "'$XKBRULES'"
	Option "XkbLayout" "'$XKBLAYOUT'"
	Option "XkbModel" "'$XKBMODEL'"' >> tmpconfig

			if [ "$XKBVARIANT" != "NULL" ]; then
				echo '	Option "XkbVariant" "'$XKBVARIANT'"' >> tmpconfig
			fi
			if [ "$XKBOPTIONS" != "NULL" ]; then
				echo '	Option "XkbOptions" "'$XKBOPTIONS'"' >> tmpconfig
			fi
			
			echo 'EndSection' >> tmpconfig
		done

		echo '
##############################
# Magnetic Card reader section 
##############################' >> tmpconfig
		for (( i=0; i<10; i++ )); do
			echo 'Section "InputDevice"
	Identifier "Magreader'$i'"
	Driver "usbkbd"
	Option "Protocol" "usb_event"
	Option "Device" "/etc/X11/Xinput/magreader'$i'"
	Option "Screen" "'$i'"
	Option "XkbRules" "'$XKBRULES'"
	Option "XkbLayout" "'$XKBLAYOUT'"
	Option "XkbModel" "'$XKBMODEL'"' >> tmpconfig

			if [ "$XKBVARIANT" != "NULL" ]; then
				echo '	Option "XkbVariant" "'$XKBVARIANT'"' >> tmpconfig
			fi
			if [ "$XKBOPTIONS" != "NULL" ]; then
				echo '	Option "XkbOptions" "'$XKBOPTIONS'"' >> tmpconfig
			fi
			
			echo 'EndSection' >> tmpconfig
		done


	else
		echo 'Section "InputDevice"
	Identifier  "Keyboard0"
	Driver      "kbd"
	Option "XkbRules" "'$XKBRULES'"
	Option "XkbLayout" "'$XKBLAYOUT'"
	Option "XkbModel" "'$XKBMODEL'"' >> tmpconfig

		if [ "$XKBVARIANT" != "NULL" ]; then
			echo '	Option "XkbVariant" "'$XKBVARIANT'"' >> tmpconfig
		fi
		if [ "$XKBOPTIONS" != "NULL" ]; then
			echo '	Option "XkbOptions" "'$XKBOPTIONS'"' >> tmpconfig
		fi
		
		echo 'EndSection' >> tmpconfig
	fi
}

#
# InputDevice section for Mouse
# $1: config type 
gen_InputDevice_mse()
{
	echo '
###############################
# mouse section 
###############################' >> tmpconfig

	if [ "$1" == "-1box" ] || [ "$1" == "-ds" ]; then
		for (( i=0; i<10; i++ )); do
			echo 'Section "InputDevice"
	Identifier  "Mouse'$i'"
	Driver      "mouse"
	Option      "Protocol" "IMPS/2"
	Option      "Device" "/etc/X11/Xinput/mouse'$i'"
	Option      "ZAxisMapping" "4 5"
	Option      "Emulate3Buttons" "no"
	Option      "Screen"  "'$i'"
EndSection' >> tmpconfig
		done
	else
		echo 'Section "InputDevice"
	Identifier  "Mouse0"
	Driver      "mouse"
	Option      "Device" "/dev/input/mice"
	Option      "Protocol" "ImPS/2"
	Option      "Emulate3Buttons" "off"
	Option      "ZAxisMapping" "4 5"
EndSection' >> tmpconfig
	fi
}

#
# InputDevice section for TouchScreen
# $1: config type
gen_InputDevice_touch()
{
	echo '
###############################
# TouchScreen section
###############################' >> tmpconfig

	if [ "$1" == "-1box" ] || [ "$1" == "-ds" ]; then
		for (( i=0; i<10; i++ )); do
        	echo 'Section "InputDevice"
	Identifier "Touch'$i'"
	Driver "evtouch"
	#Option "Calibrate" "1"
	Option "Device" "/etc/X11/Xinput/touch'$i'"
	Option "DeviceName" "Touch'$i'"
	Option "MinX" "67"
	Option "MinY" "96"
	Option "MaxX" "4000"
	Option "MaxY" "4003"
	Option "ReportingMode" "Raw"
	Option "SendCoreEvents" "On"
	Option "DragTimer" "300"
	Option "MoveLimit" "500"
	Option "Screen"  "'$i'"
	#Option "SwapX"
	#Option "SwapY"
EndSection' >> tmpconfig
		done
	fi
}

#
# Monitor section 
gen_Monitor()
{
	if [ "$1" == "-all" ]; then
		H_SYNC="28-78"
		V_REFRESH="43-75"
	else
		if [ "$SYS_RESOLUTION" == "1" ]; then
			H_SYNC="28-78"
			V_REFRESH="43-75"
		elif [ "$SYS_RESOLUTION" == "2" ]; then
			H_SYNC="28-78"
			V_REFRESH="43-75"
		elif [ "$SYS_RESOLUTION" == "3" ]; then
			H_SYNC="28-78"
			V_REFRESH="43-75"
		elif [ "$SYS_RESOLUTION" == "4" ]; then
			H_SYNC="31-82"
			V_REFRESH="56-75"
		else
			H_SYNC="28-78"
			V_REFRESH="43-75"
		fi
	fi
	echo '
#####################################
# Monitor section ( common monitor )
#####################################
Section "Monitor"
	Identifier "Monitor"
	VendorName "Monitor Vendor"
	ModelName "Monitor Model"
	HorizSync '$H_SYNC'
	VertRefresh '$V_REFRESH'
EndSection' >> tmpconfig
}


# get information for Graphic card
# $1: config type
# $2: information string (lspci -n  :  busid Class 0300: vender_id:product_id )
get_card_value()
{
	if [ "$1" == "-1box" ]; then # $2 ex: 0:11:0^^ATI Radeon 7000^radeon^2^1002:5159
		BUSID=`echo $2 | awk -F'^' '{print $1}'`
		VENDORNAME=`echo $2 | awk -F'^' '{print $2}'`
		BOARDNAME=`echo $2 | awk -F'^' '{print $3}'`
		DRIVER=`echo $2 | awk -F'^' '{print $4}'`
		HEADNO=`echo $2 | awk -F'^' '{print $5}'`
		DEVID=`echo $2 | awk -F'^' '{print $6}'`
	else # $2 ex: 01:00.0 Class 0300: 1002:5159
		if [ $BUSID_LEN -lt 12 ]; then  # 00:00.0 type
			# get the BUSID
			BUSNUM=`echo $2 | awk -- '{split($1,a,"."); split(a[1],b,":"); print b[1]}'`
			DEVICENUM=`echo $2 | awk -- '{split($1,a,"."); split(a[1],b,":"); print b[2]}'`
		else
			# get the BUSID
			BUSNUM=`echo $2 | awk -- '{split($1,a,"."); split(a[1],b,":"); print b[2]}'`
			DEVICENUM=`echo $2 | awk -- '{split($1,a,"."); split(a[1],b,":"); print b[3]}'`
		fi
		FUNCTIONNUM=`echo $2 | awk -- '{split($1,a,"."); split(a[1],b,":"); print a[2]}'`

		BUSNUM=$(( 16#$BUSNUM ))
		DEVICENUM=$(( 16#$DEVICENUM ))
		FUNCTIONNUM=$(( 16#$FUNCTIONNUM ))
		BUSID=$BUSNUM:$DEVICENUM:$FUNCTIONNUM

		if echo $2 | tr "[A-Z]" "[a-z]" | grep class > /dev/null 2>&1 ; then
            VENDORID=`echo $2 |awk '{split($4,a,":"); print a[1]}'`
            VIDEOID=`echo $2 |awk '{split($4,a,":"); print a[2]}'`
		else
            VENDORID=`echo $2 |awk '{split($3,a,":"); print a[1]}'`
            VIDEOID=`echo $2 |awk '{split($3,a,":"); print a[2]}'`
		fi

		# Find the video card name from pcitable, given video id
   		VIDEONAME=`grep "0x"$VENDORID /etc/userful/pcitable |
					grep "0x"$VIDEOID |
					awk -- '{if(substr($3,2,4) == "Card") {split($0,a,"\""); print a[2]}}' |
					awk -- '{split($0,b,":"); print b[2]}'`
   		VENDORNAME=`grep "0x"$VENDORID /etc/userful/pcitable |
					grep "0x"$VIDEOID |
					awk -- '{if(substr($3,2,4) == "Card") {split($0,a,"\""); print a[4]}}' |
					awk -- '{split($0,b,"|"); print b[1]}'`
   		BOARDNAME=$VIDEONAME

		echo $VIDEONAME |sed -e 's/(/\\(/g' | sed -e 's/)/\\)/g' | sed -e 's/\//\\\//g' > tmp-video
   		VIDEO=`cat tmp-video`

		# Find the driver name from /etc/userful/Cards, given VIDEO card name
   		found=0
   		while [ $found == 0 ]; do
 
   			test=`awk 'BEGIN { i = 0 }
					   /NAME '"$VIDEO"'$/ { i=1 }
					   /DRIVER/ && i==1 { print "1 "$0; next }
				   	   /SEE/ && i==1 { print "0 "$0; next }
				   	   i==1 && NF==0 { i=0; }' /etc/userful/Cards`

   			if [ "${test:0:1}" == "0" ]; then
   	    		VIDEONAME=${test:6:60}
				echo $VIDEONAME |sed -e 's/(/\\(/g' | sed -e 's/)/\\)/g'| sed -e 's/\//\\\//g'  >tmp-video
   	    		VIDEO=`cat tmp-video`
   			else
   	    		DRIVER=${test:9:60}
   	    		found=1
   			fi
   		done
	
		# use default driver for unknow ATI and nVidia cards.
		if [ "$DRIVER" == "" ]; then
			if [ "$VENDORID" == "1002" ]; then # ATI card
				VENDORNAME="ATI"
				BOARDNAME="unknown ATI card"
				DRIVER="radeon"
			elif [ "$VENDORID" == "10de" ]; then # nVidia card
				VENDORNAME="nVidia"
				BOARDNAME="unknown nVidia card"
				DRIVER="nv"
			fi
		fi

	fi

	#echo $BUSID $VENDORNAME $BOARDNAME $DRIVER $HEADNO
}

mga_multihead_config()
{
	if [ "$CURR_CARD_TYPE" == "S" -o "$1" != "-1box" -o "$SYS_TYPE" == "1" ]; then 
   		echo 'Section "Device"
	Identifier "Videocard'$MXDEVNO'"
	Driver "'$DRIVER'"
	VendorName "'$VENDORNAME'"
	BoardName "'$BOARDNAME'"
	BusID "PCI:'$BUSID'"
	Screen 0
	Option "MGASDRAM" "on"
	Option "SWCursor" "on"
	Option "HWCursor" "off"
EndSection' >> tmpconfig
		echo 'Section "Device"
	Identifier "Videocard'$((MXDEVNO+1))'"
	Driver "'$DRIVER'"
	VendorName "'$VENDORNAME'"
	BoardName "'$BOARDNAME'"
	BusID "PCI:'$BUSID'"
	Screen 1
	Option "MGASDRAM" "on"
	Option "SWCursor" "on"
	Option "HWCursor" "off"
EndSection' >> tmpconfig 
   		MXDEVNO=$((MXDEVNO+2))
	else  # DualView
   		echo 'Section "Device"
	Identifier "Videocard'$MXDEVNO'"
	Driver "'$DRIVER'"
	VendorName "'$VENDORNAME'"
	BoardName "'$BOARDNAME'"
	BusID "PCI:'$BUSID'"
	Screen 0
	Option "MergedFB"
	Option "Monitor2Position" "RightOf"
	Option "Monitor2HSync" "'$H_SYNC'"
	Option "Monitor2VRefresh" "'$V_REFRESH'"
	Option "MGASDRAM" "on"
	Option "SWCursor" "on"
	Option "HWCursor" "off"' >> tmpconfig

		if [ "$SYS_RESOLUTION" == "1" ]; then
			echo '	Option "MetaModes" "640x480-640x480"' >> tmpconfig
		elif [ "$SYS_RESOLUTION" == "2" ]; then
			echo '	Option "MetaModes" "800x600-800x600 640x480-640x480"' >> tmpconfig
		elif [ "$SYS_RESOLUTION" == "3" ]; then
			echo '	Option "MetaModes" "1024x768-1024x768 800x600-800x600 640x480-640x480"' >> tmpconfig
		elif [ "$SYS_RESOLUTION" == "3" ]; then
			echo '	Option "MetaModes" "1280x1024-1280x1024 1024x768-1024x768 800x600-800x600 640x480-640x480"' >> tmpconfig
		fi
		echo 'EndSection' >> tmpconfig

		STATION_TYPE[$MXDEVNO]=D # Set the Vitual in Screen section
		SYS_DUALVIEW=$((SYS_DUALVIEW-1))
   		MXDEVNO=$((MXDEVNO+1))
	fi
}

radeon_multihead_config()
{
	if [ "$CURR_CARD_TYPE" == "S" -o "$1" != "-1box" -o "$SYS_TYPE" == "1" ]; then 
   		echo 'Section "Device"
	Identifier "Videocard'$MXDEVNO'"
	Driver "'$DRIVER'"
	VendorName "'$VENDORNAME'"
	BoardName "'$BOARDNAME'"
	BusID "PCI:'$BUSID'"
	Screen 0' >> tmpconfig

		if [ "$SYS_TYPE" == "1" ]; then
			echo '	Option "MonitorLayout" "LVDS, CRT"' >> tmpconfig
		else
			echo '	Option "MonitorLayout" "CRT, CRT"' >> tmpconfig
		fi
		echo '	Option "DisplayPriority" "AUTO"' >> tmpconfig
		echo '	Option "SWCursor" "on"
	Option "HWCursor" "off"
	Option "ColorTiling" "off"
EndSection' >> tmpconfig

   		echo 'Section "Device"
	Identifier "Videocard'$((MXDEVNO+1))'"
	Driver "'$DRIVER'"
	VendorName "'$VENDORNAME'"
	BoardName "'$BOARDNAME'"
	BusID "PCI:'$BUSID'"
	Screen 1' >> tmpconfig

		if [ "$SYS_TYPE" == "1" ]; then
			echo '	Option "MonitorLayout" "LVDS, CRT"' >> tmpconfig
		else
			echo '	Option "MonitorLayout" "CRT, CRT"' >> tmpconfig
		fi
		echo '	Option "DisplayPriority" "AUTO"' >> tmpconfig
		echo '	Option "SWCursor" "on"
	Option "HWCursor" "off"
	Option "ColorTiling" "off"
EndSection' >> tmpconfig
   		MXDEVNO=$((MXDEVNO+2))

	else  # dualview
		echo 'Section "Device"
	Identifier "Videocard'$MXDEVNO'"
	Driver "'$DRIVER'"
	VendorName "'$VENDORNAME'"
	BoardName "'$BOARDNAME'"
	BusID "PCI:'$BUSID'"
	Option "CRT2ForceOn" "true"
	Option "ForceCRT2Type" "VGA"
	Option "ForceCRT1" "true"
	Option "MergedFB" "true"
	Option "CRT2Position" "RightOf"
	Option "SWCursor" "on"
	Option "HWCursor" "off"
	Option "ColorTiling" "off"
EndSection' >> tmpconfig
		STATION_TYPE[$MXDEVNO]=D # Set the Virtual in screen section
		SYS_DUALVIEW=$((SYS_DUALVIEW-1))
    	MXDEVNO=$((MXDEVNO+1))
	fi
}

nvidia_multihead_config()
{
	if [ "$CURR_CARD_TYPE" == "S" -o "$1" != "-1box" -o "$SYS_TYPE" == "1" ]; then 
		echo 'Section "Device"
	Identifier "Videocard'$MXDEVNO'"
	Driver "nvidia"
	VendorName "'$VENDORNAME'"
	BoardName "'$BOARDNAME'"
	BusID "PCI:'$BUSID'"
	Screen 0' >> tmpconfig
		if [ "$SYS_TYPE" == "1" ]; then
			echo '	Option "ConnectedMonitor" "DFP, CRT"' >> tmpconfig
		else
			echo '	Option "ConnectedMonitor" "CRT, CRT"' >> tmpconfig
		fi
	echo '	Option "SWCursor" "on"
	Option "HWCursor" "off"
EndSection' >> tmpconfig

   	echo 'Section "Device"
	Identifier "Videocard'$((MXDEVNO+1))'"
	Driver "nvidia"
	VendorName "'$VENDORNAME'"
	BoardName "'$BOARDNAME'"
	BusID "PCI:'$BUSID'"
	Screen 1' >> tmpconfig
		if [ "$SYS_TYPE" == "1" ]; then
			echo '	Option "ConnectedMonitor" "DFP, CRT"' >> tmpconfig
		else
			echo '	Option "ConnectedMonitor" "CRT, CRT"' >> tmpconfig
		fi
	echo '	Option "SWCursor" "on"
	Option "HWCursor" "off"
EndSection' >> tmpconfig
		MXDEVNO=$((MXDEVNO+2))

	else
		echo 'Section "Device"
	Identifier "Videocard'$MXDEVNO'"
	Driver "nvidia"
	VendorName "'$VENDORNAME'"
	BoardName "'$BOARDNAME'"
	BusID "PCI:'$BUSID'"
	Option "TwinView" "on"
	Option "TwinViewOrientation" "RightOf"
	Option "ConnectedMonitor" "CRT,CRT"' >> tmpconfig
		if [ "$SYS_RESOLUTION" == "1" ]; then
			echo '	Option "MetaModes" "640x480,640x480"' >> tmpconfig
		elif [ "$SYS_RESOLUTION" == "2" ]; then
			echo '	Option "MetaModes" "800x600,800x600; 640x480,640x480"' >> tmpconfig
		elif [ "$SYS_RESOLUTION" == "3" ]; then
			echo '	Option "MetaModes" "1024x768,1024x768; 800x600,800x600; 640x480,640x480"' >> tmpconfig
		elif [ "$SYS_RESOLUTION" == "3" ]; then
			echo '	Option "MetaModes" "1280x1024,1280x1024; 1024x768,1024x768; 800x600,800x600; 640x480,640x480"' >> tmpconfig
		fi
		echo '	Option "NoTwinViewXineramaInfo" "true"  # Dont change this option, otherwise X will crash.
	Option "SWCursor" "on"
	Option "HWCursor" "off"
EndSection' >> tmpconfig
		STATION_TYPE[$MXDEVNO]=S # Do not set the Vitual in Screen section
		SYS_DUALVIEW=$((SYS_DUALVIEW-1))
    	MXDEVNO=$((MXDEVNO+1))

	fi

}

config_mx()
{
	if [ "$HEADNO" == "1" ]; then  #single head card
		case "$DRIVER" in
			"savage")
			echo 'Section "Device"
	Identifier "Videocard'$MXDEVNO'"
	Driver "'$DRIVER'"
	VendorName "'$VENDORNAME'"
	BoardName "'$BOARDNAME'"
	BusID "PCI:'$BUSID'"
	Option "shadowFB" "on"
	Option "SWCursor" "on"
	Option "HWCursor" "off"
EndSection' >> tmpconfig
    		MXDEVNO=$((MXDEVNO+1))
			;;

			*)
			echo 'Section "Device"
	Identifier "Videocard'$MXDEVNO'"
	Driver "'$DRIVER'"
	VendorName "'$VENDORNAME'"
	BoardName "'$BOARDNAME'"
	BusID "PCI:'$BUSID'"
	Option "SWCursor" "on"
	Option "HWCursor" "off"
	Option "ColorTiling" "off"
EndSection' >> tmpconfig
    		MXDEVNO=$((MXDEVNO+1))
			;;
		esac
	else  				# dual head card
		case "$DRIVER" in
   			mga)
			mga_multihead_config $1
			;;
				
    		radeon)
			DISABLEXVIDMODE=1
			radeon_multihead_config $1
			;;
		
    		nv|nvidia)
			nvidia_multihead_config $1
			;;

   			*)
			echo 'Section "Device"
	Identifier "Videocard'$MXDEVNO'"
	Driver "'$DRIVER'"
	VendorName "'$VENDORNAME'"
	BoardName "'$BOARDNAME'"
	BusID "PCI:'$BUSID'"
	Screen 0
	Option "SWCursor" "on"
	Option "HWCursor" "off"
EndSection' >> tmpconfig
    		echo 'Section "Device"
	Identifier "Videocard'$((MXDEVNO+1))'"
	Driver "'$DRIVER'"
	VendorName "'$VENDORNAME'"
	BoardName "'$BOARDNAME'"
	BusID "PCI:'$BUSID'"
	Screen 1
	Option "SWCursor" "on"
	Option "HWCursor" "off"
EndSection' >> tmpconfig
    		MXDEVNO=$((MXDEVNO+2))
			;;
		esac
	fi
}

config_x()
{
  	echo 'Section "Device"
	Identifier "Videocard'$SXDEVNO'"
	Driver "'$DRIVER'"
	VendorName "'$VENDORNAME'"
	BoardName "'$BOARDNAME'"
	BusID "PCI:'$BUSID'"
	Option "ColorTiling" "off"
EndSection' >> tmpconfig

	SXDEVNO=$((SXDEVNO+1))	
}



gen_Screen()
{
	echo '
###########################
# Screen section 
###########################' >> tmpconfig

	if [ "$1" == "-1box" ] || [ "$1" == "-ds" ] || [ "$1" == "-check" ] || \
	   [ "$1" == "-all" ]; then
		NUM_OF_HEAD=$MXDEVNO
	else
		NUM_OF_HEAD=$SXDEVNO
	fi

	if [ "$1" == "-all" -o "$1" == "-one" ]; then
		MODES="Modes \"640x480\""
	else
		if [ "$SYS_RESOLUTION" == "1" ]; then
			MODES="Modes \"640x480\""
			VIRTUAL="Virtual 1280 480"
		elif [ "$SYS_RESOLUTION" == "2" ]; then
			MODES="Modes \"800x600\" \"640x480\""
			VIRTUAL="Virtual 1600 600"
		elif [ "$SYS_RESOLUTION" == "3" ]; then
			MODES="Modes \"1024x768\" \"800x600\" \"640x480\""
			VIRTUAL="Virtual 2048 768"
		elif [ "$SYS_RESOLUTION" == "4" ]; then
			MODES="Modes \"1280x1024\" \"1024x768\" \"800x600\" \"640x480\""
			VIRTUAL="Virtual 2560 1024"
		else
			MODES="Modes \"1024x768\" \"800x600\" \"640x480\""
			VIRTUAL="Virtual 2048 768"
		fi
	fi

	for (( i=0; i<$NUM_OF_HEAD; i++ )) ; do
		if [ "${STATION_TYPE[i]}" == S ]; then
   			echo 'Section "Screen"
	Identifier "Screen'$i'"
	Device "Videocard'$i'"
	Monitor "Monitor"
	DefaultDepth 16
	SubSection "Display"
		Depth 8
		'$MODES'
	EndSubSection
	SubSection "Display"
		Depth 15
		'$MODES'
	EndSubSection
	SubSection "Display"
		Depth 16
		'$MODES'
	EndSubSection
	SubSection "Display"
		Depth 24
		'$MODES'
	EndSubSection
EndSection' >> tmpconfig 
		else  # DualView
   			echo 'Section "Screen"
	Identifier "Screen'$i'"
	Device "Videocard'$i'"
	Monitor "Monitor"
	DefaultDepth 16
	SubSection "Display"
		Depth 8
		'$MODES'
		'$VIRTUAL'
	EndSubSection
	SubSection "Display"
		Depth 15
		'$MODES'
		'$VIRTUAL'
	EndSubSection
	SubSection "Display"
		Depth 16
		'$MODES'
		'$VIRTUAL'
	EndSubSection
	SubSection "Display"
		Depth 24
		'$MODES'
		'$VIRTUAL'
	EndSubSection
EndSection' >> tmpconfig 

		fi
	done
}

#
# Create screen part in the ServerLayout section
# $1: config type
ServerLayout_screen()
{
	if [ "$1" == "-1box" ] || [ "$1" == "-ds" ] || [ "$1" == "-all" ] || [ "$1" == "-check" ]; then
		for (( i=0; i<$NUM_OF_HEAD; i++ )); do
			echo '	Screen	"Screen'$i'"' >> tmpconfig
		done
	else
		echo '	Screen	"Screen0"' >> tmpconfig
	fi
}

#
# Create Keyboard part in the ServerLayout section
# $1: config type
ServerLayout_kbd()
{
	if [ "$1" == "-1box" ] || [ "$1" == "-ds" ]; then
		echo '	InputDevice	"Keyboard0"	"CoreKeyboard"' >> tmpconfig
		for (( i=1; i<$NUM_OF_HEAD; i++ )); do
			echo '	InputDevice	"Keyboard'$i'"	"AlwaysCore"' >> tmpconfig
		done
		for (( i=0; i<$NUM_OF_HEAD; i++ )); do
			echo '	InputDevice	"Barcode'$i'"	"AlwaysCore"' >> tmpconfig
		done
		for (( i=0; i<$NUM_OF_HEAD; i++ )); do
			echo '	InputDevice	"Magreader'$i'"	"AlwaysCore"' >> tmpconfig
		done
	else
		echo '	InputDevice	"Keyboard0"	"CoreKeyboard"' >> tmpconfig
	fi
}

#
# Create Mouse part in the ServerLayout section
# $1: config type
ServerLayout_mse()
{
	if [ "$1" == "-1box" ] || [ "$1" == "-ds" ]; then
		echo '	InputDevice	"Mouse0"	"CorePointer"' >> tmpconfig
		for (( i=1; i<$NUM_OF_HEAD; i++ )); do
			echo '	InputDevice	"Mouse'$i'"	"AlwaysCore"' >> tmpconfig
		done
	else
		echo '	InputDevice	"Mouse0"	"CorePointer"' >> tmpconfig
	fi
}

#
# Create MicroTouch TouchScreen part in the ServerLayout section
# $1: config type
ServerLayout_touch()
{
	if [ "$1" == "-1box" ] || [ "$1" == "-ds" ]; then
		for (( i=0; i<$NUM_OF_HEAD; i++ )); do
			echo '	InputDevice "Touch'$i'"	"AlwaysCore"' >> tmpconfig
		done
	fi
}

# generate ServerLayout section
# $1: config type
gen_ServerLayout()
{
	echo '
##################################
# Server Layout section
##################################
Section "ServerLayout"' >> tmpconfig
	if [ "$1" == "-1box" ] || [ "$1" == "-ds" ]; then
    	echo '	Identifier     "userful.Mxorg.conf"' >> tmpconfig
	elif [ "$1" == "-all" ]; then
    	echo '	Identifier     "userful.xorg.conf.all"' >> tmpconfig
	elif [ "$1" == "-one" ]; then
    	echo '	Identifier     "userful.xorg.conf.one"' >> tmpconfig
	elif [ "$1" == "-check" ]; then
    	echo '	Identifier     "userful.xorg.conf.check"' >> tmpconfig
	fi
	ServerLayout_screen $1
	ServerLayout_kbd $1
	ServerLayout_mse $1
	if [ -e /etc/usbinput ]; then
		if grep "tch" /etc/usbinput > /dev/null 2>&1 ; then
			ServerLayout_touch $1
		fi
	fi
	echo 'EndSection' >> tmpconfig
}

# create Device section
# $1: config type
gen_Device()
{
	echo '
#########################
# Device section 
#########################' >> tmpconfig

	if [ "$1" == "-1box" ]; then
		cp -f /etc/mvgainfo videolist
	else
		if which lspci > /dev/null 2>&1; then
			lspci -n | grep "0300: " > videolist
		else
			/opt/userful/bin/listpci -n | grep "0300: " > videolist
		fi
	fi

	if [ "$1" == "-check" ]; then
		cp -f tmpconfig base-tmpconfig
	fi
	
	while read VIDEOCARD ; do
		get_card_value $1 "$VIDEOCARD"

		if [ "$1" == "-1box" ]; then
            if [ "$DRIVER" == "nv" -a "$IS_NVIDIA_DRIVER" == "false" ]; then
				HEADNO=1
			elif [ $SYS_DUALVIEW -gt 0 ]; then
				if grep "$DEVID" /opt/userful/bin/VGAINFO > /dev/null ; then
					CURR_CARD_TYPE=`grep "$DEVID" /opt/userful/bin/VGAINFO | awk -- '{print $3}'`
				fi
			else
				CURR_CARD_TYPE=S # set to singleview card
			fi

			config_mx $1
		elif [ "$1" == "-ds" ]; then
			HEADNO=2
			config_mx $1
		elif [ "$1" == "-one" ]; then
			if [ "$DRIVER" == "" ]; then
				echo "USERFUL: couldn't find VGA driver for device $VENDORID:$VIDEOID"
				DRIVER=vesa
			fi
			config_x
			break
		elif [ "$1" == "-all" ]; then
			if [ "$DRIVER" == "" ]; then
				echo "USERFUL: couldn't find VGA driver for device $VENDORID:$VIDEOID"
				HEADNO=1
				DRIVER=vesa
			#elif grep "$VENDORID:$VIDEOID" /opt/userful/bin/VGAINFO > /dev/null ; then
			#	HEADNO=`grep "$VENDORID:$VIDEOID" /opt/userful/bin/VGAINFO | awk -- '{print $2}'`
			else
				HEADNO=1
			fi
			config_mx $1
		elif [ "$1" == "-check" ]; then
			if [ "$DRIVER" == "" ]; then
				HEADNO=1
				DRIVER=vesa
				echo "$BUSID^$VENDORNAME^$BOARDNAME^$DRIVER^$HEADNO^$VENDORID:$VIDEOID" >> /etc/mvgainfo
			elif grep "$VENDORID:$VIDEOID" /opt/userful/bin/VGAINFO > /dev/null ; then
				echo "Found in VGAINFO = $VENDORID:$VIDEOID"
				HEADNO=`grep "$VENDORID:$VIDEOID" /opt/userful/bin/VGAINFO | awk -- '{print $2}'`
				echo "$BUSID^$VENDORNAME^$BOARDNAME^$DRIVER^$HEADNO^$VENDORID:$VIDEOID" >> /etc/mvgainfo
            elif [ "$DRIVER" == "nv" -a "$IS_NVIDIA_DRIVER" == "false" ]; then
				echo "There is no nvidia driver."
				HEADNO=1
				echo "$BUSID^$VENDORNAME^$BOARDNAME^$DRIVER^$HEADNO^$VENDORID:$VIDEOID" >> /etc/mvgainfo
			else
				cp -f base-tmpconfig tmpconfig
				MXDEVNO=0
				HEADNO=2
				config_mx $1
				gen_Screen $1
				gen_ServerLayout $1

				mv -f tmpconfig /etc/X11/userful.xorg.conf.check

				if [ -x /usr/X11R6/bin/Xorg ]; then
					/opt/userful/bin/mh-check /usr/X11R6/bin/Xorg 2> /dev/null
				else
					/opt/userful/bin/mh-check /usr/X11R6/bin/XFree86 2> /dev/null
				fi

				if [ "$?" == "0" ]; then
					echo "$BUSID^$VENDORNAME^$BOARDNAME^$DRIVER^2^$VENDORID:$VIDEOID" >> /etc/mvgainfo
					pkill -SIGTERM X 2> /dev/null
					sleep 5
					# make sure X is not running
					while [ -f /tmp/.X0-lock ] && [ $KILLX -lt 6 ]; do
						sleep 2
						KILLX=$((KILLX+1))
					done
					if [ -f /tmp/.X0-lock ]; then  # if X exist
						pkill -9 X 2> /dev/null
						touch /tmp/mx-config-error
					fi

				else
					echo "$BUSID^$VENDORNAME^$BOARDNAME^$DRIVER^1^$VENDORID:$VIDEOID" >> /etc/mvgainfo
					pkill -SIGTERM X 2> /dev/null
					sleep 5
				fi
			fi
		fi
	done < videolist
}

reconf_files()
{
	if [ "$1" == "-1box" ] || [ "$1" == "-ds" ]; then
		echo $NUM_OF_HEAD > /etc/X11/stations
		cp -f tmpconfig /etc/X11/userful.Mxorg.conf
		if [ $DISABLEXVIDMODE -eq 0 ]; then
			sed -i -e "/DisableVidModeExtension/d" /etc/X11/userful.Mxorg.conf
		fi
	elif [ "$1" == "-one" ]; then
		cp -f tmpconfig /etc/X11/userful.xorg.conf.one
	elif [ "$1" == "-all" ]; then
		cp -f tmpconfig /etc/X11/userful.xorg.conf.all
	fi

	# clean all the temp files
	rm -f videolist tmp-video tmpconfig base-tmpconfig
	rm -f /etc/X11/userful.xorg.conf.check
}

usage()
{
	echo "Usage:"	
	echo "$0 [config type]"	
	echo "		-1box		create config-file for 1Box-Server"
	echo "		-ds		create config-file for DiscoverStation"
	echo "		-check		create config-file for checking dual-head"
	echo "		-one		create one head config-file for normal X"
	echo "		-all		create all heads config-file for normal X"
	exit 0
}

#-------------------------------
# start here...
#-------------------------------
echo "`date +"%b %d %T"` $ProgramName: $ProgramName $1" >> $logfile

###########################
# Check arguments recieved
###########################
if [ $# != 1 ]; then
	usage $0
fi
if [ "$1" != "-1box" ] && [ "$1" != "-ds" ] && [ "$1" != "-check" ] && \
	[ "$1" != "-one" ] && [ "$1" != "-all" ]; then
	usage $0
fi

####################################
# Check system type (32bit or 64bit)
####################################
LIB=$(Check_System_Type)

####################
# Check MAXSTATIONS
####################
if [ -e /etc/userful/dm-max-stations ]; then
    source /etc/userful/dm-max-stations
else
	echo "`date +"%b %d %T"` $ProgramName: /etc/userful/dm-max-stations doesn't exist" >> $logfile
    exit 1
fi

# Initialize STATION_TYPE array based on MAXSTATIONS
for (( i=0; i<$MAXSTATIONS; i++ )); do
	STATION_TYPE[$i]=S
done

####################################################################
# Check os-info and dm-sys-info
#  - dm-sys-info : generated by config-message (Press Enter program)
####################################################################
if [ -f /etc/userful/os-info ]; then
	source /etc/userful/os-info
else
	echo "`date +"%b %d %T"` $ProgramName: /etc/userful/os-info is not available" >> $logfile
	exit 1
fi

if [ -f /etc/dm-sys-info ]; then
	source /etc/dm-sys-info
else
    if [ "$1" == "-1box" ]; then
        echo "`date +"%b %d %T"` $ProgramName: /etc/dm-sys-info is not available. Use default values." >> $logfile
    fi
	SYS_TYPE=0
	SYS_RESOLUTION=3
	SYS_DUALVIEW=0
fi

#####################################################
# check if the nVidia driver and kernel module exist.
#####################################################
if $LSPCI -n | tr "a-z" "A-Z" | grep "0300:[[:space:]]10DE:" > /dev/null 2>&1 ; then
    IS_NVIDIA_DRIVER=$(Check_nVidia_Driver)
    if [ "$IS_NVIDIA_DRIVER" == "false" ]; then
        echo "`date +"%b %d %T"` $ProgramName: nVidia driver and/or kernel module was not found." >> $logfile
    fi
fi

gen_Header $1

gen_Files $1

gen_ServerFlags $1

gen_Module $1

gen_InputDevice_kbd $1

gen_InputDevice_mse $1

gen_InputDevice_touch $1

gen_Monitor $1

gen_Device $1

gen_Screen $1

gen_ServerLayout $1

reconf_files $1
