#!/bin/bash
#
# multistation-audio-config.sh
#
#    Copyright (c) 2002-2006 Userful Corporation
#    
#    Jason Kim <jason@userful.com>
#
# DESCRIPTION
#   - This program is called whenever system starts.
#   - Update fdi
#   - Use userful callback function for hotplug
#
# Called from: multistation-devices-config.sh
# Call: multistation-audio-refresh.sh
#

logfile="/var/log/userful-start.log"
ProgramName=`basename $0`

source /etc/sysconfig/xtype

# If the XTYPE is SINGLE, then restore files and exit.
if [ -z "$XTYPE" -o "$XTYPE" == "SINGLE" ]; then

    # Restore gdm pam module
    if [ ! -f /opt/userful/bin/multistation-storage-config.sh -a -e /etc/pam.d/gdm ]; then
        #
        # disable pam_console for FC
        PAM_MODULE=""
        PAM_MODULE=`grep "pam_console.so" /etc/pam.d/gdm`
        if [ "$PAM_MODULE" != "" -a "${PAM_MODULE:0:1}" == "#" ]; then
            NEW_PAM_MODULE=${PAM_MODULE:1}
            sed -i -e "s/$PAM_MODULE/$NEW_PAM_MODULE/g" /etc/pam.d/gdm
        fi

        #
        # disable pam_devperm for SuSE
        PAM_MODULE=""
        PAM_MODULE=`grep "pam_devperm.so" /etc/pam.d/gdm`
        if [ "$PAM_MODULE" != "" -a "${PAM_MODULE:0:1}" == "#" ]; then
            NEW_PAM_MODULE=${PAM_MODULE:1}
            sed -i -e "s/$PAM_MODULE/$NEW_PAM_MODULE/g" /etc/pam.d/gdm
        fi
    fi

	if [ -f /usr/share/hal/fdi/policy/10osvendor/80-resmgr.fdi.multi-save ]; then
		mv -f /usr/share/hal/fdi/policy/10osvendor/80-resmgr.fdi.multi-save /usr/share/hal/fdi/policy/10osvendor/80-resmgr.fdi
	fi

    if [ -f /usr/share/hal/fdi/policy/20thirdparty/99-userful-multimedia-policy.fdi ]; then #FC6
        rm -f /usr/share/hal/fdi/policy/20thirdparty/99-userful-multimedia-policy.fdi
    fi

    # remove kcmartsrc
    if [ -f /usr/share/config/kcmartsrc ]; then
        rm -f /usr/share/config/kcmartsrc
    fi

	echo "`date +"%b %d %T"` $ProgramName: Multi X is not enabled." >> $logfile
	exit 0
fi

#
# add userful fdi for the audio device hotplug
if [ -d /usr/share/hal/fdi/policy/20thirdparty ]; then #FC6, SLED10, Ubuntu 6.10
	cp -f /etc/userful/setup/99-userful-multimedia-policy.fdi /usr/share/hal/fdi/policy/20thirdparty
fi

# Create softlink for callback function. 
# Callback function should be located in a certain place for now.
if [ -d /usr/lib/hal/scripts ]; then #FC6, SLED10
	ln -sf /opt/userful/bin/multistation-audio-hotplug.sh /usr/lib/hal/scripts/multistation-audio-hotplug.sh
elif [ -d /usr/share/hal/scripts ]; then #Ubuntu 6.10
	ln -sf /opt/userful/bin/multistation-audio-hotplug.sh /usr/share/hal/scripts/multistation-audio-hotplug.sh
fi

#
# remove sound from 80-resmgr.fdi for SLED linux
if [ -f /usr/share/hal/fdi/policy/10osvendor/80-resmgr.fdi ]; then
	if [ ! -f /usr/share/hal/fdi/policy/10osvendor/80-resmgr.fdi.multi-save ]; then
		pushd /usr/share/hal/fdi/policy/10osvendor/ > /dev/null
			cp 80-resmgr.fdi 80-resmgr.fdi.multi-save
			cat /etc/userful/setup/suse-resmgr-fdi.patch | patch -p0 > /dev/null 2>&1
		popd > /dev/null
	fi
fi

#
# make softlink of zenity if there isn't /usr/bin/zenity
if [ ! -f /usr/bin/zenity ]; then
	if [ -f /opt/gnome/bin/zenity ]; then
		ln -s /opt/gnome/bin/zenity /usr/bin/zenity
	fi
fi

#
# update firefoxrc file -- This is for Ubuntu for now
if which aoss > /dev/null 2>&1; then
	if [ -f /etc/firefox/firefoxrc ]; then
		sed -i -e "s/FIREFOX_DSP=.*/FIREFOX_DSP=\"aoss\"/g" /etc/firefox/firefoxrc
	fi
fi

# Update gdm pam module
if [ -e /etc/pam.d/gdm ]; then
	#
	# disable pam_console for FC
	PAM_MODULE=""
	PAM_MODULE=`grep "pam_console.so" /etc/pam.d/gdm`
	if [ "$PAM_MODULE" != "" -a "${PAM_MODULE:0:1}" != "#" ]; then
		sed -i -e "s/$PAM_MODULE/#$PAM_MODULE/g" /etc/pam.d/gdm
	fi

	#
	# disable pam_devperm for SuSE
	PAM_MODULE=""
	PAM_MODULE=`grep "pam_devperm.so" /etc/pam.d/gdm`
	if [ "$PAM_MODULE" != "" -a "${PAM_MODULE:0:1}" != "#" ]; then
		sed -i -e "s/$PAM_MODULE/#$PAM_MODULE/g" /etc/pam.d/gdm
	fi
fi

# Create kcmartsrc to disable Arts
if [ -d /usr/share/config ]; then
    echo "[Arts]" > /usr/share/config/kcmartsrc
    echo "StartServer=false" >> /usr/share/config/kcmartsrc
fi

#
# call multistation-audio-refresh.sh
/opt/userful/bin/multistation-audio-refresh.sh
