#!/bin/bash
#
#  multistation-audio-gen-conf.sh
#
# Author:
#  Jason Kim <jason@userful.com>
# 
# Description:
#  - Create ~/.asoundrc and ~/.default.pa

logfile="/var/log/userful-start.log"
ProgramName=`basename $0`

echo "`date +"%b %d %T"` $ProgramName: Found pulseaudio. Set .asoundrc and .default.pa" >> $logfile

ALSA_CARD=$1

# .asoundrc
echo '
pcm.pulse {
    type pulse
}

ctl.pulse {
    type pulse
}

pcm.!default {
    type pulse
}

ctl.!default {
    type pulse
}'  > ~/.asoundrc

# .default.pa
echo '
#!/usr/bin/pulseaudio -nF

# load sink with assigned ALSA device
load-module module-alsa-sink device=plughw:'$ALSA_CARD'
load-module module-alsa-source device=hw:'$ALSA_CARD'
load-module module-native-protocol-unix

# Set volume of first sink index
set-sink-volume 0 45000
' > ~/.default.pa
