#!/bin/bash

#******
# NAME
#   multistation-audio-install.sh
#
# AUTHOR
# 	Jason Kim <jason@userful.com>
#
# DESCRIPTION
# 	post-script after installation
#

#
# add userful fdi for the audio device hotplug
if [ -d /usr/share/hal/fdi/policy/20thirdparty ]; then #FC6, SLED10, Ubuntu 6.10
	cp -f /etc/userful/setup/99-userful-multimedia-policy.fdi /usr/share/hal/fdi/policy/20thirdparty
fi

#
# remove sound from 80-resmgr.fdi in SuSE linux
if [ -f /usr/share/hal/fdi/policy/10osvendor/80-resmgr.fdi ]; then
	if [ ! -f /usr/share/hal/fdi/policy/10osvendor/80-resmgr.fdi.multi-save ]; then
		pushd /usr/share/hal/fdi/policy/10osvendor/ > /dev/null
			cp 80-resmgr.fdi 80-resmgr.fdi.multi-save
			cat /etc/userful/setup/suse-resmgr-fdi.patch | patch -p0 > /dev/null 2>&1
		popd > /dev/null
	fi
fi

# Create softlink for callback function. 
# Callback function should be in certain place for now.
if [ -d /usr/lib/hal/scripts ]; then #FC6, SLED10, Debian4.0, openSuSE10.2
	ln -sf /opt/userful/bin/multistation-audio-hotplug.sh /usr/lib/hal/scripts/multistation-audio-hotplug.sh
elif [ -d /usr/share/hal/scripts ]; then #Ubuntu6.10
	ln -sf /opt/userful/bin/multistation-audio-hotplug.sh /usr/share/hal/scripts/multistation-audio-hotplug.sh
fi

# Create /etc/usbaudio 
/opt/userful/bin/multistation-audio-config.sh
