#!/bin/bash
#
# 	multistation-storage-hotplug.sh
#
# 	Author: 
#		Jason Kim <jason@userful.com>
#
# 	Copyright (c) 2002-2007 by Userful Corporation
#
# 	Description:
#		  This callout program from fdi removes or adds a hotplugging storage device
#		from/into /etc/multiuserdevcies.
#
# 	Called from: 99-userful-storage-policy.fdi

logfile="/var/log/userful-start.log"
CONFIG_FILE="/etc/multiuserdevices"
ProgramName=`basename $0`

if [ ! -e /var/run/x.pid -o ! -d /proc/`cat /var/run/x.pid` ]; then
	# If MX is not running, just exit.
	exit 1
fi

if [ "$HALD_ACTION" == "remove" ] ; then
	echo "`date +"%b %d %T"` $ProgramName:(Hotplug) $HAL_PROP_BLOCK_DEVICE removed." >> $logfile

	if [ -f $CONFIG_FILE ]; then
		#Remove device from CONFIG_FILE. Add a new line if the removed device was configured manually.
		cp -f $CONFIG_FILE $CONFIG_FILE.old
		BASE_BLOCK_DEVICE=`basename $HAL_PROP_BLOCK_DEVICE`

		sed -i -e "/\/dev\/$BASE_BLOCK_DEVICE/d" $CONFIG_FILE

		# Save the current device's configuration if it was manually configured.
		PRE_ASSIGNED_FLAG=`grep "$HAL_PROP_BLOCK_DEVICE" $CONFIG_FILE.old | awk '{print $4}'`
		if [ "$PRE_ASSIGNED_FLAG" == "W" ]; then
			grep "$HAL_PROP_BLOCK_DEVICE" $CONFIG_FILE.old | awk '{print "N/A","N/A",$3,$4,$5}' >> $CONFIG_FILE
		fi

	else
		# Create /etc/multiuserdevices file
		/opt/userful/bin/multistation-storage-refresh.sh
	fi

elif [ "$HALD_ACTION" == "add" ] ; then
	# Storage drive type, bus
	DRIVE_TYPE="$HAL_PROP_STORAGE_DRIVE_TYPE"
	STORAGE_BUS="$HAL_PROP_STORAGE_BUS"

	# device vendor
	DEV_VENDOR="$HAL_PROP_INFO_VENDOR"
	if [ "$DEV_VENDOR" == "" ]; then
		DEV_VENDOR="Unkown"
	else # remove blank
		DEV_VENDOR=`echo $DEV_VENDOR | tr "[[:blank:]]" "_"`
	fi

	# device product name
	DEV_PRODUCT="$HAL_PROP_INFO_PRODUCT"
	if [ "$DEV_PRODUCT" == "" ]; then
		DEV_VENDOR="Unkown"
	else # remove blank
		DEV_PRODUCT=`echo $DEV_PRODUCT | tr "[[:blank:]]" "_"`
	fi

	BLOCK_DEV="$HAL_PROP_BLOCK_DEVICE"

	# get sysfs_path
	PARENT_UDI="$HAL_PROP_INFO_PARENT"

	TEMP_UDI="$HAL_PROP_INFO_UDI"
	TEMP_PARENT_UDI=
	SUBSYSTEM=
	if [ "$STORAGE_BUS" == "usb" ]; then
		while [ "$SUBSYSTEM" != "usb" ]
		do
			TEMP_PARENT_UDI=`hal-get-property --udi "$TEMP_UDI" --key "info.parent"`
			SUBSYSTEM=`hal-get-property --udi "$TEMP_PARENT_UDI" --key "linux.subsystem"`
			TEMP_UDI=$TEMP_PARENT_UDI
		done

		DEV_PATH=`hal-get-property --udi "$TEMP_UDI" --key "linux.sysfs_path"`

	else
		DEV_PATH=`hal-get-property --udi "$PARENT_UDI" --key "linux.sysfs_path"`
	fi

	PRE_ASSIGNED_SCREEN=
	PRE_ASSIGNED_FLAG=
	if [ -f $CONFIG_FILE ]; then
		PRE_ASSIGNED_SCREEN=`grep $DEV_PATH $CONFIG_FILE | awk '{print $3}'`
		PRE_ASSIGNED_FLAG=`grep $DEV_PATH $CONFIG_FILE | awk '{print $4}'`
	fi

	if [ "$PRE_ASSIGNED_SCREEN" != "" -a "$PRE_ASSIGNED_FLAG" == "W" ] ; then
		# If the current storage device was configured manually before, follow the old configuration.
		echo "`date +"%b %d %T"` $ProgramName: Found $DEV_PRODUCT($DEV_VENDOR) on $CONFIG_FILE."  >> $logfile
		ASSIGNED_SCREEN="$PRE_ASSIGNED_SCREEN"
		ASSIGNED_FLAG="W"

	else
		if [ "$STORAGE_BUS" == "usb" ]; then
			# Find screen number base on the current audio device path.
			SCREEN_NUM=`/opt/userful/bin/get-screen-num-from-devpath -T 12 -P $DEV_PATH 2>/dev/null`

			if [ "$SCREEN_NUM" == "-1" ]; then
                #  Should decide what to do with the unassinged device
                # This part can be a library code.

                # Get current setting for the unassigned storage devices
                UNASSIGNED_DEV=`grep -m1 "^UNASSIGNED_DEVICE" /etc/userful/dm.conf  | awk -F'=' '{print $2}'`

                if [[ -z "$UNASSIGNED_DEV" ]]; then # No UNASSIGNED_DEVICE setting in dm.conf
                    echo "No setting for UNASSIGNED_DEVICE"
				    ASSIGNED_SCREEN="Shared_by_All_Stations"

                elif [[ "$UNASSIGNED_DEV" == "shared" ]]; then
                    echo "UNASSIGNED_DEVICE=shared"
				    ASSIGNED_SCREEN="Shared_by_All_Stations"

                elif [[ "$UNASSIGNED_DEV" == "disabled" ]]; then
                    echo "UNASSIGNED_DEVICE=disabled"
				    ASSIGNED_SCREEN="Disabled"

                elif [[ "$UNASSIGNED_DEV" == "onboard-sound" ]]; then
                    echo "UNASSIGNED_DEVICE=onboard-sound"

                    ONBOARD_SOUND=`grep -m1 "(pci)" /etc/usbaudio | awk '{print $3}'`

                    if [[ -n "$ONBOARD_SOUND" ]]; then
				        ASSIGNED_SCREEN=$ONBOARD_SOUND
                        SCREEN_NUM=`echo $ONBOARD_SOUND | awk -F':' '{print $2}' | awk -F'.' '{print $1}'`
                    else
				        ASSIGNED_SCREEN="Shared_by_All_Stations"
                    fi


                elif [[ ! $UNASSIGNED_DEV = *[^0-9]* ]]; then
                    echo "UNASSIGNED_DEVICE is number"
                    ASSIGNED_SCREEN="Srn:$UNASSIGNED_DEV.0"

                else
                    echo "Wrong value for UNASSIGNED_DEVICE"
				    ASSIGNED_SCREEN="Shared_by_All_Stations"
                fi

			else
				ASSIGNED_SCREEN="Srn:$SCREEN_NUM.0"
			fi

		else # share internal devices by default.
			ASSIGNED_SCREEN="Shared_by_All_Stations"
		fi

		ASSIGNED_FLAG="R/W"
	fi

	if [ "$ASSIGNED_SCREEN" == "Disabled" ]; then
		hal-set-property --udi "$UDI" --key "info.screen" --string "disabled"

	elif [ "$ASSIGNED_SCREEN" == "Shared_by_All_Stations" ]; then
		hal-set-property --udi "$UDI" --key "info.screen" --string "shared"
        # Update permission for shared device
        chmod a+rw $BLOCK_DEV

	else
		hal-set-property --udi "$UDI" --key "info.screen" --string "$SCREEN_NUM"

        # Update permission to a specific user 
        if [ -f /opt/userful/locks/user.screen$SCREEN_NUM ]; then
            ASSIGNED_USER=`cat /opt/userful/locks/user.screen$SCREEN_NUM`
            chown $ASSIGNED_USER $BLOCK_DEV 2> /dev/null
            chmod 600 $BLOCK_DEV 2> /dev/null

            chown $ASSIGNED_USER $BLOCK_DEV[0-9] 2> /dev/null
            chmod 600 $BLOCK_DEV[0-9] 2> /dev/null
        fi
	fi

	# remove same device entry(s) from /etc/multiuserdevices
	if [ -f $CONFIG_FILE -a "$DEV_PATH" != "" ]; then
		DEL_STR=`basename $DEV_PATH`
		sed -i -e "/$DEL_STR/d" $CONFIG_FILE
	fi

	# add current device to the config file /etc/multiuserdevices
	echo "`date +"%b %d %T"` $ProgramName:(Hotplug) Assign $BLOCK_DEV ($DEV_VENDOR, $DEV_PRODUCT) to $ASSIGNED_SCREEN." >> $logfile
	echo "$DEV_PRODUCT($DEV_VENDOR) $BLOCK_DEV $ASSIGNED_SCREEN $ASSIGNED_FLAG $DEV_PATH" >> $CONFIG_FILE
    chmod 644 $CONFIG_FILE

else
	echo "`date +"%b %d %T"` $ProgramName: Unkown action: $HALD_ACTION" >> $logfile
fi
