#!/bin/bash
# 
# waiting-for.sh
#
# Jason Kim <jason@userful.com>
# Copyright (c) 2002-2007 Userful Corporation
#
# Waiting for something finished.
#

logfile="/var/log/userful-start.log"
ProgramName=`basename $0`

MAX_X_START_TIME=120
MIN_X_START_TIME=5
CHECKING_INTERVAL=5

if which lspci > /dev/null 2>&1; then
	LSPCI="lspci"
else
	LSPCI="/opt/userful/bin/listpci"
fi

##
## Handle X failure
##  - Check the number of X failure.
##  - Send debug info if required.
##  - Chanage the xtype to single if Multi-X has failed more than # times.
function handle_x_fail()
{
    # /etc/userful/start-mx specifies the status of X starting
    #  0: X started successfully before
    if [ ! -e /etc/userful/start-mx ]; then
        START_MX=0
    else
        START_MX=`cat /etc/userful/start-mx`
    fi

    rm -f /tmp/X-start
    sleep 2
    clear

    START_MX=$(( $START_MX + 1 ))
    echo "(EE) X server has failed to start $START_MX times." >>  $logfile
    echo
    echo "X server has failed to start $START_MX times."
    echo

    if [ $START_MX -eq 5 ]; then
        DETAILED_MSG="(EE) Failed to start Multi-X $START_MX times."

        # Start system with normal X server
        echo "XTYPE=SINGLE" > /etc/sysconfig/xtype
        echo 0 > /etc/userful/start-mx

    elif [ $START_MX -eq 4 ]; then
        DETAILED_MSG="(EE) Failed to start Multi-X with single head configuration."
		echo "(II) Remove possible onboard video entry from the configuration." >>  $logfile

		sed -i -e "/^1:0:0.*/d" /etc/mvgainfo
		rm -f /etc/usbinput
		rm -f /etc/X11/xdm/Xservers

		if [ -f /root/xorg.conf.new ]; then
			/opt/userful/bin/dm-gen-xconfig.sh -1box
		else
   			pushd /opt/userful/bin > /dev/null
				/opt/userful/bin/mx-config-gen.sh -1box
   			popd /dev/null
		fi
		echo $START_MX > /etc/userful/start-mx

    elif [ $START_MX -eq 3 ]; then

        # submit debug info
        DETAILED_MSG="(EE) Failed to start X with normal configuration."
        /usr/share/1box-utils/submit-debug-info.sh -d "$DETAILED_MSG"

        DETAILED_MSG="(EE) Failed to start Multi-X with normal configuration."
        echo "(II) Reconfigure userful.Mxorg.conf with single head configuration" >>  $logfile

        while read VIDEOCARD; do
            BUSID=`echo $VIDEOCARD | awk -F'^' '{print $1}'`
	        VENDORNAME=`echo $VIDEOCARD | awk -F'^' '{print $2}'`
	        BOARDNAME=`echo $VIDEOCARD | awk -F'^' '{print $3}'`
	        DRIVER=`echo $VIDEOCARD | awk -F'^' '{print $4}'`
			DEVID=`echo $VIDEOCARD | awk -F'^' '{print $6}'`

			echo "$BUSID^$VENDORNAME^$BOARDNAME^$DRIVER^1^$DEVID" >> /etc/mvgainfo.new
		done < /etc/mvgainfo

        rm -f /etc/mvgainfo.fail
		mv -f /etc/mvgainfo /etc/mvgainfo.fail
		mv -f /etc/mvgainfo.new /etc/mvgainfo
		rm -f /etc/usbinput
		rm -f /etc/X11/xdm/Xservers

		if [ -f /root/xorg.conf.new ]; then
			/opt/userful/bin/dm-gen-xconfig.sh -1box
		else
   			pushd /opt/userful/bin > /dev/null
				/opt/userful/bin/mx-config-gen.sh -1box
   			popd /dev/null
		fi
		echo $START_MX > /etc/userful/start-mx

    else
        DETAILED_MSG="(EE) Failed to start X with normal configuration."
        echo "$START_MX" > /etc/userful/start-mx
    fi

    # If there is Quad-head card and it uses mach64 driver, then use ati driver
    RAGE_DRIVER=`grep "1002:4752" /opt/userful/bin/VGAINFO  | awk '{print $4}'`
    if $LSPCI -n | grep "1002:4752" > /dev/null 2>&1 && [ "$RAGE_DRIVER" == "mach64" ]; then
        sed -i -e "s/^1002:4752.*/1002:4752 1 S ati [Rage XL]/" /opt/userful/bin/VGAINFO
        rm -f /etc/X11/userful.Mxorg.conf
        echo "(EE) Use ati driver for Rage XL card." >>  $logfile
    fi

}

#------------
# Start here
#------------
if [[ -n "$1" ]]; then
    until [ -z "$1" ]; do
        case "$1" in
            --input)
                WAITING_FOR="input"
                ;;
            --hub)
                WAITING_FOR="hub"
                ;;
            --xorg)
                WAITING_FOR="xorg"
                ;;
            -interval)
                CHECKING_INTERVAL=$2
                shift 
                ;;
            *)
                echo ""
                echo "Available options:" >> $logfile
                echo "  --input  (Waiting for input devices initialized)" >> $logfile
                echo ""
        esac
        shift
    done
fi

echo "`date +"%b %d %T"` $ProgramName: $WAITING_FOR" >>  $logfile

AVAIL_HEADS=`cat /etc/X11/stations`
START_TIME=`date +%s`

if [[ "$WAITING_FOR" == "hub" ]]; then
    rm -f /tmp/usbhub-hotplug
    sleep $((AVAIL_HEADS+1))

    while [[ -e /tmp/usbhub-hotplug ]]; do
        # remove usbhub-hotplug.  usbhub hotplug agent will create this file in background.
        rm -f /tmp/usbhub-hotplug
        sleep $CHECKING_INTERVAL
    done

elif [[ "$WAITING_FOR" == "input" ]]; then

    rm -f /tmp/input-hotplug
    sleep $CHECKING_INTERVAL

    while [[ -e /tmp/input-hotplug ]]; do
        # remove input-hotplug file.  Input hotplug agent will create this file in background.
        rm -f /tmp/input-hotplug
        sleep $CHECKING_INTERVAL
    done

elif [[ "$WAITING_FOR" == "xorg" ]]; then

    # Wait unitil X server start
    # /tmp/waiting-for-x is created just before starting X server in umx-start-x.sh
    while [ ! -e /tmp/waiting-for-x ]; do
        sleep 1
    done
    rm -f /tmp/waiting-for-x

    if [ -e /tmp/X-start ]; then
        START_TIME=`cat /tmp/X-start`
        TIME_TAKEN=0
    fi

    while [ -f /tmp/X-start ]; do
        NOW=`date +%s`
        TIME_TAKEN=$(( $NOW - $START_TIME ))

        if [ $TIME_TAKEN -gt $MIN_X_START_TIME ] ; then
            # Check if X process is running.
            #pgrep X > /dev/null
            if [ -e /var/run/x.pid ]; then
                ps -p `cat /var/run/x.pid` > /dev/null
                RET=$?
            else
                RET=1
            fi

            if [ $RET -ne 0 ]; then
                # X server is not running.
                echo "`date +"%b %d %T"` $ProgramName(EE): X server has been crashed." >>  $logfile
                break
            fi
        fi

        # If X server hangs, do the error handling procedure.
        if [ $TIME_TAKEN -gt $MAX_X_START_TIME ] ; then
            pkill -9 X 2> /dev/null
            sleep 5
            echo "`date +"%b %d %T"` $ProgramName(EE): Starting X server has taken more than $MAX_X_START_TIME seconds." >>  $logfile
            break
        fi

        # Check X again after 1 second.
        sleep 1
    done

    # Check if X started properly
    if [ -f /tmp/X-start ] || [ -f /tmp/mx-config-error ]; then
        # X server failed to start
        /opt/userful/bin/vtlock -disable

        # Handle X failure
        handle_x_fail

    else
        echo "`date +"%b %d %T"` $ProgramName: X server started." >>  $logfile
        echo "0" > /etc/userful/start-mx

        # Update the current number of station, keyboard and mouse
        /opt/userful/bin/make-config-file -u

        # Disable DPMS explicitly.  DPMS hasn't been virtualized yet.
        if which xset > /dev/null 2>&1; then
            xset -display :0 -dpms
        fi
    fi
else
    # For other waitings in the future..
    :
fi
